/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.iapi.services.info.ProductVersionHolder;

public class Configuration {
    private static ProductVersionHolder dncProductVersionHolder__;
    static final String dncDriverName = "Apache Derby Network Client JDBC Driver";
    private static final byte[] dncPackageConsistencyToken;
    public static final boolean jdbcCompliant = true;
    private static final String[] dncCompatibleJREVersions;
    public static final String jdbcDerbyNETProtocol = "jdbc:derby://";
    static final boolean rangeCheckCrossConverters = true;
    static final int bugCheckLevel = 255;
    static final int defaultIsolation = 2;
    public static final int defaultFetchSize = 64;
    static final String cursorAttribute_SensitiveStatic = "SENSITIVE STATIC SCROLL ";
    static final String cursorAttribute_Insensitive = "INSENSITIVE SCROLL ";
    static final String cursorAttribute_ForUpdate = "FOR UPDATE ";
    static final String cursorAttribute_WithHold = "WITH HOLD ";
    private static SqlException exceptionsOnLoadResources;

    private Configuration() {
    }

    static ProductVersionHolder getProductVersionHolder() {
        return dncProductVersionHolder__;
    }

    public static byte[] getDncPackageConsistencyToken() {
        return (byte[])dncPackageConsistencyToken.clone();
    }

    static String[] getDncCompatibleJREVersions() {
        return (String[])dncCompatibleJREVersions.clone();
    }

    public static SqlException getExceptionOnLoadResources() {
        return exceptionsOnLoadResources;
    }

    private static void loadProductVersionHolder() throws SqlException {
        try {
            dncProductVersionHolder__ = Configuration.buildProductVersionHolder();
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new SqlException(null, new ClientMessageId("XJ095.S"), privilegedActionException.getException(), new Object[0]);
        }
        catch (IOException iOException) {
            throw SqlException.javaException(null, iOException);
        }
    }

    private static ProductVersionHolder buildProductVersionHolder() throws PrivilegedActionException, IOException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<ProductVersionHolder>(){

            @Override
            public ProductVersionHolder run() throws IOException {
                InputStream inputStream = this.getClass().getResourceAsStream("/org/apache/derby/info/dnc.properties");
                return ProductVersionHolder.getProductVersionHolderFromMyEnv(inputStream);
            }
        });
    }

    public static boolean supportsJDBC42() {
        try {
            Class.forName("java.sql.SQLType");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static {
        dncPackageConsistencyToken = new byte[]{83, 89, 83, 76, 86, 76, 48, 49};
        dncCompatibleJREVersions = new String[]{"1.5", "1.6", "1.7", "1.8"};
        exceptionsOnLoadResources = null;
        try {
            Configuration.loadProductVersionHolder();
        }
        catch (SqlException sqlException) {
            exceptionsOnLoadResources = sqlException;
        }
    }
}

