/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ackedqueue;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.logstash.ackedqueue.Queue;
import org.logstash.ackedqueue.Queueable;
import org.logstash.ackedqueue.SequencedList;

public class Batch
implements Closeable {
    private final List<Queueable> elements;
    private final long firstSeqNum;
    private final Queue queue;
    private final AtomicBoolean closed;

    public Batch(SequencedList<byte[]> serialized, Queue q) {
        this(serialized.getElements(), serialized.getSeqNums().size() == 0 ? -1L : serialized.getSeqNums().get(0), q);
    }

    public Batch(List<byte[]> elements, long firstSeqNum, Queue q) {
        this.elements = Batch.deserializeElements(elements, q);
        this.firstSeqNum = elements.isEmpty() ? -1L : firstSeqNum;
        this.queue = q;
        this.closed = new AtomicBoolean(false);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed.getAndSet(true)) {
            if (this.firstSeqNum >= 0L) {
                this.queue.ack(this.firstSeqNum, this.elements.size());
            }
        } else {
            throw new IOException("double closing batch");
        }
    }

    public int size() {
        return this.elements.size();
    }

    public List<? extends Queueable> getElements() {
        return this.elements;
    }

    public Queue getQueue() {
        return this.queue;
    }

    private static List<Queueable> deserializeElements(List<byte[]> serialized, Queue q) {
        ArrayList<Queueable> deserialized = new ArrayList<Queueable>(serialized.size());
        for (byte[] element : serialized) {
            deserialized.add(q.deserialize(element));
        }
        return deserialized;
    }
}

