/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArithmeticSequence;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyEnumerable;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.API;
import org.jruby.exceptions.JumpException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.callsite.RespondToCallSite;
import org.jruby.runtime.component.VariableEntry;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.Numeric;
import org.jruby.util.TypeConverter;

@JRubyClass(name={"Range"}, include={"Enumerable"})
public class RubyRange
extends RubyObject {
    private IRubyObject begin;
    private IRubyObject end;
    private boolean isBeginless;
    private boolean isExclusive;
    private boolean isEndless;
    private boolean isInited = false;
    private static final InspectRecursive INSPECT_RECURSIVE = new InspectRecursive();
    private static final byte[] DOTDOTDOT = new byte[]{46, 46, 46};
    private static final ObjectMarshal RANGE_MARSHAL = new ObjectMarshal(){

        public void marshalTo(Ruby runtime2, Object obj, RubyClass type2, MarshalStream marshalStream) throws IOException {
            RubyRange range = (RubyRange)obj;
            marshalStream.registerLinkTarget(range);
            List<Variable<Object>> attrs = range.getMarshalVariableList();
            attrs.add(new VariableEntry<RubyBoolean>("excl", range.isExclusive ? runtime2.getTrue() : runtime2.getFalse()));
            attrs.add(new VariableEntry<IRubyObject>("begin", range.begin));
            attrs.add(new VariableEntry<IRubyObject>("end", range.end));
            marshalStream.dumpVariables(attrs);
        }

        public Object unmarshalFrom(Ruby runtime2, RubyClass type2, UnmarshalStream input) throws IOException {
            RubyRange range = (RubyRange)input.entry(type2.allocate());
            input.ivar(null, range, null);
            IRubyObject excl = (IRubyObject)range.removeInternalVariable("excl");
            IRubyObject begin2 = (IRubyObject)range.removeInternalVariable("begin");
            IRubyObject end2 = (IRubyObject)range.removeInternalVariable("end");
            if (begin2 == null) {
                begin2 = (IRubyObject)range.removeInternalVariable("begini");
            }
            if (end2 == null) {
                end2 = (IRubyObject)range.removeInternalVariable("endi");
            }
            if (begin2 == null || end2 == null || excl == null) {
                throw runtime2.newArgumentError("bad value for range");
            }
            range.init(runtime2.getCurrentContext(), begin2, end2, excl.isTrue());
            return range;
        }
    };

    public static RubyClass createRangeClass(Ruby runtime2) {
        RubyClass result2 = runtime2.defineClass("Range", runtime2.getObject(), RubyRange::new);
        result2.setClassIndex(ClassIndex.RANGE);
        result2.setReifiedClass(RubyRange.class);
        result2.kindOf = new RubyModule.JavaClassKindOf(RubyRange.class);
        result2.setMarshal(RANGE_MARSHAL);
        result2.includeModule(runtime2.getEnumerable());
        result2.defineAnnotatedMethods(RubyRange.class);
        RubyClass bsearch2 = result2.defineClassUnder("BSearch", runtime2.getObject(), OBJECT_ALLOCATOR);
        result2.setConstantVisibility(runtime2, "BSearch", true);
        bsearch2.defineAnnotatedMethods(BSearch.class);
        return result2;
    }

    private RubyRange(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
        this.begin = this.end = runtime2.getNil();
    }

    public static RubyRange newRange(ThreadContext context, IRubyObject begin2, IRubyObject end2, boolean isExclusive) {
        RubyRange range = new RubyRange(context.runtime, context.runtime.getRange());
        range.init(context, begin2, end2, isExclusive);
        range.isInited = true;
        return range;
    }

    public static RubyRange newInclusiveRange(ThreadContext context, IRubyObject begin2, IRubyObject end2) {
        return RubyRange.newRange(context, begin2, end2, false);
    }

    public static RubyRange newExclusiveRange(ThreadContext context, IRubyObject begin2, IRubyObject end2) {
        return RubyRange.newRange(context, begin2, end2, true);
    }

    @Override
    public void copySpecialInstanceVariables(IRubyObject clone2) {
        RubyRange range = (RubyRange)clone2;
        range.begin = this.begin;
        range.end = this.end;
        range.isExclusive = this.isExclusive;
    }

    final boolean checkBegin(long length2) {
        long beg;
        long l = beg = this.isBeginless ? 0L : RubyNumeric.num2long(this.begin);
        return !(beg < 0L ? (beg += length2) < 0L : length2 < beg);
    }

    final long[] begLen(long len, int err) {
        long end2;
        long beg = this.isBeginless ? 0L : RubyNumeric.num2long(this.begin);
        long l = end2 = this.isEndless ? -1L : RubyNumeric.num2long(this.end);
        if (beg < 0L && (beg += len) < 0L) {
            if (err != 0) {
                throw this.getRuntime().newRangeError(beg + ".." + (this.isExclusive ? "." : "") + end2 + " out of range");
            }
            return null;
        }
        if (err == 0 || err == 2) {
            if (beg > len) {
                if (err != 0) {
                    throw this.getRuntime().newRangeError(beg + ".." + (this.isExclusive ? "." : "") + end2 + " out of range");
                }
                return null;
            }
            if (end2 > len) {
                end2 = len;
            }
        }
        if (end2 < 0L) {
            end2 += len;
        }
        if (!this.isExclusive || this.isEndless) {
            ++end2;
        }
        if ((len = end2 - beg) < 0L) {
            len = 0L;
        }
        return new long[]{beg, len};
    }

    final long begLen0(long len) {
        long beg;
        long l = beg = this.isBeginless ? 0L : RubyNumeric.num2long(this.begin);
        if (beg < 0L && (beg += len) < 0L) {
            throw this.getRuntime().newRangeError(beg - len + ".." + (this.isExclusive ? "." : "") + this.end + " out of range");
        }
        return beg;
    }

    final long begLen1(long len, long beg) {
        long end2;
        long l = end2 = this.isEndless ? -1L : RubyNumeric.num2long(this.end);
        if (end2 < 0L) {
            end2 += len;
        }
        if (!this.isExclusive || this.isEndless) {
            ++end2;
        }
        if ((len = end2 - beg) < 0L) {
            len = 0L;
        }
        return len;
    }

    final int[] begLenInt(int len, int err) {
        int end2;
        int beg = this.isBeginless ? 0 : RubyNumeric.num2int(this.begin);
        int n = end2 = this.isEndless ? -1 : RubyNumeric.num2int(this.end);
        if (beg < 0 && (beg += len) < 0) {
            if (err != 0) {
                throw this.getRuntime().newRangeError(this.begin + ".." + (this.isExclusive ? "." : "") + this.end + " out of range");
            }
            return null;
        }
        if (err == 0 || err == 2) {
            if (beg > len) {
                if (err != 0) {
                    throw this.getRuntime().newRangeError(this.begin + ".." + (this.isExclusive ? "." : "") + this.end + " out of range");
                }
                return null;
            }
            if (end2 > len) {
                end2 = len;
            }
        }
        if (end2 < 0) {
            end2 += len;
        }
        if (!this.isExclusive || this.isEndless) {
            ++end2;
        }
        if ((len = end2 - beg) < 0) {
            len = 0;
        }
        return new int[]{beg, len};
    }

    private void init(ThreadContext context, IRubyObject begin2, IRubyObject end2, boolean isExclusive) {
        IRubyObject result2;
        if (!(begin2 instanceof RubyFixnum && end2 instanceof RubyFixnum || end2.isNil() || begin2.isNil() || !(result2 = Helpers.invokedynamic(context, begin2, MethodNames.OP_CMP, end2)).isNil())) {
            throw context.runtime.newArgumentError("bad value for range");
        }
        this.begin = begin2;
        this.end = end2;
        this.isExclusive = isExclusive;
        this.isEndless = end2.isNil();
        this.isBeginless = begin2.isNil();
        this.isInited = true;
        if (this.metaClass.getClassIndex() == ClassIndex.RANGE) {
            this.setFrozen(true);
        }
    }

    @JRubyMethod(required=2, optional=1, checkArity=false, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block unusedBlock) {
        Arity.checkArgumentCount(context, args2, 2, 3);
        if (this.isInited) {
            throw context.runtime.newFrozenError("`initialize' called twice", this);
        }
        this.checkFrozen();
        this.init(context, args2[0], args2[1], args2.length > 2 && args2[2].isTrue());
        this.isInited = true;
        return context.nil;
    }

    @JRubyMethod(required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject original) {
        if (this.isInited) {
            throw context.runtime.newFrozenError("`initialize' called twice", this);
        }
        RubyRange other = (RubyRange)original;
        this.begin = other.begin;
        this.end = other.end;
        this.isExclusive = other.isExclusive;
        this.isEndless = other.end.isNil();
        this.isBeginless = other.begin.isNil();
        this.isInited = true;
        return context.nil;
    }

    @Override
    public RubyFixnum hash() {
        return this.hash(this.metaClass.runtime.getCurrentContext());
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        int exclusiveBit = this.isExclusive ? 1 : 0;
        long hash2 = exclusiveBit;
        hash2 = Helpers.hashStart(runtime2, hash2);
        RubyFixnum v = Helpers.safeHash(context, this.begin);
        hash2 = Helpers.murmurCombine(hash2, v.convertToInteger().getLongValue());
        v = Helpers.safeHash(context, this.end);
        hash2 = Helpers.murmurCombine(hash2, v.convertToInteger().getLongValue());
        hash2 = Helpers.murmurCombine(hash2, exclusiveBit << 24);
        hash2 = Helpers.hashEnd(hash2);
        return runtime2.newFixnum(hash2);
    }

    private static RubyString inspectValue(ThreadContext context, IRubyObject value2) {
        return (RubyString)context.safeRecurse(INSPECT_RECURSIVE, value2, value2, "inspect", true);
    }

    @Override
    public IRubyObject inspect() {
        return this.inspect(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod(name={"inspect"})
    public RubyString inspect(ThreadContext context) {
        RubyString i1 = this.isBeginless && !this.isEndless ? RubyString.newEmptyString(context.runtime) : RubyRange.inspectValue(context, this.begin).strDup(context.runtime);
        RubyString i2 = this.isEndless && !this.isBeginless ? RubyString.newEmptyString(context.runtime) : RubyRange.inspectValue(context, this.end);
        i1.cat(DOTDOTDOT, 0, this.isExclusive ? 3 : 2);
        i1.append(i2);
        return i1;
    }

    @Override
    public IRubyObject to_s() {
        return this.to_s(this.getRuntime());
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s(ThreadContext context) {
        return this.to_s(context.runtime);
    }

    private RubyString to_s(Ruby runtime2) {
        RubyString i1 = this.begin.asString().strDup(runtime2);
        RubyString i2 = this.end.asString();
        i1.cat(DOTDOTDOT, 0, this.isExclusive ? 3 : 2);
        i1.append(i2);
        return i1;
    }

    @JRubyMethod(name={"exclude_end?"})
    public RubyBoolean exclude_end_p() {
        return this.getRuntime().newBoolean(this.isExclusive);
    }

    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(ThreadContext context, IRubyObject other) {
        return this.equalityInner(context, other, MethodNames.EQL);
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        return this.equalityInner(context, other, MethodNames.OP_EQUAL);
    }

    private IRubyObject equalityInner(ThreadContext context, IRubyObject other, MethodNames equalityCheck) {
        if (this == other) {
            return context.tru;
        }
        if (!(other instanceof RubyRange)) {
            return context.fals;
        }
        RubyRange otherRange = (RubyRange)other;
        return RubyBoolean.newBoolean(context, this.isExclusive == otherRange.isExclusive && Helpers.invokedynamic(context, this.begin, equalityCheck, otherRange.begin).isTrue() && Helpers.invokedynamic(context, this.end, equalityCheck, otherRange.end).isTrue());
    }

    private static boolean isZero(IRubyObject num) {
        return num instanceof RubyFixnum && ((RubyNumeric)num).isZero();
    }

    private static IRubyObject rangeLt(ThreadContext context, IRubyObject a, IRubyObject b2) {
        return RubyRange.rangeLess(context, a, b2) < 0 ? context.tru : null;
    }

    private static int rangeLess(ThreadContext context, IRubyObject a, IRubyObject b2) {
        IRubyObject result2 = Helpers.invokedynamic(context, a, MethodNames.OP_CMP, b2);
        if (result2.isNil()) {
            return Integer.MAX_VALUE;
        }
        return RubyComparable.cmpint(context, result2, a, b2);
    }

    private static IRubyObject rangeLe(ThreadContext context, IRubyObject a, IRubyObject b2) {
        IRubyObject result2 = Helpers.invokedynamic(context, a, MethodNames.OP_CMP, b2);
        if (result2.isNil()) {
            return null;
        }
        int c = RubyComparable.cmpint(context, result2, a, b2);
        if (c == 0) {
            return RubyFixnum.zero(context.runtime);
        }
        return c < 0 ? context.tru : null;
    }

    private void rangeEach(ThreadContext context, RangeCallBack callback) {
        IRubyObject v = this.begin;
        if (this.isExclusive) {
            while (RubyRange.rangeLt(context, v, this.end) != null) {
                callback.doCall(context, v);
                v = v.callMethod(context, "succ");
                context.pollThreadEvents();
            }
        } else {
            IRubyObject c;
            while ((c = RubyRange.rangeLe(context, v, this.end)) != null && c.isTrue()) {
                callback.doCall(context, v);
                if (!RubyRange.isZero(c)) {
                    v = v.callMethod(context, "succ");
                    context.pollThreadEvents();
                    continue;
                }
                break;
            }
        }
    }

    private boolean coverRangeP(ThreadContext context, IRubyObject val) {
        if (this.begin.isNil() || RubyRange.rangeLess(context, this.begin, val) <= 0) {
            int excl = this.isExclusive ? 1 : 0;
            return this.end.isNil() || RubyRange.rangeLess(context, this.end, val) <= -excl;
        }
        return false;
    }

    private boolean coverRange(ThreadContext context, RubyRange val) {
        int valExcl;
        IRubyObject valBeg = val.begin;
        IRubyObject valEnd = val.end;
        int excl = this.isExclusive ? 1 : 0;
        int n = valExcl = val.isExclusive ? 1 : 0;
        if (!this.end.isNil() && valEnd.isNil()) {
            return false;
        }
        if (!this.begin.isNil() && valBeg.isNil()) {
            return false;
        }
        if (!valBeg.isNil() && !valEnd.isNil() && RubyRange.rangeLess(context, valBeg, valEnd) > -valExcl) {
            return false;
        }
        if (!valBeg.isNil() && !this.cover_p(context, valBeg).isTrue()) {
            return false;
        }
        int cmp2 = RubyRange.rangeLess(context, this.end, valEnd);
        if (excl == valExcl) {
            return cmp2 >= 0;
        }
        if (excl != 0) {
            return cmp2 > 0;
        }
        if (cmp2 >= 0) {
            return true;
        }
        IRubyObject nil = context.nil;
        IRubyObject valMax = API.rb_rescue_typeerror(context, nil, () -> RubyRange.sites((ThreadContext)context).max.call(context, this, val));
        if (valMax == nil) {
            return false;
        }
        cmp2 = RubyRange.rangeLess(context, this.end, valMax);
        return cmp2 >= 0 && cmp2 != Integer.MAX_VALUE;
    }

    @JRubyMethod
    public IRubyObject to_a(ThreadContext context, Block block) {
        Ruby runtime2 = context.runtime;
        if (this.isEndless) {
            throw runtime2.newRangeError("cannot convert endless range to an array");
        }
        return RubyEnumerable.to_a(context, this);
    }

    @Deprecated
    public IRubyObject each19(ThreadContext context, Block block) {
        return this.each(context, block);
    }

    @JRubyMethod(name={"each"})
    public IRubyObject each(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "each", RubyRange::size);
        }
        if (this.begin instanceof RubyFixnum && this.isEndless) {
            ((RubyFixnum)this.begin).step(context, IRubyObject.NULL_ARRAY, block);
        } else if (this.begin instanceof RubyFixnum && this.end instanceof RubyFixnum) {
            this.fixnumEach(context, block);
        } else if (this.begin instanceof RubySymbol && this.end instanceof RubySymbol) {
            this.begin.asString().uptoCommon(context, this.end.asString(), this.isExclusive, block, true);
        } else {
            IRubyObject tmp = this.begin.checkStringType();
            if (!tmp.isNil()) {
                if (this.isEndless) {
                    ((RubyString)tmp).uptoEndless(context, block);
                } else {
                    ((RubyString)tmp).uptoCommon(context, this.end, this.isExclusive, block);
                }
            } else {
                if (!RubyRange.discreteObject(context, this.begin)) {
                    throw context.runtime.newTypeError("can't iterate from " + this.begin.getMetaClass().getName());
                }
                if (!this.end.isNil()) {
                    this.rangeEach(context, (ctx, arg2) -> block.yield(ctx, arg2));
                } else {
                    IRubyObject beg = this.begin;
                    while (true) {
                        block.yield(context, beg);
                        context.pollThreadEvents();
                        beg = beg.callMethod(context, "succ");
                    }
                }
            }
        }
        return this;
    }

    private void fixnumEach(ThreadContext context, Block block) {
        long to = ((RubyFixnum)this.end).value;
        if (this.isExclusive) {
            if (to == Long.MIN_VALUE) {
                return;
            }
            --to;
        }
        RubyInteger.fixnumUpto(context, ((RubyFixnum)this.begin).value, to, block);
    }

    @Deprecated
    public IRubyObject step19(ThreadContext context, IRubyObject step2, Block block) {
        return this.step(context, step2, block);
    }

    @Deprecated
    public IRubyObject step19(ThreadContext context, Block block) {
        return this.step(context, block);
    }

    @JRubyMethod(name={"step"})
    public IRubyObject step(ThreadContext context, Block block) {
        return block.isGiven() ? this.stepCommon(context, RubyFixnum.one(context.runtime), block) : this.step(context, context.runtime.getNil(), block);
    }

    @JRubyMethod(name={"step"})
    public IRubyObject step(ThreadContext context, IRubyObject step2, Block block) {
        String method2 = "step";
        if (!block.isGiven()) {
            return this.stepEnumeratorize(context, step2, method2);
        }
        step2 = this.checkStepDomain(context, step2, method2);
        return this.stepCommon(context, step2, block);
    }

    private IRubyObject checkStepDomain(ThreadContext context, IRubyObject step2, String method2) {
        if (!(step2 instanceof RubyNumeric)) {
            step2 = step2.convertToInteger("to_int");
        }
        if (((RubyNumeric)step2).isNegative()) {
            throw context.runtime.newArgumentError(method2 + " can't be negative");
        }
        if (((RubyNumeric)step2).isZero()) {
            throw context.runtime.newArgumentError(method2 + " can't be 0");
        }
        return step2;
    }

    private IRubyObject stepEnumeratorize(ThreadContext context, IRubyObject step2, String method2) {
        if (!step2.isNil() && !(step2 instanceof RubyNumeric)) {
            step2 = step2.convertToInteger("to_int");
        }
        if (step2 instanceof RubyNumeric && ((RubyNumeric)step2).isZero()) {
            throw context.runtime.newArgumentError("step can't be 0");
        }
        if (this.begin instanceof RubyNumeric && (this.end.isNil() || this.end instanceof RubyNumeric) || this.end instanceof RubyNumeric && this.begin.isNil()) {
            IRubyObject[] iRubyObjectArray;
            if (!step2.isNil()) {
                IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
                iRubyObjectArray = iRubyObjectArray2;
                iRubyObjectArray2[0] = step2;
            } else {
                iRubyObjectArray = null;
            }
            return RubyArithmeticSequence.newArithmeticSequence(context, this, method2, iRubyObjectArray, this.begin, this.end, !step2.isNil() ? step2 : RubyFixnum.one(context.runtime), this.isExclusive ? context.tru : context.fals);
        }
        if (!step2.isNil()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, method2, new IRubyObject[]{step2}, RubyRange::stepSize);
        }
        return RubyEnumerator.enumeratorizeWithSize(context, this, method2, RubyRange::stepSize);
    }

    @JRubyMethod(name={"%"})
    public IRubyObject op_mod(ThreadContext context, IRubyObject step2) {
        return this.stepEnumeratorize(context, step2, "%");
    }

    private IRubyObject stepCommon(ThreadContext context, IRubyObject step2, Block block) {
        Ruby runtime2 = context.runtime;
        if (this.begin instanceof RubyFixnum && this.end.isNil() && step2 instanceof RubyFixnum) {
            long i2;
            long unit = step2.convertToInteger().getLongValue();
            for (i2 = this.begin.convertToInteger().getLongValue(); i2 < Long.MAX_VALUE; i2 += unit) {
                block.yield(context, RubyFixnum.newFixnum(context.runtime, i2));
            }
            IRubyObject b2 = RubyFixnum.newFixnum(context.runtime, i2);
            while (true) {
                block.yield(context, b2);
                b2 = ((RubyInteger)b2).op_plus(context, step2);
            }
        }
        if (this.begin instanceof RubyFixnum && this.end instanceof RubyFixnum && step2 instanceof RubyFixnum) {
            this.fixnumStep(context, runtime2, ((RubyFixnum)step2).getLongValue(), block);
        } else if (this.begin instanceof RubyFloat || this.end instanceof RubyFloat || step2 instanceof RubyFloat) {
            RubyNumeric.floatStep(context, runtime2, this.begin, this.end, step2, this.isExclusive, this.isEndless, block);
        } else if (this.begin instanceof RubySymbol && (this.end.isNil() || this.end instanceof RubySymbol)) {
            RubyString b3 = this.begin.asString();
            SymbolStepBlockCallBack callback = new SymbolStepBlockCallBack(block, RubyFixnum.one(runtime2), step2);
            Block blockCallback = CallBlock.newCallClosure(context, this, Signature.ONE_ARGUMENT, callback);
            if (this.end.isNil()) {
                b3.uptoEndless(context, blockCallback);
            } else {
                b3.uptoCommon(context, this.end.asString(), this.isExclusive, blockCallback);
            }
        } else if (this.begin instanceof RubyNumeric || !TypeConverter.checkToInteger(runtime2, this.begin, "to_int").isNil() || !TypeConverter.checkToInteger(runtime2, this.end, "to_int").isNil()) {
            this.numericStep(context, runtime2, step2, block);
        } else {
            IRubyObject tmp = this.begin.checkStringType();
            if (!tmp.isNil()) {
                StepBlockCallBack callback = new StepBlockCallBack(block, RubyFixnum.one(runtime2), step2);
                Block blockCallback = CallBlock.newCallClosure(context, this, Signature.ONE_ARGUMENT, callback);
                if (this.end.isNil()) {
                    ((RubyString)tmp).uptoEndless(context, blockCallback);
                } else {
                    ((RubyString)tmp).uptoCommon(context, this.end, this.isExclusive, blockCallback);
                }
            } else {
                if (!this.begin.respondsTo("succ")) {
                    throw runtime2.newTypeError("can't iterate from " + this.begin.getMetaClass().getName());
                }
                this.rangeEach(context, new StepBlockCallBack(block, RubyFixnum.one(runtime2), step2));
            }
        }
        return this;
    }

    private void fixnumStep(ThreadContext context, Ruby runtime2, long step2, Block block) {
        long i2;
        long tov;
        long to = ((RubyFixnum)this.end).getLongValue();
        if (this.isExclusive) {
            if (to == Long.MIN_VALUE) {
                return;
            }
            --to;
        }
        if (to < (tov = Long.MAX_VALUE - step2)) {
            tov = to;
        }
        for (i2 = ((RubyFixnum)this.begin).getLongValue(); i2 <= tov; i2 += step2) {
            block.yield(context, RubyFixnum.newFixnum(runtime2, i2));
        }
        if (i2 <= to) {
            block.yield(context, RubyFixnum.newFixnum(runtime2, i2));
        }
    }

    private void numericStep(ThreadContext context, Ruby runtime2, IRubyObject step2, Block block) {
        String method2 = this.isExclusive ? "<" : "<=";
        IRubyObject beg = this.begin;
        long i2 = 0L;
        while (beg.callMethod(context, method2, this.end).isTrue()) {
            block.yield(context, beg);
            beg = this.begin.callMethod(context, "+", RubyFixnum.newFixnum(runtime2, ++i2).callMethod(context, "*", step2));
        }
    }

    private static IRubyObject size(ThreadContext ctx, RubyRange recv2, IRubyObject[] args2) {
        return recv2.size(ctx);
    }

    private static IRubyObject stepSize(ThreadContext context, RubyRange self2, IRubyObject[] args2) {
        IRubyObject step2;
        Ruby runtime2 = context.runtime;
        IRubyObject begin2 = self2.begin;
        IRubyObject end2 = self2.end;
        if (args2 != null && args2.length > 0) {
            step2 = args2[0];
            if (!(step2 instanceof RubyNumeric)) {
                step2.convertToInteger();
            }
        } else {
            step2 = RubyFixnum.one(runtime2);
        }
        if (step2.callMethod(context, "<", RubyFixnum.zero(runtime2)).isTrue()) {
            throw runtime2.newArgumentError("step can't be negative");
        }
        if (!step2.callMethod(context, ">", RubyFixnum.zero(runtime2)).isTrue()) {
            throw runtime2.newArgumentError("step can't be 0");
        }
        if (begin2 instanceof RubyNumeric && end2 instanceof RubyNumeric) {
            return RubyNumeric.intervalStepSize(context, begin2, end2, step2, self2.isExclusive);
        }
        return context.nil;
    }

    @Deprecated
    public IRubyObject include_p19(ThreadContext context, IRubyObject obj) {
        return this.include_p(context, obj);
    }

    @JRubyMethod(name={"include?", "member?"}, frame=true)
    public IRubyObject include_p(ThreadContext context, IRubyObject obj) {
        IRubyObject result2 = this.includeCommon(context, obj, false);
        if (result2 != UNDEF) {
            return result2;
        }
        return Helpers.invokeSuper(context, (IRubyObject)this, obj, Block.NULL_BLOCK);
    }

    private IRubyObject includeCommon(ThreadContext context, IRubyObject val, boolean useStringCover) {
        Ruby runtime2 = context.runtime;
        boolean iterable = this.begin instanceof RubyNumeric || this.end instanceof RubyNumeric || RubyRange.linearObject(context, this.begin) || RubyRange.linearObject(context, this.end);
        JavaSites.RangeSites sites = RubyRange.sites(context);
        JavaSites.CheckedSites to_int_checked = sites.to_int_checked;
        if (iterable || !TypeConverter.convertToTypeWithCheck(context, this.begin, runtime2.getInteger(), to_int_checked).isNil() || !TypeConverter.convertToTypeWithCheck(context, this.end, runtime2.getInteger(), to_int_checked).isNil()) {
            return RubyBoolean.newBoolean(context, this.rangeIncludes(context, val));
        }
        if (this.begin instanceof RubyString || this.end instanceof RubyString) {
            if (this.begin instanceof RubyString && this.end instanceof RubyString) {
                if (useStringCover) {
                    return this.cover_p(context, val);
                }
                return RubyString.includeRange(context, (RubyString)this.begin, (RubyString)this.end, val, this.isExclusive);
            }
            if (this.begin.isNil()) {
                IRubyObject r = sites.op_cmp.call(context, val, val, this.end);
                if (r.isNil()) {
                    return context.fals;
                }
                if (RubyComparable.cmpint(context, sites.op_gt, sites.op_lt, r, val, this.end) <= 0) {
                    return context.tru;
                }
                return context.fals;
            }
            if (this.end.isNil()) {
                IRubyObject r = sites.op_cmp.call(context, this.begin, this.begin, val);
                if (r.isNil()) {
                    return context.fals;
                }
                if (RubyComparable.cmpint(context, sites.op_gt, sites.op_lt, r, this.begin, val) <= 0) {
                    return context.tru;
                }
                return context.fals;
            }
        }
        return UNDEF;
    }

    private static boolean discreteObject(ThreadContext context, IRubyObject obj) {
        return RubyRange.sites((ThreadContext)context).respond_to_succ.respondsTo(context, obj, obj, false);
    }

    private static boolean linearObject(ThreadContext context, IRubyObject obj) {
        if (obj instanceof RubyFixnum || obj instanceof RubyFloat) {
            return true;
        }
        if (obj instanceof RubyBignum) {
            return true;
        }
        if (obj instanceof RubyNumeric) {
            return true;
        }
        return obj instanceof RubyTime;
    }

    @JRubyMethod(name={"==="})
    public IRubyObject eqq_p(ThreadContext context, IRubyObject obj) {
        IRubyObject result2 = this.includeCommon(context, obj, true);
        if (result2 != UNDEF) {
            return result2;
        }
        return RubyBoolean.newBoolean(context, this.rangeIncludes(context, obj));
    }

    @JRubyMethod(name={"cover?"})
    public RubyBoolean cover_p(ThreadContext context, IRubyObject obj) {
        if (obj instanceof RubyRange) {
            return RubyBoolean.newBoolean(context, this.coverRange(context, (RubyRange)obj));
        }
        return RubyBoolean.newBoolean(context, this.rangeIncludes(context, obj));
    }

    private boolean rangeIncludes(ThreadContext context, IRubyObject val) {
        if (this.isBeginless || RubyRange.rangeLess(context, this.begin, val) <= 0) {
            int excl;
            int n = excl = this.isExclusive ? 1 : 0;
            if (this.isEndless || RubyRange.rangeLess(context, val, this.end) <= -excl) {
                return true;
            }
        }
        return false;
    }

    @JRubyMethod(frame=true)
    public IRubyObject min(ThreadContext context, Block block) {
        return this.min(context, null, block);
    }

    @JRubyMethod(frame=true)
    public IRubyObject min(ThreadContext context, IRubyObject arg2, Block block) {
        int cmp2;
        if (this.begin.isNil()) {
            throw context.runtime.newRangeError("cannot get the minimum of beginless range");
        }
        if (block.isGiven()) {
            if (this.end.isNil()) {
                throw context.runtime.newRangeError("cannot get the minimum of endless range with custom comparison method");
            }
            return arg2 != null ? Helpers.invokeSuper(context, (IRubyObject)this, arg2, block) : Helpers.invokeSuper(context, this, block);
        }
        if (arg2 != null) {
            return this.first(context, arg2);
        }
        int n = cmp2 = this.isEndless ? -1 : RubyComparable.cmpint(context, Helpers.invokedynamic(context, this.begin, MethodNames.OP_CMP, this.end), this.begin, this.end);
        if (cmp2 > 0 || cmp2 == 0 && this.isExclusive) {
            return context.nil;
        }
        return this.begin;
    }

    @JRubyMethod(frame=true)
    public IRubyObject max(ThreadContext context, Block block) {
        int cmp2;
        boolean isNumeric = this.end instanceof RubyNumeric;
        if (this.isEndless) {
            throw context.runtime.newRangeError("cannot get the maximum of endless range");
        }
        if (block.isGiven() || this.isExclusive && !isNumeric) {
            if (this.isBeginless) {
                throw context.runtime.newRangeError("cannot get the maximum of beginless range with custom comparison method");
            }
            return Helpers.invokeSuper(context, this, block);
        }
        int n = cmp2 = this.isBeginless ? -1 : RubyComparable.cmpint(context, Helpers.invokedynamic(context, this.begin, MethodNames.OP_CMP, this.end), this.begin, this.end);
        if (cmp2 > 0) {
            return context.nil;
        }
        if (this.isExclusive) {
            if (!(this.end instanceof RubyInteger)) {
                throw context.runtime.newTypeError("cannot exclude non Integer end value");
            }
            if (cmp2 == 0) {
                return context.nil;
            }
            if (!(this.begin instanceof RubyInteger)) {
                throw context.runtime.newTypeError("cannot exclude end value with non Integer begin value");
            }
            if (this.end instanceof RubyFixnum) {
                return RubyFixnum.newFixnum(context.runtime, ((RubyFixnum)this.end).getLongValue() - 1L);
            }
            return this.end.callMethod(context, "-", RubyFixnum.one(context.runtime));
        }
        return this.end;
    }

    @JRubyMethod(frame=true)
    public IRubyObject max(ThreadContext context, IRubyObject arg2, Block block) {
        if (this.isEndless) {
            throw context.runtime.newRangeError("cannot get the maximum element of endless range");
        }
        return Helpers.invokeSuper(context, (IRubyObject)this, arg2, block);
    }

    @JRubyMethod
    public IRubyObject first(ThreadContext context) {
        return this.first(context, null);
    }

    @JRubyMethod
    public IRubyObject begin(ThreadContext context) {
        return this.begin;
    }

    @JRubyMethod
    public IRubyObject first(ThreadContext context, IRubyObject arg2) {
        if (this.isBeginless) {
            throw context.runtime.newRangeError("cannot get the first element of beginless range");
        }
        if (arg2 == null) {
            return this.begin;
        }
        Ruby runtime2 = context.runtime;
        final int num = RubyNumeric.num2int(arg2);
        if (num < 0) {
            throw context.runtime.newArgumentError("negative array size (or size too big)");
        }
        final RubyArray result2 = runtime2.newArray(num);
        try {
            RubyEnumerable.callEach(context, RubyRange.sites((ThreadContext)context).each, this, Signature.ONE_ARGUMENT, new BlockCallback(){
                int n;
                {
                    this.n = num;
                }

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    return this.call(ctx, largs[0], blk);
                }

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject larg, Block blk) {
                    if (this.n-- <= 0) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    result2.append(larg);
                    return ctx.nil;
                }
            });
        }
        catch (JumpException.SpecialJump specialJump) {
            // empty catch block
        }
        return result2;
    }

    @JRubyMethod
    public IRubyObject count(ThreadContext context, Block block) {
        if (this.isBeginless || this.isEndless) {
            return RubyFloat.newFloat(context.runtime, Double.POSITIVE_INFINITY);
        }
        return RubyEnumerable.count(context, this, block);
    }

    @JRubyMethod
    public IRubyObject minmax(ThreadContext context, Block block) {
        if (block.isGiven()) {
            return Helpers.invokeSuper(context, (IRubyObject)this, (RubyModule)context.runtime.getRange(), "minmax", NULL_ARRAY, block);
        }
        return RubyArray.newArray(context.runtime, this.callMethod("min"), this.callMethod("max"));
    }

    @JRubyMethod
    public IRubyObject last(ThreadContext context) {
        if (this.isEndless) {
            throw context.runtime.newRangeError("cannot get the last element of endless range");
        }
        return this.end;
    }

    @JRubyMethod
    public IRubyObject end(ThreadContext context) {
        return this.end;
    }

    @JRubyMethod
    public IRubyObject last(ThreadContext context, IRubyObject arg2) {
        if (this.isEndless) {
            throw context.runtime.newRangeError("cannot get the last element of endless range");
        }
        if (this.begin instanceof RubyInteger && this.end instanceof RubyInteger && this.getMetaClass().checkMethodBasicDefinition("each")) {
            return this.intRangeLast(context, arg2);
        }
        return ((RubyArray)RubyKernel.new_array(context, this, this)).last(arg2);
    }

    private RubyArray intRangeLast(ThreadContext context, IRubyObject arg2) {
        IRubyObject len;
        RubyNumeric one = RubyInteger.int2fix(context.runtime, 1L);
        IRubyObject len1 = ((RubyInteger)this.end).op_minus(context, this.begin);
        if (this.isExclusive) {
            this.end = ((RubyInteger)this.end).op_minus(context, one);
            len = len1;
        } else {
            len = ((RubyInteger)len1).op_plus(context, one);
        }
        if (((RubyInteger)len).isZero() || Numeric.f_negative_p(context, (RubyInteger)len)) {
            return RubyArray.newEmptyArray(context.runtime);
        }
        long n = RubyNumeric.num2long(arg2);
        if (n < 0L) {
            throw context.runtime.newArgumentError("negative array size");
        }
        IRubyObject nv = RubyInteger.int2fix(context.runtime, n);
        if (Numeric.f_gt_p(context, nv, len)) {
            nv = len;
            n = RubyNumeric.num2long(nv);
        }
        RubyArray array2 = RubyArray.newArray(context.runtime, n);
        IRubyObject b2 = ((RubyInteger)this.end).op_minus(context, nv);
        while (n > 0L) {
            b2 = ((RubyInteger)b2).op_plus(context, one);
            array2.push(b2);
            --n;
        }
        return array2;
    }

    @JRubyMethod
    public IRubyObject size(ThreadContext context) {
        if (this.begin instanceof RubyNumeric) {
            if (this.end instanceof RubyNumeric) {
                return RubyNumeric.intervalStepSize(context, this.begin, this.end, RubyFixnum.one(context.runtime), this.isExclusive);
            }
            if (this.end.isNil()) {
                return RubyNumeric.dbl2num(context.runtime, Double.POSITIVE_INFINITY);
            }
        } else if (this.begin.isNil()) {
            return RubyNumeric.dbl2num(context.runtime, Double.POSITIVE_INFINITY);
        }
        return context.nil;
    }

    public final boolean isExcludeEnd() {
        return this.isExclusive;
    }

    public static RubyRange rangeFromRangeLike(ThreadContext context, IRubyObject rangeLike, CallSite beginSite, CallSite endSite, CallSite excludeEndSite) {
        IRubyObject begin2 = beginSite.call(context, rangeLike, rangeLike);
        IRubyObject end2 = endSite.call(context, rangeLike, rangeLike);
        IRubyObject excl = excludeEndSite.call(context, rangeLike, rangeLike);
        return RubyRange.newRange(context, begin2, end2, excl.isTrue());
    }

    public static boolean isRangeLike(ThreadContext context, IRubyObject obj, RespondToCallSite respond_to_begin, RespondToCallSite respond_to_end) {
        return respond_to_begin.respondsTo(context, obj, obj) && respond_to_end.respondsTo(context, obj, obj);
    }

    public static boolean isRangeLike(ThreadContext context, IRubyObject obj, JavaSites.CheckedSites begin_checked, JavaSites.CheckedSites end_checked, JavaSites.CheckedSites exclude_end_checked) {
        if (obj instanceof RubyArithmeticSequence) {
            return false;
        }
        return obj.checkCallMethod(context, begin_checked) != null && obj.checkCallMethod(context, end_checked) != null && obj.checkCallMethod(context, exclude_end_checked) != null;
    }

    public static IRubyObject rangeBeginLength(ThreadContext context, IRubyObject range, int len, int[] begLen, int err) {
        JavaSites.RangeSites sites = RubyRange.sites(context);
        if (!RubyRange.isRangeLike(context, range, sites.respond_to_begin, sites.respond_to_end)) {
            return context.fals;
        }
        IRubyObject _beg = sites.begin.call(context, range, range);
        IRubyObject _end = sites.end.call(context, range, range);
        boolean excludeEnd = sites.exclude_end.call(context, range, range).isTrue();
        int beg = _beg.isNil() ? 0 : _beg.convertToInteger().getIntValue();
        int end2 = _end.isNil() ? -1 : _end.convertToInteger().getIntValue();
        int origBeg = beg;
        int origEnd = end2;
        if (beg < 0 && (beg += len) < 0) {
            return RubyRange.rangeBeginLengthError(context, origBeg, origEnd, excludeEnd, err);
        }
        if (end2 < 0) {
            end2 += len;
        }
        if (!excludeEnd) {
            ++end2;
        }
        if (err == 0 || err == 2) {
            if (beg > len) {
                return RubyRange.rangeBeginLengthError(context, origBeg, origEnd, excludeEnd, err);
            }
            if (end2 > len) {
                end2 = len;
            }
        }
        if ((len = end2 - beg) < 0) {
            len = 0;
        }
        begLen[0] = beg;
        begLen[1] = len;
        return context.tru;
    }

    private static IRubyObject rangeBeginLengthError(ThreadContext context, int beg, int end2, boolean excludeEnd, int err) {
        if (err != 0) {
            throw context.runtime.newRangeError(beg + ".." + (excludeEnd ? "." : "") + end2 + " out of range");
        }
        return context.nil;
    }

    public static RangeLike rangeValues(ThreadContext context, IRubyObject range) {
        if (range instanceof RubyRange) {
            RubyRange vrange = (RubyRange)range;
            return new RangeLike(vrange.begin(context), vrange.end(context), vrange.isExcludeEnd());
        }
        if (range instanceof RubyArithmeticSequence) {
            return null;
        }
        if (range.respondsTo("begin") && range.respondsTo("end") && range.respondsTo("exclude_end?")) {
            return new RangeLike(Helpers.invoke(context, range, "begin"), Helpers.invoke(context, range, "end"), Helpers.invoke(context, range, "exclude_end?").isTrue());
        }
        return null;
    }

    private static JavaSites.RangeSites sites(ThreadContext context) {
        return context.sites.Range;
    }

    public static class BSearch {
        @JRubyMethod(meta=true)
        public static IRubyObject double_to_long_bits(ThreadContext context, IRubyObject bsearch2, IRubyObject flote) {
            long longBits = flote instanceof RubyFixnum ? Double.doubleToLongBits(((RubyFixnum)flote).getDoubleValue()) : Double.doubleToLongBits(((RubyFloat)flote).getDoubleValue());
            return context.runtime.newFixnum(longBits);
        }

        @JRubyMethod(meta=true)
        public static IRubyObject long_bits_to_double(ThreadContext context, IRubyObject bsearch2, IRubyObject fixnum) {
            return context.runtime.newFloat(Double.longBitsToDouble(((RubyFixnum)fixnum).getLongValue()));
        }

        @JRubyMethod(meta=true)
        public static IRubyObject abs(ThreadContext context, IRubyObject bsearch2, IRubyObject flote) {
            return context.runtime.newFloat(Math.abs(((RubyFloat)flote).getDoubleValue()));
        }
    }

    public static class RangeLike {
        final IRubyObject begin;
        final IRubyObject end;
        final boolean excl;

        RangeLike(IRubyObject begin2, IRubyObject end2, boolean excl) {
            this.begin = begin2;
            this.end = end2;
            this.excl = excl;
        }

        IRubyObject getRange(ThreadContext context) {
            return Helpers.invoke(context, this.end, "-", this.begin);
        }
    }

    private static class SymbolStepBlockCallBack
    extends StepBlockCallBack {
        SymbolStepBlockCallBack(Block block, RubyFixnum iter, IRubyObject step2) {
            super(block, iter, step2);
        }

        @Override
        protected void doYield(ThreadContext context, IRubyObject arg2) {
            this.block.yield(context, ((RubyString)arg2).intern());
        }
    }

    private static class StepBlockCallBack
    implements RangeCallBack,
    BlockCallback {
        final Block block;
        IRubyObject iter;
        final IRubyObject step;
        transient RubyFixnum one;

        StepBlockCallBack(Block block, RubyFixnum iter, IRubyObject step2) {
            this.block = block;
            this.iter = iter;
            this.step = step2;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block originalBlock) {
            this.doCall(context, args2[0]);
            return context.nil;
        }

        @Override
        public void doCall(ThreadContext context, IRubyObject arg2) {
            this.iter = this.iter instanceof RubyFixnum ? RubyFixnum.newFixnum(context.runtime, ((RubyFixnum)this.iter).getLongValue() - 1L) : (this.iter instanceof RubyInteger ? ((RubyInteger)this.iter).op_minus(context, 1L) : this.iter.callMethod(context, "-", this.one(context)));
            IRubyObject i2 = this.iter;
            if (i2 instanceof RubyInteger && ((RubyInteger)i2).isZero()) {
                this.doYield(context, arg2);
                this.iter = this.step;
            }
        }

        protected void doYield(ThreadContext context, IRubyObject arg2) {
            this.block.yield(context, arg2);
        }

        private RubyFixnum one(ThreadContext context) {
            RubyFixnum one = this.one;
            if (one == null) {
                one = this.one = RubyFixnum.one(context.runtime);
            }
            return one;
        }
    }

    private static interface RangeCallBack {
        public void doCall(ThreadContext var1, IRubyObject var2);
    }

    private static class InspectRecursive
    implements ThreadContext.RecursiveFunctionEx<IRubyObject> {
        private InspectRecursive() {
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject state2, IRubyObject obj, boolean recur) {
            if (recur) {
                return RubyString.newString(context.runtime, ((RubyRange)obj).isExclusive ? "(... ... ...)" : "(... .. ...)");
            }
            return RubyObject.inspect(context, obj);
        }
    }
}

