/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.heap;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.impl.store.access.heap.Heap;
import org.apache.derby.impl.store.access.heap.HeapController;

class HeapPostCommit
implements Serviceable {
    private AccessFactory access_factory = null;
    private PageKey page_key = null;

    HeapPostCommit(AccessFactory accessFactory, PageKey pageKey) {
        this.access_factory = accessFactory;
        this.page_key = pageKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void purgeCommittedDeletes(HeapController heapController, long l) throws StandardException {
        Page page = heapController.getUserPageWait(l);
        boolean bl = false;
        if (page != null) {
            try {
                int n = page.recordCount() - page.nonDeletedRecordCount();
                if (n > 0) {
                    for (int i = page.recordCount() - 1; i >= 0; --i) {
                        RecordHandle recordHandle;
                        boolean bl2 = page.isDeletedAtSlot(i);
                        if (!bl2 || !(bl2 = heapController.lockRowAtSlotNoWaitExclusive(recordHandle = page.fetchFromSlot(null, i, RowUtil.EMPTY_ROW, RowUtil.EMPTY_ROW_FETCH_DESCRIPTOR, true)))) continue;
                        bl = true;
                        page.purgeAtSlot(i, 1, false);
                    }
                }
                if (page.recordCount() == 0) {
                    bl = true;
                    heapController.removePage(page);
                }
            }
            finally {
                if (!bl) {
                    page.unlatch();
                    page = null;
                }
            }
        }
    }

    @Override
    public boolean serviceASAP() {
        return true;
    }

    @Override
    public boolean serviceImmediately() {
        return false;
    }

    @Override
    public int performWork(ContextManager contextManager) throws StandardException {
        boolean bl;
        TransactionManager transactionManager;
        block2: {
            TransactionManager transactionManager2 = (TransactionManager)this.access_factory.getAndNameTransaction(contextManager, "SystemTransaction");
            transactionManager = transactionManager2.getInternalTransaction();
            bl = false;
            try {
                HeapController heapController = (HeapController)Heap.openByContainerKey(this.page_key.getContainerId(), transactionManager, transactionManager.getRawStoreXact(), false, 132, 6, transactionManager.getRawStoreXact().newLockingPolicy(1, 4, true), null, null);
                this.purgeCommittedDeletes(heapController, this.page_key.getPageNumber());
            }
            catch (StandardException standardException) {
                if (!standardException.isLockTimeoutOrDeadlock()) break block2;
                bl = true;
            }
        }
        transactionManager.commitNoSync(1);
        transactionManager.destroy();
        return bl ? 2 : 1;
    }
}

