/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.execute.rts.RealNoRowsResultSetStatistics;
import org.apache.derby.impl.sql.execute.xplain.XPLAINUtil;

public class RealInsertResultSetStatistics
extends RealNoRowsResultSetStatistics {
    public int rowCount;
    public boolean deferred;
    public int indexesUpdated;
    public boolean userSpecifiedBulkInsert;
    public boolean bulkInsertPerformed;
    public boolean tableLock;

    public RealInsertResultSetStatistics(int n, boolean bl, int n2, boolean bl2, boolean bl3, boolean bl4, long l, ResultSetStatistics resultSetStatistics) {
        super(l, resultSetStatistics);
        this.rowCount = n;
        this.deferred = bl;
        this.indexesUpdated = n2;
        this.userSpecifiedBulkInsert = bl2;
        this.bulkInsertPerformed = bl3;
        this.tableLock = bl4;
        this.sourceResultSetStatistics = resultSetStatistics;
    }

    @Override
    public String getStatementExecutionPlanText(int n) {
        this.initFormatInfo(n);
        String string = this.userSpecifiedBulkInsert ? (this.bulkInsertPerformed ? this.indent + MessageService.getTextMessage("43X64.U", new Object[0]) : this.indent + MessageService.getTextMessage("43X65.U", new Object[0])) : this.indent + MessageService.getTextMessage("43X66.U", new Object[0]);
        string = string + "\n";
        return this.indent + MessageService.getTextMessage("43X67.U", new Object[0]) + " " + MessageService.getTextMessage(this.tableLock ? "43X14.U" : "43X15.U", new Object[0]) + ":\n" + this.indent + MessageService.getTextMessage("43X16.U", new Object[0]) + ": " + this.deferred + "\n" + string + this.indent + MessageService.getTextMessage("43X68.U", new Object[0]) + " = " + this.rowCount + "\n" + this.indent + MessageService.getTextMessage("43X18.U", new Object[0]) + " = " + this.indexesUpdated + "\n" + this.dumpTimeStats(this.indent) + (this.sourceResultSetStatistics == null ? null : this.sourceResultSetStatistics.getStatementExecutionPlanText(1));
    }

    @Override
    public String getScanStatisticsText(String string, int n) {
        if (this.sourceResultSetStatistics == null) {
            return null;
        }
        return this.sourceResultSetStatistics.getScanStatisticsText(string, n);
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    @Override
    public String getNodeName() {
        return MessageService.getTextMessage("43X69.U", new Object[0]);
    }

    @Override
    public void accept(XPLAINVisitor xPLAINVisitor) {
        int n = 0;
        if (this.sourceResultSetStatistics != null) {
            ++n;
        }
        xPLAINVisitor.setNumberOfChildren(n);
        xPLAINVisitor.visit(this);
        if (this.sourceResultSetStatistics != null) {
            this.sourceResultSetStatistics.accept(xPLAINVisitor);
        }
    }

    @Override
    public String getRSXplainType() {
        return "INSERT";
    }

    @Override
    public String getRSXplainDetails() {
        return this.bulkInsertPerformed ? "BULK" : null;
    }

    @Override
    public Object getResultSetDescriptor(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        return new XPLAINResultSetDescriptor((UUID)object, this.getRSXplainType(), this.getRSXplainDetails(), null, this.indexesUpdated, null, this.tableLock ? "T" : "R", (UUID)object2, null, null, this.rowCount, XPLAINUtil.getYesNoCharFromBoolean(this.deferred), null, null, null, null, null, null, null, (UUID)object3, (UUID)object4, (UUID)object5, (UUID)object6);
    }
}

