/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.reflect;

import java.lang.reflect.Method;
import java.util.Hashtable;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.impl.services.reflect.DirectCall;
import org.apache.derby.impl.services.reflect.LoadedGeneratedClass;
import org.apache.derby.impl.services.reflect.ReflectMethod;

public final class ReflectGeneratedClass
extends LoadedGeneratedClass {
    private final Hashtable<String, GeneratedMethod> methodCache = new Hashtable();
    private static final GeneratedMethod[] directs = new GeneratedMethod[10];

    public ReflectGeneratedClass(ClassFactory classFactory, Class clazz) {
        super(classFactory, clazz);
    }

    @Override
    public GeneratedMethod getMethod(String string) throws StandardException {
        GeneratedMethod generatedMethod = this.methodCache.get(string);
        if (generatedMethod != null) {
            return generatedMethod;
        }
        try {
            if (string.length() == 2 && string.startsWith("e")) {
                int n = string.charAt(1) - 48;
                generatedMethod = directs[n];
            } else {
                Method method = this.getJVMClass().getMethod(string, null);
                generatedMethod = new ReflectMethod(method);
            }
            this.methodCache.put(string, generatedMethod);
            return generatedMethod;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw StandardException.newException("XBCM3.S", noSuchMethodException, this.getName(), string);
        }
    }

    static {
        for (int i = 0; i < directs.length; ++i) {
            ReflectGeneratedClass.directs[i] = new DirectCall(i);
        }
    }
}

