/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.executors.ScheduledThreadPoolExecutorFactory;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.executors.LazyInitializingBlockingTaskAwareExecutorService;
import org.infinispan.executors.LazyInitializingScheduledExecutorService;
import org.infinispan.factories.AbstractComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.KnownComponentNames;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.threads.BlockingThreadFactory;
import org.infinispan.factories.threads.CoreExecutorFactory;
import org.infinispan.factories.threads.DefaultThreadFactory;
import org.infinispan.factories.threads.NonBlockingThreadFactory;

@DefaultFactoryFor(names={"org.infinispan.executors.notification", "org.infinispan.executors.blocking", "org.infinispan.executors.non-blocking", "org.infinispan.executors.expiration", "org.infinispan.executors.timeout"})
public class NamedExecutorsFactory
extends AbstractComponentFactory
implements AutoInstantiableFactory {
    @Override
    public Object construct(String componentName) {
        try {
            if (componentName.equals("org.infinispan.executors.notification")) {
                return this.createExecutorService(this.globalConfiguration.listenerThreadPool(), "org.infinispan.executors.notification", ExecutorServiceType.DEFAULT);
            }
            if (componentName.equals("org.infinispan.executors.blocking")) {
                return this.createExecutorService(this.globalConfiguration.blockingThreadPool(), "org.infinispan.executors.blocking", ExecutorServiceType.BLOCKING);
            }
            if (componentName.equals("org.infinispan.executors.expiration")) {
                return this.createExecutorService(this.globalConfiguration.expirationThreadPool(), "org.infinispan.executors.expiration", ExecutorServiceType.SCHEDULED);
            }
            if (componentName.equals("org.infinispan.executors.non-blocking")) {
                return this.createExecutorService(this.globalConfiguration.nonBlockingThreadPool(), "org.infinispan.executors.non-blocking", ExecutorServiceType.NON_BLOCKING);
            }
            if (componentName.endsWith("org.infinispan.executors.timeout")) {
                return this.createExecutorService(null, "org.infinispan.executors.timeout", ExecutorServiceType.SCHEDULED);
            }
            throw new CacheConfigurationException("Unknown named executor " + componentName);
        }
        catch (CacheConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CacheConfigurationException("Unable to instantiate ExecutorFactory for named component " + componentName, (Throwable)e);
        }
    }

    private <T extends ExecutorService> T createExecutorService(ThreadPoolConfiguration threadPoolConfiguration, String componentName, ExecutorServiceType type) {
        Object executorFactory;
        Object threadFactory;
        if (threadPoolConfiguration != null) {
            threadFactory = threadPoolConfiguration.threadFactory() != null ? threadPoolConfiguration.threadFactory() : this.createThreadFactoryWithDefaults(this.globalConfiguration, componentName, type);
            Object threadPoolFactory = threadPoolConfiguration.threadPoolFactory();
            if (threadPoolFactory != null) {
                executorFactory = threadPoolConfiguration.threadPoolFactory();
                if (type == ExecutorServiceType.NON_BLOCKING && !executorFactory.createsNonBlockingThreads()) {
                    throw log.threadPoolFactoryIsBlocking(threadPoolConfiguration.name(), componentName);
                }
            } else {
                executorFactory = this.createThreadPoolFactoryWithDefaults(componentName, type);
            }
        } else {
            threadFactory = this.createThreadFactoryWithDefaults(this.globalConfiguration, componentName, type);
            executorFactory = this.createThreadPoolFactoryWithDefaults(componentName, type);
        }
        switch (type.ordinal()) {
            case 1: {
                return (T)new LazyInitializingScheduledExecutorService((ThreadPoolExecutorFactory<ScheduledExecutorService>)executorFactory, (ThreadFactory)threadFactory);
            }
        }
        this.globalConfiguration.transport().nodeName();
        return (T)new LazyInitializingBlockingTaskAwareExecutorService((ThreadPoolExecutorFactory<ExecutorService>)executorFactory, (ThreadFactory)threadFactory, this.globalComponentRegistry.getTimeService());
    }

    private ThreadFactory createThreadFactoryWithDefaults(GlobalConfiguration globalCfg, String componentName, ExecutorServiceType type) {
        switch (type.ordinal()) {
            case 2: {
                return new BlockingThreadFactory("ISPN-blocking-thread-group", KnownComponentNames.getDefaultThreadPrio(componentName), "%c-%n-p%f-t%t", globalCfg.transport().nodeName(), KnownComponentNames.shortened(componentName));
            }
            case 3: {
                return new NonBlockingThreadFactory("ISPN-non-blocking-thread-group", KnownComponentNames.getDefaultThreadPrio(componentName), "%c-%n-p%f-t%t", globalCfg.transport().nodeName(), KnownComponentNames.shortened(componentName));
            }
        }
        return new DefaultThreadFactory(null, KnownComponentNames.getDefaultThreadPrio(componentName), "%c-%n-p%f-t%t", globalCfg.transport().nodeName(), KnownComponentNames.shortened(componentName));
    }

    private ThreadPoolExecutorFactory createThreadPoolFactoryWithDefaults(String componentName, ExecutorServiceType type) {
        switch (type.ordinal()) {
            case 1: {
                return ScheduledThreadPoolExecutorFactory.create();
            }
        }
        int defaultQueueSize = KnownComponentNames.getDefaultQueueSize(componentName);
        int defaultMaxThreads = KnownComponentNames.getDefaultThreads(componentName);
        return CoreExecutorFactory.executorFactory(defaultMaxThreads, defaultQueueSize, type == ExecutorServiceType.NON_BLOCKING);
    }

    private static enum ExecutorServiceType {
        DEFAULT,
        SCHEDULED,
        BLOCKING,
        NON_BLOCKING;

    }
}

