/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment.devmode.console;

import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.runtime.TemplateHtmlBuilder;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.runtime.management.ManagementInterfaceBuildTimeConfig;

public class ConfiguredPathInfo {
    private final String name;
    private final String endpointPath;
    private final boolean absolutePath;
    private final boolean management;

    public ConfiguredPathInfo(String name, String endpointPath, boolean isAbsolutePath, boolean management) {
        this.name = name;
        this.endpointPath = endpointPath;
        this.absolutePath = isAbsolutePath;
        this.management = management;
    }

    public String getName() {
        return this.name;
    }

    public String getEndpointPath(HttpRootPathBuildItem httpRoot) {
        if (this.absolutePath) {
            return this.endpointPath;
        }
        return TemplateHtmlBuilder.adjustRoot((String)httpRoot.getRootPath(), (String)this.endpointPath);
    }

    public String getEndpointPath(NonApplicationRootPathBuildItem nonAppRoot, ManagementInterfaceBuildTimeConfig mibt, LaunchModeBuildItem mode) {
        if (this.management && mibt.enabled) {
            String prefix = NonApplicationRootPathBuildItem.getManagementUrlPrefix(mode);
            return prefix + this.endpointPath;
        }
        if (this.absolutePath) {
            return this.endpointPath;
        }
        return TemplateHtmlBuilder.adjustRoot((String)nonAppRoot.getNormalizedHttpRootPath(), (String)this.endpointPath);
    }
}

