/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.engine.spi.BatchFetchQueue;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.graph.entity.LoadingEntityEntry;

public class SubselectFetch {
    private final QuerySpec loadingSqlAst;
    private final TableGroup ownerTableGroup;
    private final JdbcParametersList loadingJdbcParameters;
    private final JdbcParameterBindings loadingJdbcParameterBindings;
    private final Set<EntityKey> resultingEntityKeys;
    private static final RegistrationHandler NO_OP_REG_HANDLER = new RegistrationHandler(){

        @Override
        public void addKey(EntityKey key, LoadingEntityEntry entry) {
        }
    };

    public SubselectFetch(QuerySpec loadingSqlAst, TableGroup ownerTableGroup, JdbcParametersList loadingJdbcParameters, JdbcParameterBindings loadingJdbcParameterBindings, Set<EntityKey> resultingEntityKeys) {
        this.loadingSqlAst = loadingSqlAst;
        this.ownerTableGroup = ownerTableGroup;
        this.loadingJdbcParameters = loadingJdbcParameters;
        this.loadingJdbcParameterBindings = loadingJdbcParameterBindings;
        this.resultingEntityKeys = resultingEntityKeys;
    }

    public JdbcParametersList getLoadingJdbcParameters() {
        return this.loadingJdbcParameters;
    }

    public QuerySpec getLoadingSqlAst() {
        return this.loadingSqlAst;
    }

    public TableGroup getOwnerTableGroup() {
        return this.ownerTableGroup;
    }

    public JdbcParameterBindings getLoadingJdbcParameterBindings() {
        return this.loadingJdbcParameterBindings;
    }

    public Set<EntityKey> getResultingEntityKeys() {
        return this.resultingEntityKeys;
    }

    public String toString() {
        return "SubselectFetch(" + this.ownerTableGroup.getNavigablePath() + ")";
    }

    public static RegistrationHandler createRegistrationHandler(BatchFetchQueue batchFetchQueue, SelectStatement sqlAst, TableGroup tableGroup, JdbcParametersList jdbcParameters, JdbcParameterBindings jdbcParameterBindings) {
        return new StandardRegistrationHandler(batchFetchQueue, sqlAst, tableGroup, jdbcParameters, jdbcParameterBindings);
    }

    public static RegistrationHandler createRegistrationHandler(BatchFetchQueue batchFetchQueue, SelectStatement sqlAst, JdbcParametersList jdbcParameters, JdbcParameterBindings jdbcParameterBindings) {
        List<TableGroup> roots = sqlAst.getQuerySpec().getFromClause().getRoots();
        if (roots.isEmpty()) {
            return NO_OP_REG_HANDLER;
        }
        return SubselectFetch.createRegistrationHandler(batchFetchQueue, sqlAst, roots.get(0), jdbcParameters, jdbcParameterBindings);
    }

    public static class StandardRegistrationHandler
    implements RegistrationHandler {
        private final BatchFetchQueue batchFetchQueue;
        private final SelectStatement loadingSqlAst;
        private final JdbcParametersList loadingJdbcParameters;
        private final JdbcParameterBindings loadingJdbcParameterBindings;
        private final Map<NavigablePath, SubselectFetch> subselectFetches = new HashMap<NavigablePath, SubselectFetch>();

        private StandardRegistrationHandler(BatchFetchQueue batchFetchQueue, SelectStatement loadingSqlAst, TableGroup ownerTableGroup, JdbcParametersList loadingJdbcParameters, JdbcParameterBindings loadingJdbcParameterBindings) {
            this.batchFetchQueue = batchFetchQueue;
            this.loadingSqlAst = loadingSqlAst;
            this.loadingJdbcParameters = loadingJdbcParameters;
            this.loadingJdbcParameterBindings = loadingJdbcParameterBindings;
        }

        @Override
        public void addKey(EntityKey key, LoadingEntityEntry entry) {
            if (entry.getDescriptor().hasSubselectLoadableCollections()) {
                SubselectFetch subselectFetch = this.subselectFetches.computeIfAbsent(entry.getEntityInitializer().getNavigablePath(), navigablePath -> new SubselectFetch(this.loadingSqlAst.getQuerySpec(), this.loadingSqlAst.getQuerySpec().getFromClause().findTableGroup(entry.getEntityInitializer().getNavigablePath()), this.loadingJdbcParameters, this.loadingJdbcParameterBindings, new HashSet<EntityKey>()));
                subselectFetch.resultingEntityKeys.add(key);
                this.batchFetchQueue.addSubselect(key, subselectFetch);
            }
        }
    }

    public static interface RegistrationHandler {
        public void addKey(EntityKey var1, LoadingEntityEntry var2);
    }
}

