/*
 * Decompiled with CFR 0.152.
 */
package javolution;

import javolution.Javolution;
import javolution.context.PoolContext;
import javolution.lang.MathLib;
import javolution.text.Text;

final class PerfText
extends Javolution
implements Runnable {
    static volatile int COUNT = 1000;
    private final String STRING = "Concatenates this line 1000 times (resulting in a text of about 80,000 characters)";
    private final Text TEXT = Text.valueOf("Concatenates this line 1000 times (resulting in a text of about 80,000 characters)");
    private final Text ONE_CHAR = Text.valueOf('X');

    PerfText() {
    }

    public void run() {
        int n;
        int n2;
        CharSequence charSequence;
        PerfText.println("//////////////////////////////");
        PerfText.println("// Package: javolution.text //");
        PerfText.println("//////////////////////////////");
        PerfText.println("");
        PerfText.println("-- String/StringBuffer versus Text --");
        PerfText.println("");
        PerfText.println("\"Concatenates this line 1000 times (resulting in a text of about 80,000 characters)\"");
        PerfText.print("String \"+\" operator: ");
        PerfText.startTime();
        String string = "";
        int n3 = COUNT;
        while (--n3 >= 0) {
            string = string + "Concatenates this line 1000 times (resulting in a text of about 80,000 characters)";
        }
        PerfText.println(PerfText.endTime(1));
        PerfText.print("StringBuffer \"append\" : ");
        PerfText.startTime();
        for (n3 = 0; n3 < 100; ++n3) {
            charSequence = new StringBuffer();
            n2 = COUNT;
            while (--n2 >= 0) {
                ((StringBuffer)charSequence).append("Concatenates this line 1000 times (resulting in a text of about 80,000 characters)");
            }
        }
        PerfText.println(PerfText.endTime(100));
        PerfText.print("Text \"concat\" (heap): ");
        PerfText.startTime();
        for (n3 = 0; n3 < 100; ++n3) {
            charSequence = Text.EMPTY;
            n2 = COUNT;
            while (--n2 >= 0) {
                charSequence = ((Text)charSequence).concat(this.TEXT);
            }
        }
        PerfText.println(PerfText.endTime(100));
        PerfText.print("Text \"concat\" (stack): ");
        PerfText.startTime();
        for (n3 = 0; n3 < 100; ++n3) {
            PoolContext.enter();
            charSequence = Text.EMPTY;
            n2 = COUNT;
            while (--n2 >= 0) {
                charSequence = ((Text)charSequence).concat(this.TEXT);
            }
            PoolContext.exit();
        }
        PerfText.println(PerfText.endTime(100));
        PerfText.println("");
        PerfText.println("Inserts one character at random locations 1,000 times to the 80,000 characters text.");
        PerfText.print("StringBuffer insert: ");
        PerfText.startTime();
        for (n3 = 0; n3 < 100; ++n3) {
            charSequence = new StringBuffer(string);
            n2 = COUNT;
            while (--n2 >= 0) {
                n = MathLib.random(0, ((StringBuffer)charSequence).length());
                ((StringBuffer)charSequence).insert(n, 'X');
            }
        }
        PerfText.println(PerfText.endTime(100));
        PerfText.print("Text insert (heap): ");
        PerfText.startTime();
        for (n3 = 0; n3 < 100; ++n3) {
            charSequence = Text.valueOf(string);
            n2 = COUNT;
            while (--n2 >= 0) {
                n = MathLib.random(0, ((Text)charSequence).length());
                charSequence = ((Text)charSequence).insert(n, this.ONE_CHAR);
            }
        }
        PerfText.println(PerfText.endTime(100));
        PerfText.print("Text insert (stack): ");
        PerfText.startTime();
        for (n3 = 0; n3 < 100; ++n3) {
            PoolContext.enter();
            charSequence = Text.valueOf(string);
            n2 = COUNT;
            while (--n2 >= 0) {
                n = MathLib.random(0, ((Text)charSequence).length());
                charSequence = ((Text)charSequence).insert(n, this.ONE_CHAR);
            }
            PoolContext.exit();
        }
        PerfText.println(PerfText.endTime(100));
        PerfText.println("");
        PerfText.println("Delete 1,000 times one character at random location from the 80,000 characters text.");
        PerfText.print("StringBuffer delete: ");
        PerfText.startTime();
        for (n3 = 0; n3 < 100; ++n3) {
            charSequence = new StringBuffer(string);
            n2 = COUNT;
            while (--n2 >= 0) {
                n = MathLib.random(0, ((StringBuffer)charSequence).length() - 1);
                ((StringBuffer)charSequence).deleteCharAt(n);
            }
        }
        PerfText.println(PerfText.endTime(100));
        PerfText.print("Text delete (heap): ");
        PerfText.startTime();
        for (n3 = 0; n3 < 100; ++n3) {
            charSequence = Text.valueOf(string);
            n2 = COUNT;
            while (--n2 >= 0) {
                n = MathLib.random(0, ((Text)charSequence).length() - 1);
                charSequence = ((Text)charSequence).delete(n, n + 1);
            }
        }
        PerfText.println(PerfText.endTime(100));
        PerfText.print("Text delete (stack): ");
        PerfText.startTime();
        for (n3 = 0; n3 < 100; ++n3) {
            PoolContext.enter();
            charSequence = Text.valueOf(string);
            n2 = COUNT;
            while (--n2 >= 0) {
                n = MathLib.random(0, ((Text)charSequence).length() - 1);
                charSequence = ((Text)charSequence).delete(n, n + 1);
            }
            PoolContext.exit();
        }
        PerfText.println(PerfText.endTime(100));
        PerfText.println("");
    }
}

