/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils;

import jadx.gui.utils.JumpPosition;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class JumpManager {
    private final List<JumpPosition> list = new ArrayList<JumpPosition>();
    private int currentPos = 0;

    public void addPosition(JumpPosition pos) {
        if (this.ignoreJump(pos)) {
            return;
        }
        ++this.currentPos;
        if (this.currentPos >= this.list.size()) {
            this.list.add(pos);
            this.currentPos = this.list.size() - 1;
        } else {
            this.list.set(this.currentPos, pos);
            int size = this.list.size();
            for (int i = this.currentPos + 1; i < size; ++i) {
                this.list.set(i, null);
            }
        }
    }

    public void updateCurPosition(JumpPosition pos) {
        this.list.set(this.currentPos, pos);
    }

    public int size() {
        return this.list.size();
    }

    private boolean ignoreJump(JumpPosition pos) {
        JumpPosition current = this.getCurrent();
        if (current == null) {
            return false;
        }
        return pos.equals(current);
    }

    @Nullable
    private JumpPosition getCurrent() {
        if (this.currentPos >= 0 && this.currentPos < this.list.size()) {
            return this.list.get(this.currentPos);
        }
        return null;
    }

    @Nullable
    public JumpPosition getPrev() {
        if (this.currentPos == 0) {
            return null;
        }
        --this.currentPos;
        return this.list.get(this.currentPos);
    }

    @Nullable
    public JumpPosition getNext() {
        int size = this.list.size();
        if (size == 0) {
            this.currentPos = 0;
            return null;
        }
        int newPos = this.currentPos + 1;
        if (newPos >= size) {
            this.currentPos = size - 1;
            return null;
        }
        JumpPosition position = this.list.get(newPos);
        if (position == null) {
            return null;
        }
        this.currentPos = newPos;
        return position;
    }

    public void reset() {
        this.list.clear();
        this.currentPos = 0;
    }
}

