/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.xml;

import java.util.ArrayList;
import java.util.Hashtable;
import org.pentaho.di.core.xml.XMLHandlerCacheEntry;

public class XMLHandlerCache {
    public static final int MAX_NUMBER_OF_ENTRIES = 500;
    private static XMLHandlerCache cache;
    private Hashtable<XMLHandlerCacheEntry, Integer> hashtable = new Hashtable(500);
    private ArrayList<XMLHandlerCacheEntry> list = new ArrayList(500);
    private int cacheHits = 0;

    private XMLHandlerCache() {
    }

    public static final synchronized XMLHandlerCache getInstance() {
        if (cache != null) {
            return cache;
        }
        cache = new XMLHandlerCache();
        return cache;
    }

    public synchronized void storeCache(XMLHandlerCacheEntry entry, int lastChildNr) {
        this.hashtable.put(entry, lastChildNr);
        this.list.add(entry);
        if (this.list.size() > 500) {
            XMLHandlerCacheEntry cacheEntry = this.list.get(0);
            this.hashtable.remove(cacheEntry);
            this.list.remove(0);
        }
    }

    public int getLastChildNr(XMLHandlerCacheEntry entry) {
        Integer lastChildNr = this.hashtable.get(entry);
        if (lastChildNr != null) {
            ++this.cacheHits;
            return lastChildNr;
        }
        return -1;
    }

    public int getCacheHits() {
        return this.cacheHits;
    }

    public void setCacheHits(int cacheHits) {
        this.cacheHits = cacheHits;
    }

    public synchronized void clear() {
        this.hashtable.clear();
        this.list.clear();
    }
}

