/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.type;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.extension.ExtensionService;
import org.jd.gui.spi.TypeFactory;

public class TypeFactoryService {
    protected static final TypeFactoryService TYPE_FACTORY_SERVICE = new TypeFactoryService();
    protected Map<String, TypeFactories> mapProviders;

    public static TypeFactoryService getInstance() {
        return TYPE_FACTORY_SERVICE;
    }

    protected TypeFactoryService() {
        Collection<TypeFactory> providers = ExtensionService.getInstance().load(TypeFactory.class);
        this.mapProviders = new HashMap<String, TypeFactories>();
        for (TypeFactory provider : providers) {
            for (String selector : provider.getSelectors()) {
                TypeFactories typeFactories = this.mapProviders.get(selector);
                if (typeFactories == null) {
                    typeFactories = new TypeFactories();
                    this.mapProviders.put(selector, typeFactories);
                }
                typeFactories.add(provider);
            }
        }
    }

    public TypeFactory get(Container.Entry entry) {
        TypeFactory typeFactory = this.get(entry.getContainer().getType(), entry);
        return typeFactory != null ? typeFactory : this.get("*", entry);
    }

    public TypeFactory get(String containerType, Container.Entry entry) {
        String path = entry.getPath();
        String type = entry.isDirectory() ? "dir" : "file";
        String prefix = containerType + ':' + type + ':';
        TypeFactories typeFactories = this.mapProviders.get(prefix + path);
        TypeFactory factory = null;
        if (typeFactories != null) {
            factory = typeFactories.match(path);
        }
        if (factory == null) {
            int lastSlashIndex = path.lastIndexOf(47);
            String name = path.substring(lastSlashIndex + 1);
            typeFactories = this.mapProviders.get(prefix + "*/" + name);
            if (typeFactories != null) {
                factory = typeFactories.match(path);
            }
            if (factory == null) {
                int index = name.lastIndexOf(46);
                if (index != -1) {
                    String extension = name.substring(index + 1);
                    typeFactories = this.mapProviders.get(prefix + "*." + extension);
                    if (typeFactories != null) {
                        factory = typeFactories.match(path);
                    }
                }
                if (factory == null && (typeFactories = this.mapProviders.get(prefix + '*')) != null) {
                    factory = typeFactories.match(path);
                }
            }
        }
        return factory;
    }

    protected static class TypeFactories {
        protected HashMap<String, TypeFactory> factories = new HashMap();
        protected TypeFactory defaultFactory;

        protected TypeFactories() {
        }

        public void add(TypeFactory factory) {
            Pattern pathPattern = factory.getPathPattern();
            if (pathPattern != null) {
                this.factories.put(pathPattern.pattern(), factory);
            } else {
                this.defaultFactory = factory;
            }
        }

        public TypeFactory match(String path) {
            for (TypeFactory factory : this.factories.values()) {
                Matcher matcher = factory.getPathPattern().matcher(path);
                if (!matcher.matches()) continue;
                return factory;
            }
            return this.defaultFactory;
        }
    }
}

