/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import net.sf.saxon.regex.OpRepeat;
import net.sf.saxon.regex.Operation;
import net.sf.saxon.regex.REFlags;
import net.sf.saxon.regex.REMatcher;
import net.sf.saxon.regex.REProgram;
import net.sf.saxon.z.IntIterator;

public class OpReluctantFixed
extends OpRepeat {
    private final int len;

    OpReluctantFixed(Operation op, int min, int max, int len) {
        super(op, min, max, false);
        this.len = len;
    }

    @Override
    public int getMatchLength() {
        return this.min == this.max ? this.min * this.len : -1;
    }

    @Override
    public int matchesEmptyString() {
        if (this.min == 0) {
            return 7;
        }
        return this.op.matchesEmptyString();
    }

    @Override
    public Operation optimize(REProgram program, REFlags flags) {
        this.op = this.op.optimize(program, flags);
        return this;
    }

    @Override
    public IntIterator iterateMatches(final REMatcher matcher, final int position) {
        return new IntIterator(){
            private int pos;
            private int count;
            private boolean started;
            {
                this.pos = position;
                this.count = 0;
                this.started = false;
            }

            @Override
            public boolean hasNext() {
                if (!this.started) {
                    this.started = true;
                    while (this.count < OpReluctantFixed.this.min) {
                        IntIterator child = OpReluctantFixed.this.op.iterateMatches(matcher, this.pos);
                        if (child.hasNext()) {
                            this.pos = child.next();
                            ++this.count;
                            continue;
                        }
                        return false;
                    }
                    return true;
                }
                if (this.count < OpReluctantFixed.this.max) {
                    matcher.clearCapturedGroupsBeyond(this.pos);
                    IntIterator child = OpReluctantFixed.this.op.iterateMatches(matcher, this.pos);
                    if (child.hasNext()) {
                        this.pos = child.next();
                        ++this.count;
                        return true;
                    }
                }
                return false;
            }

            @Override
            public int next() {
                return this.pos;
            }
        };
    }
}

