/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.text;

import com.lowagie.text.Chapter;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.text.RtfSection;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RtfChapter
extends RtfSection {
    public RtfChapter(RtfDocument rtfDocument, Chapter chapter) {
        super(rtfDocument, chapter);
    }

    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.writeContent(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void writeContent(OutputStream outputStream) throws IOException {
        if (this.document.getLastElementWritten() != null && !(this.document.getLastElementWritten() instanceof RtfChapter)) {
            outputStream.write("\\page".getBytes());
        }
        outputStream.write("\\sectd".getBytes());
        this.document.getDocumentHeader().writeSectionDefinition(outputStream);
        if (this.title != null) {
            this.title.writeContent(outputStream);
        }
        for (int i = 0; i < this.items.size(); ++i) {
            RtfBasicElement rtfBasicElement = (RtfBasicElement)this.items.get(i);
            rtfBasicElement.writeContent(outputStream);
        }
        outputStream.write("\\sect".getBytes());
    }
}

