'use strict';

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var MetricsAggregationBase = require('./metrics-aggregation-base');

var ES_REF_URL = 'https://www.elastic.co/guide/en/elasticsearch/reference/current/search-aggregations-metrics-valuecount-aggregation.html';

/**
 * A single-value metrics aggregation that counts the number of values that
 * are extracted from the aggregated documents. These values can be extracted
 * either from specific fields in the documents, or be generated by a provided
 * script. Typically, this aggregator will be used in conjunction with other
 * single-value aggregations.
 *
 * [Elasticsearch reference](https://www.elastic.co/guide/en/elasticsearch/reference/current/search-aggregations-metrics-valuecount-aggregation.html)
 *
 * Aggregation that counts the number of values that are extracted from the
 * aggregated documents.
 *
 * @example
 * const agg = esb.valueCountAggregation('types_count', 'type');
 *
 * @example
 * const agg = esb.valueCountAggregation('types_count').script(
 *     esb.script('inline', "doc['type'].value")
 * );
 *
 * @param {string} name The name which will be used to refer to this aggregation.
 * @param {string=} field The field to aggregate on
 *
 * @extends MetricsAggregationBase
 */

var ValueCountAggregation = function (_MetricsAggregationBa) {
    (0, _inherits3.default)(ValueCountAggregation, _MetricsAggregationBa);

    // eslint-disable-next-line require-jsdoc
    function ValueCountAggregation(name, field) {
        (0, _classCallCheck3.default)(this, ValueCountAggregation);
        return (0, _possibleConstructorReturn3.default)(this, (ValueCountAggregation.__proto__ || Object.getPrototypeOf(ValueCountAggregation)).call(this, name, 'value_count', field));
    }

    /**
     * @override
     * @throws {Error} This method cannot be called on ValueCountAggregation
     */


    (0, _createClass3.default)(ValueCountAggregation, [{
        key: 'format',
        value: function format() {
            console.log('Please refer ' + ES_REF_URL);
            throw new Error('format is not supported in ValueCountAggregation');
        }
    }]);
    return ValueCountAggregation;
}(MetricsAggregationBase);

module.exports = ValueCountAggregation;