function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
import React, { useEffect, useRef } from 'react';
export var getDeprecatedMessage = function getDeprecatedMessage(message) {
  return "[DEPRECATED] ".concat(message);
};
export var deprecatedComponentWarning = function deprecatedComponentWarning(_ref) {
  var newComponentName = _ref.newComponentName,
      version = _ref.version,
      getMessage = _ref.getMessage;
  return function (Component) {
    var deprecatedComponentName = Component.displayName || Component.name;

    var DeprecatedWrapper = function DeprecatedWrapper(props) {
      useEffect(function () {
        var defaultMessage = version ? "".concat(deprecatedComponentName, " is deprecated in favor of ").concat(newComponentName, " and will be removed in v").concat(version, ".") : "".concat(deprecatedComponentName, " is deprecated in favor of ").concat(newComponentName, " and will be removed.");
        var message = (getMessage === null || getMessage === void 0 ? void 0 : getMessage(deprecatedComponentName)) || defaultMessage;
        var deprecatedMessage = getDeprecatedMessage(message);
        console.warn(deprecatedMessage);
      }, []);
      return /*#__PURE__*/React.createElement(Component, props);
    };

    Object.defineProperty(DeprecatedWrapper, 'name', {
      value: deprecatedComponentName
    });
    return DeprecatedWrapper;
  };
};
export var useDeprecatedPropWarning = function useDeprecatedPropWarning(_ref2) {
  var props = _ref2.props,
      version = _ref2.version,
      getMessage = _ref2.getMessage;
  var warnedProps = useRef(new Set()).current;
  useEffect(function () {
    Object.entries(props).forEach(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 2),
          name = _ref4[0],
          value = _ref4[1];

      if (value !== undefined && !warnedProps.has(name)) {
        var defaultMessage = version ? "The `".concat(name, "` prop is deprecated and will be removed in v").concat(version, ".") : "The `".concat(name, "` prop is deprecated and will be removed.");
        var message = (getMessage === null || getMessage === void 0 ? void 0 : getMessage(name)) || defaultMessage;
        var deprecatedMessage = getDeprecatedMessage(message);
        warnedProps.add(name);
        console.warn(deprecatedMessage);
      }
    });
  }, [warnedProps, props, version, getMessage]);
};