"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.GET_ALERTS_SORT_FILTERS = void 0;

var _lodash = _interopRequireDefault(require("lodash"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const GET_ALERTS_SORT_FILTERS = {
  MONITOR_NAME: 'monitor_name',
  TRIGGER_NAME: 'trigger_name',
  START_TIME: 'start_time',
  END_TIME: 'end_time',
  ACKNOWLEDGE_TIME: 'acknowledged_time'
};
exports.GET_ALERTS_SORT_FILTERS = GET_ALERTS_SORT_FILTERS;

class AlertService {
  constructor(esDriver) {
    _defineProperty(this, "getAlerts", async (context, req, res) => {
      const {
        from = 0,
        size = 20,
        search = '',
        sortDirection = 'desc',
        sortField = GET_ALERTS_SORT_FILTERS.START_TIME,
        severityLevel = 'ALL',
        alertState = 'ALL',
        monitorIds = [],
        monitorType = 'monitor'
      } = req.query;
      var params;

      switch (sortField) {
        case GET_ALERTS_SORT_FILTERS.MONITOR_NAME:
          params = {
            sortString: `${sortField}.keyword`,
            sortOrder: sortDirection
          };
          break;

        case GET_ALERTS_SORT_FILTERS.TRIGGER_NAME:
          params = {
            sortString: `${sortField}.keyword`,
            sortOrder: sortDirection
          };
          break;

        case GET_ALERTS_SORT_FILTERS.END_TIME:
          params = {
            sortString: sortField,
            sortOrder: sortDirection,
            missing: sortDirection === 'asc' ? '_last' : '_first'
          };
          break;

        case GET_ALERTS_SORT_FILTERS.ACKNOWLEDGE_TIME:
          params = {
            sortString: sortField,
            sortOrder: sortDirection,
            missing: '_last'
          };
          break;

        default:
          // If the sortField parsed from the URL isn't a valid option for this API, use a default option.
          params = {
            sortString: GET_ALERTS_SORT_FILTERS.START_TIME,
            sortOrder: sortDirection
          };
      }

      params.startIndex = from;
      params.size = size;
      params.severityLevel = severityLevel;
      params.alertState = alertState;
      params.searchString = search;
      if (search.trim()) params.searchString = `*${search.trim().split(' ').join('* *')}*`;

      if (monitorIds.length > 0) {
        const idField = monitorType === 'composite' ? 'workflowIds' : 'monitorId';
        params[idField] = !Array.isArray(monitorIds) ? monitorIds : monitorIds[0];
      }

      const {
        callAsCurrentUser
      } = this.esDriver.asScoped(req);

      try {
        const resp = await callAsCurrentUser('alerting.getAlerts', params);
        const alerts = resp.alerts.map(hit => {
          const alert = hit;
          const id = hit.alert_id;
          const version = hit.alert_version;
          return {
            id,
            ...alert,
            version,
            alert_source: !!alert.workflow_id ? 'workflow' : 'monitor'
          };
        });
        const totalAlerts = resp.totalAlerts;
        return res.ok({
          body: {
            ok: true,
            alerts,
            totalAlerts
          }
        });
      } catch (err) {
        console.error(err.message);
        return res.ok({
          body: {
            ok: false,
            err: err.message
          }
        });
      }
    });

    _defineProperty(this, "getWorkflowAlerts", async (context, req, res) => {
      const {
        callAsCurrentUser
      } = this.esDriver.asScoped(req);

      try {
        const resp = await callAsCurrentUser('alerting.getWorkflowAlerts', req.query);
        return res.ok({
          body: {
            ok: true,
            resp
          }
        });
      } catch (err) {
        console.error(err.message);
        return res.ok({
          body: {
            ok: false,
            err: err.message
          }
        });
      }
    });

    this.esDriver = esDriver;
  }

}

exports.default = AlertService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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