'''OpenGL extension NV.clip_space_w_scaling

This module customises the behaviour of the 
OpenGL.raw.GL.NV.clip_space_w_scaling to provide a more 
Python-friendly API

Overview (from the spec)
	
	Virtual Reality (VR) applications often involve a post-processing step to
	apply a "barrel" distortion to the rendered image to correct the
	"pincushion" distortion introduced by the optics in a VR device. The
	barrel distorted image has lower resolution along the edges compared to
	the center.  Since the original image is rendered at high resolution,
	which is uniform across the complete image, a lot of pixels towards the
	edges do not make it to the final post-processed image.
	
	This extension also provides a mechanism to render VR scenes at a
	non-uniform resolution, in particular a resolution that falls linearly
	from the center towards the edges.  This is achieved by scaling the "w"
	coordinate of the vertices in the clip space before perspective divide.
	The clip space "w" coordinate of the vertices may be offset as of a
	function of "x" and "y" coordinates as follows:
	
	        w' = w + Ax + By
	
	In the intended use case for viewport position scaling, an application
	should use a set of 4 viewports, one for each of the 4 quadrants of a
	Cartesian coordinate system.  Each viewport is set to the dimension of the
	image, but is scissored to the quadrant it represents.  The application
	should specify A and B coefficients of the w-scaling equation above,
	that have the same value, but different signs, for each of the viewports.
	The signs of A and B should match the signs of X and Y for the quadrant
	that they represent such that the value of "w'" will always be greater
	than or equal to the original "w" value for the entire image. Since the
	offset to "w", (Ax + By), is always positive and increases with the
	absolute values of "x" and "y", the effective resolution will fall off
	linearly from the center of the image to its edges.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/clip_space_w_scaling.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.NV.clip_space_w_scaling import *
from OpenGL.raw.GL.NV.clip_space_w_scaling import _EXTENSION_NAME

def glInitClipSpaceWScalingNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION