/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import org.jhotdraw.util.Images;
import org.jhotdraw.util.ResourceBundleUtil;

public class ColorIcon
implements Icon {
    private Color fillColor;
    private static BufferedImage noColorImage;
    private int width;
    private int height;
    private String name;

    public ColorIcon(int n) {
        this(new Color(n));
    }

    public ColorIcon(Color color) {
        this(color, color == null ? ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels").getToolTipTextProperty("attribute.color.noColor") : color.getRed() + "," + color.getGreen() + "," + color.getBlue(), 14, 14);
    }

    public ColorIcon(int n, String string) {
        this(new Color(n), string, 14, 14);
    }

    public ColorIcon(Color color, String string) {
        this(color, string, 14, 14);
    }

    public ColorIcon(Color color, String string, int n, int n2) {
        this.fillColor = color;
        this.name = string;
        this.width = n;
        this.height = n2;
        if (noColorImage == null) {
            noColorImage = Images.toBufferedImage(Images.createImage(ColorIcon.class, "/org/jhotdraw/draw/action/images/attribute.color.noColor.png"));
        }
    }

    public Color getColor() {
        return this.fillColor;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.fillColor == null) {
            if (this.width == noColorImage.getWidth() && this.height == noColorImage.getHeight()) {
                graphics.drawImage(noColorImage, n, n2, component);
            } else {
                graphics.setColor(Color.WHITE);
                graphics.fillRect(n + 1, n2 + 1, this.width - 2, this.height - 2);
                graphics.setColor(Color.red);
                int[] nArray = new int[]{n + 2, n + this.width - 5, n + this.width - 3, n + this.width - 3, n + 4, n + 2};
                int[] nArray2 = new int[]{n2 + this.height - 5, n2 + 2, n2 + 2, n2 + 4, n2 + this.height - 3, n2 + this.height - 3};
                graphics.fillPolygon(nArray, nArray2, nArray.length);
            }
        } else {
            graphics.setColor(this.fillColor);
            graphics.fillRect(n + 1, n2 + 1, this.width - 2, this.height - 2);
        }
        graphics.setColor(new Color(0x666666));
        graphics.drawLine(n, n2, n + this.width - 1, n2);
        graphics.drawLine(n + this.width - 1, n2, n + this.width - 1, n2 + this.width - 1);
        graphics.drawLine(n + this.width - 1, n2 + this.height - 1, n, n2 + this.height - 1);
        graphics.drawLine(n, n2 + this.height - 1, n, n2);
    }
}

