/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message.extension;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ClientEsniInner;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EncryptedSniComputation;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EncryptedServerNameIndicationExtensionMessage
extends ExtensionMessage {
    private static final Logger LOGGER = LogManager.getLogger();
    private EsniMessageType esniMessageTypeConfig;
    @ModifiableVariableProperty
    private ModifiableByteArray cipherSuite;
    @HoldsModifiableVariable
    private KeyShareEntry keyShareEntry = new KeyShareEntry();
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger recordDigestLength;
    @ModifiableVariableProperty
    private ModifiableByteArray recordDigest;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger encryptedSniLength;
    @ModifiableVariableProperty
    private ModifiableByteArray encryptedSni;
    @HoldsModifiableVariable
    private ClientEsniInner clientEsniInner = new ClientEsniInner();
    @ModifiableVariableProperty
    private ModifiableByteArray clientEsniInnerBytes;
    @HoldsModifiableVariable
    private EncryptedSniComputation encryptedSniComputation = new EncryptedSniComputation();
    @ModifiableVariableProperty
    private ModifiableByteArray serverNonce;

    public EncryptedServerNameIndicationExtensionMessage() {
        super(ExtensionType.ENCRYPTED_SERVER_NAME_INDICATION);
    }

    public ModifiableByteArray getCipherSuite() {
        return this.cipherSuite;
    }

    public void setCipherSuite(ModifiableByteArray cipherSuite) {
        this.cipherSuite = cipherSuite;
    }

    public void setCipherSuite(byte[] cipherSuite) {
        this.cipherSuite = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.cipherSuite, (byte[])cipherSuite);
    }

    public KeyShareEntry getKeyShareEntry() {
        return this.keyShareEntry;
    }

    public void setKeyShareEntry(KeyShareEntry keyShareEntry) {
        this.keyShareEntry = keyShareEntry;
    }

    public ModifiableInteger getRecordDigestLength() {
        return this.recordDigestLength;
    }

    public void setRecordDigestLength(ModifiableInteger recordDigestLength) {
        this.recordDigestLength = recordDigestLength;
    }

    public void setRecordDigestLength(int recordDigestLength) {
        this.recordDigestLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.recordDigestLength, (Integer)recordDigestLength);
    }

    public ModifiableByteArray getRecordDigest() {
        return this.recordDigest;
    }

    public void setRecordDigest(ModifiableByteArray recordDigest) {
        this.recordDigest = recordDigest;
    }

    public void setRecordDigest(byte[] recordDigest) {
        this.recordDigest = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.recordDigest, (byte[])recordDigest);
    }

    public ModifiableInteger getEncryptedSniLength() {
        return this.encryptedSniLength;
    }

    public void setEncryptedSniLength(ModifiableInteger encryptedSniLength) {
        this.encryptedSniLength = encryptedSniLength;
    }

    public void setEncryptedSniLength(int encryptedSniLength) {
        this.encryptedSniLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.encryptedSniLength, (Integer)encryptedSniLength);
    }

    public ModifiableByteArray getEncryptedSni() {
        return this.encryptedSni;
    }

    public void setEncryptedSni(ModifiableByteArray encryptedSni) {
        this.encryptedSni = encryptedSni;
    }

    public void setEncryptedSni(byte[] encryptedSni) {
        this.encryptedSni = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.encryptedSni, (byte[])encryptedSni);
    }

    public ClientEsniInner getClientEsniInner() {
        return this.clientEsniInner;
    }

    public void setClientEsniInner(ClientEsniInner clientEsniInner) {
        this.clientEsniInner = clientEsniInner;
    }

    public ModifiableByteArray getClientEsniInnerBytes() {
        return this.clientEsniInnerBytes;
    }

    public void setClientEsniInnerBytes(ModifiableByteArray clientEsniInnerBytes) {
        this.clientEsniInnerBytes = clientEsniInnerBytes;
    }

    public void setClientEsniInnerBytes(byte[] clientEsniInnerBytes) {
        this.clientEsniInnerBytes = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.clientEsniInnerBytes, (byte[])clientEsniInnerBytes);
    }

    public EncryptedSniComputation getEncryptedSniComputation() {
        return this.encryptedSniComputation;
    }

    public void setEncryptedSniComputation(EncryptedSniComputation encryptedSniComputation) {
        this.encryptedSniComputation = encryptedSniComputation;
    }

    public ModifiableByteArray getServerNonce() {
        return this.serverNonce;
    }

    public void setServerNonce(ModifiableByteArray serverNonce) {
        this.serverNonce = serverNonce;
    }

    public void setServerNonce(byte[] serverNonce) {
        this.serverNonce = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.serverNonce, (byte[])serverNonce);
    }

    public EsniMessageType getEsniMessageTypeConfig() {
        return this.esniMessageTypeConfig;
    }

    public void setEsniMessageTypeConfig(EsniMessageType esniMessageTypeConfig) {
        this.esniMessageTypeConfig = esniMessageTypeConfig;
    }

    public static enum EsniMessageType {
        CLIENT,
        SERVER;

    }
}

