# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from influxdb_client.service._base_service import _BaseService


class NotificationRulesService(_BaseService):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):  # noqa: E501,D401,D403
        """NotificationRulesService - a operation defined in OpenAPI."""
        super().__init__(api_client)

    def create_notification_rule(self, post_notification_rule, **kwargs):  # noqa: E501,D401,D403
        """Add a notification rule.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_notification_rule(post_notification_rule, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostNotificationRule post_notification_rule: Notification rule to create (required)
        :return: NotificationRule
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_notification_rule_with_http_info(post_notification_rule, **kwargs)  # noqa: E501
        else:
            (data) = self.create_notification_rule_with_http_info(post_notification_rule, **kwargs)  # noqa: E501
            return data

    def create_notification_rule_with_http_info(self, post_notification_rule, **kwargs):  # noqa: E501,D401,D403
        """Add a notification rule.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_notification_rule_with_http_info(post_notification_rule, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostNotificationRule post_notification_rule: Notification rule to create (required)
        :return: NotificationRule
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._create_notification_rule_prepare(post_notification_rule, **kwargs)

        return self.api_client.call_api(
            '/api/v2/notificationRules', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='NotificationRule',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def create_notification_rule_async(self, post_notification_rule, **kwargs):  # noqa: E501,D401,D403
        """Add a notification rule.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param PostNotificationRule post_notification_rule: Notification rule to create (required)
        :return: NotificationRule
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._create_notification_rule_prepare(post_notification_rule, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/notificationRules', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='NotificationRule',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _create_notification_rule_prepare(self, post_notification_rule, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['post_notification_rule']  # noqa: E501
        self._check_operation_params('create_notification_rule', all_params, local_var_params)
        # verify the required parameter 'post_notification_rule' is set
        if ('post_notification_rule' not in local_var_params or
                local_var_params['post_notification_rule'] is None):
            raise ValueError("Missing the required parameter `post_notification_rule` when calling `create_notification_rule`")  # noqa: E501

        path_params = {}

        query_params = []

        header_params = {}

        body_params = None
        if 'post_notification_rule' in local_var_params:
            body_params = local_var_params['post_notification_rule']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def delete_notification_rules_id(self, rule_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a notification rule.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_notification_rules_id(rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_id: The notification rule ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_notification_rules_id_with_http_info(rule_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_notification_rules_id_with_http_info(rule_id, **kwargs)  # noqa: E501
            return data

    def delete_notification_rules_id_with_http_info(self, rule_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a notification rule.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_notification_rules_id_with_http_info(rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_id: The notification rule ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_notification_rules_id_prepare(rule_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/notificationRules/{ruleID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_notification_rules_id_async(self, rule_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a notification rule.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str rule_id: The notification rule ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_notification_rules_id_prepare(rule_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/notificationRules/{ruleID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_notification_rules_id_prepare(self, rule_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['rule_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_notification_rules_id', all_params, local_var_params)
        # verify the required parameter 'rule_id' is set
        if ('rule_id' not in local_var_params or
                local_var_params['rule_id'] is None):
            raise ValueError("Missing the required parameter `rule_id` when calling `delete_notification_rules_id`")  # noqa: E501

        path_params = {}
        if 'rule_id' in local_var_params:
            path_params['ruleID'] = local_var_params['rule_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def delete_notification_rules_id_labels_id(self, rule_id, label_id, **kwargs):  # noqa: E501,D401,D403
        """Delete label from a notification rule.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_notification_rules_id_labels_id(rule_id, label_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_id: The notification rule ID. (required)
        :param str label_id: The ID of the label to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_notification_rules_id_labels_id_with_http_info(rule_id, label_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_notification_rules_id_labels_id_with_http_info(rule_id, label_id, **kwargs)  # noqa: E501
            return data

    def delete_notification_rules_id_labels_id_with_http_info(self, rule_id, label_id, **kwargs):  # noqa: E501,D401,D403
        """Delete label from a notification rule.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_notification_rules_id_labels_id_with_http_info(rule_id, label_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_id: The notification rule ID. (required)
        :param str label_id: The ID of the label to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_notification_rules_id_labels_id_prepare(rule_id, label_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/notificationRules/{ruleID}/labels/{labelID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_notification_rules_id_labels_id_async(self, rule_id, label_id, **kwargs):  # noqa: E501,D401,D403
        """Delete label from a notification rule.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str rule_id: The notification rule ID. (required)
        :param str label_id: The ID of the label to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_notification_rules_id_labels_id_prepare(rule_id, label_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/notificationRules/{ruleID}/labels/{labelID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_notification_rules_id_labels_id_prepare(self, rule_id, label_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['rule_id', 'label_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_notification_rules_id_labels_id', all_params, local_var_params)
        # verify the required parameter 'rule_id' is set
        if ('rule_id' not in local_var_params or
                local_var_params['rule_id'] is None):
            raise ValueError("Missing the required parameter `rule_id` when calling `delete_notification_rules_id_labels_id`")  # noqa: E501
        # verify the required parameter 'label_id' is set
        if ('label_id' not in local_var_params or
                local_var_params['label_id'] is None):
            raise ValueError("Missing the required parameter `label_id` when calling `delete_notification_rules_id_labels_id`")  # noqa: E501

        path_params = {}
        if 'rule_id' in local_var_params:
            path_params['ruleID'] = local_var_params['rule_id']  # noqa: E501
        if 'label_id' in local_var_params:
            path_params['labelID'] = local_var_params['label_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_notification_rules(self, org_id, **kwargs):  # noqa: E501,D401,D403
        """List all notification rules.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_notification_rules(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: Only show notification rules that belong to a specific organization ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :param int offset:
        :param int limit:
        :param str check_id: Only show notifications that belong to the specific check ID.
        :param str tag: Only return notification rules that "would match" statuses which contain the tag key value pairs provided.
        :return: NotificationRules
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_notification_rules_with_http_info(org_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_notification_rules_with_http_info(org_id, **kwargs)  # noqa: E501
            return data

    def get_notification_rules_with_http_info(self, org_id, **kwargs):  # noqa: E501,D401,D403
        """List all notification rules.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_notification_rules_with_http_info(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: Only show notification rules that belong to a specific organization ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :param int offset:
        :param int limit:
        :param str check_id: Only show notifications that belong to the specific check ID.
        :param str tag: Only return notification rules that "would match" statuses which contain the tag key value pairs provided.
        :return: NotificationRules
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_notification_rules_prepare(org_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/notificationRules', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='NotificationRules',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_notification_rules_async(self, org_id, **kwargs):  # noqa: E501,D401,D403
        """List all notification rules.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str org_id: Only show notification rules that belong to a specific organization ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :param int offset:
        :param int limit:
        :param str check_id: Only show notifications that belong to the specific check ID.
        :param str tag: Only return notification rules that "would match" statuses which contain the tag key value pairs provided.
        :return: NotificationRules
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_notification_rules_prepare(org_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/notificationRules', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='NotificationRules',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_notification_rules_prepare(self, org_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['org_id', 'zap_trace_span', 'offset', 'limit', 'check_id', 'tag']  # noqa: E501
        self._check_operation_params('get_notification_rules', all_params, local_var_params)
        # verify the required parameter 'org_id' is set
        if ('org_id' not in local_var_params or
                local_var_params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `get_notification_rules`")  # noqa: E501

        if 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `offset` when calling `get_notification_rules`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_notification_rules`, must be a value less than or equal to `100`")  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_notification_rules`, must be a value greater than or equal to `1`")  # noqa: E501
        if 'tag' in local_var_params and not re.search(r'^[a-zA-Z0-9_]+:[a-zA-Z0-9_]+$', local_var_params['tag']):  # noqa: E501
            raise ValueError("Invalid value for parameter `tag` when calling `get_notification_rules`, must conform to the pattern `/^[a-zA-Z0-9_]+:[a-zA-Z0-9_]+$/`")  # noqa: E501
        path_params = {}

        query_params = []
        if 'offset' in local_var_params:
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params:
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'org_id' in local_var_params:
            query_params.append(('orgID', local_var_params['org_id']))  # noqa: E501
        if 'check_id' in local_var_params:
            query_params.append(('checkID', local_var_params['check_id']))  # noqa: E501
        if 'tag' in local_var_params:
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_notification_rules_id(self, rule_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a notification rule.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_notification_rules_id(rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_id: The notification rule ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: NotificationRule
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_notification_rules_id_with_http_info(rule_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_notification_rules_id_with_http_info(rule_id, **kwargs)  # noqa: E501
            return data

    def get_notification_rules_id_with_http_info(self, rule_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a notification rule.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_notification_rules_id_with_http_info(rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_id: The notification rule ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: NotificationRule
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_notification_rules_id_prepare(rule_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/notificationRules/{ruleID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='NotificationRule',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_notification_rules_id_async(self, rule_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a notification rule.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str rule_id: The notification rule ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: NotificationRule
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_notification_rules_id_prepare(rule_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/notificationRules/{ruleID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='NotificationRule',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_notification_rules_id_prepare(self, rule_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['rule_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_notification_rules_id', all_params, local_var_params)
        # verify the required parameter 'rule_id' is set
        if ('rule_id' not in local_var_params or
                local_var_params['rule_id'] is None):
            raise ValueError("Missing the required parameter `rule_id` when calling `get_notification_rules_id`")  # noqa: E501

        path_params = {}
        if 'rule_id' in local_var_params:
            path_params['ruleID'] = local_var_params['rule_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_notification_rules_id_labels(self, rule_id, **kwargs):  # noqa: E501,D401,D403
        """List all labels for a notification rule.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_notification_rules_id_labels(rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_id: The notification rule ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_notification_rules_id_labels_with_http_info(rule_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_notification_rules_id_labels_with_http_info(rule_id, **kwargs)  # noqa: E501
            return data

    def get_notification_rules_id_labels_with_http_info(self, rule_id, **kwargs):  # noqa: E501,D401,D403
        """List all labels for a notification rule.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_notification_rules_id_labels_with_http_info(rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_id: The notification rule ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_notification_rules_id_labels_prepare(rule_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/notificationRules/{ruleID}/labels', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='LabelsResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_notification_rules_id_labels_async(self, rule_id, **kwargs):  # noqa: E501,D401,D403
        """List all labels for a notification rule.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str rule_id: The notification rule ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_notification_rules_id_labels_prepare(rule_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/notificationRules/{ruleID}/labels', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='LabelsResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_notification_rules_id_labels_prepare(self, rule_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['rule_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_notification_rules_id_labels', all_params, local_var_params)
        # verify the required parameter 'rule_id' is set
        if ('rule_id' not in local_var_params or
                local_var_params['rule_id'] is None):
            raise ValueError("Missing the required parameter `rule_id` when calling `get_notification_rules_id_labels`")  # noqa: E501

        path_params = {}
        if 'rule_id' in local_var_params:
            path_params['ruleID'] = local_var_params['rule_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def patch_notification_rules_id(self, rule_id, notification_rule_update, **kwargs):  # noqa: E501,D401,D403
        """Update a notification rule.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_notification_rules_id(rule_id, notification_rule_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_id: The notification rule ID. (required)
        :param NotificationRuleUpdate notification_rule_update: Notification rule update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: NotificationRule
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_notification_rules_id_with_http_info(rule_id, notification_rule_update, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_notification_rules_id_with_http_info(rule_id, notification_rule_update, **kwargs)  # noqa: E501
            return data

    def patch_notification_rules_id_with_http_info(self, rule_id, notification_rule_update, **kwargs):  # noqa: E501,D401,D403
        """Update a notification rule.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_notification_rules_id_with_http_info(rule_id, notification_rule_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_id: The notification rule ID. (required)
        :param NotificationRuleUpdate notification_rule_update: Notification rule update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: NotificationRule
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._patch_notification_rules_id_prepare(rule_id, notification_rule_update, **kwargs)

        return self.api_client.call_api(
            '/api/v2/notificationRules/{ruleID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='NotificationRule',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def patch_notification_rules_id_async(self, rule_id, notification_rule_update, **kwargs):  # noqa: E501,D401,D403
        """Update a notification rule.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str rule_id: The notification rule ID. (required)
        :param NotificationRuleUpdate notification_rule_update: Notification rule update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: NotificationRule
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._patch_notification_rules_id_prepare(rule_id, notification_rule_update, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/notificationRules/{ruleID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='NotificationRule',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _patch_notification_rules_id_prepare(self, rule_id, notification_rule_update, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['rule_id', 'notification_rule_update', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('patch_notification_rules_id', all_params, local_var_params)
        # verify the required parameter 'rule_id' is set
        if ('rule_id' not in local_var_params or
                local_var_params['rule_id'] is None):
            raise ValueError("Missing the required parameter `rule_id` when calling `patch_notification_rules_id`")  # noqa: E501
        # verify the required parameter 'notification_rule_update' is set
        if ('notification_rule_update' not in local_var_params or
                local_var_params['notification_rule_update'] is None):
            raise ValueError("Missing the required parameter `notification_rule_update` when calling `patch_notification_rules_id`")  # noqa: E501

        path_params = {}
        if 'rule_id' in local_var_params:
            path_params['ruleID'] = local_var_params['rule_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'notification_rule_update' in local_var_params:
            body_params = local_var_params['notification_rule_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_notification_rule_id_labels(self, rule_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        """Add a label to a notification rule.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_notification_rule_id_labels(rule_id, label_mapping, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_id: The notification rule ID. (required)
        :param LabelMapping label_mapping: Label to add (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_notification_rule_id_labels_with_http_info(rule_id, label_mapping, **kwargs)  # noqa: E501
        else:
            (data) = self.post_notification_rule_id_labels_with_http_info(rule_id, label_mapping, **kwargs)  # noqa: E501
            return data

    def post_notification_rule_id_labels_with_http_info(self, rule_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        """Add a label to a notification rule.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_notification_rule_id_labels_with_http_info(rule_id, label_mapping, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_id: The notification rule ID. (required)
        :param LabelMapping label_mapping: Label to add (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_notification_rule_id_labels_prepare(rule_id, label_mapping, **kwargs)

        return self.api_client.call_api(
            '/api/v2/notificationRules/{ruleID}/labels', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='LabelResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_notification_rule_id_labels_async(self, rule_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        """Add a label to a notification rule.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str rule_id: The notification rule ID. (required)
        :param LabelMapping label_mapping: Label to add (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_notification_rule_id_labels_prepare(rule_id, label_mapping, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/notificationRules/{ruleID}/labels', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='LabelResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_notification_rule_id_labels_prepare(self, rule_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['rule_id', 'label_mapping', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_notification_rule_id_labels', all_params, local_var_params)
        # verify the required parameter 'rule_id' is set
        if ('rule_id' not in local_var_params or
                local_var_params['rule_id'] is None):
            raise ValueError("Missing the required parameter `rule_id` when calling `post_notification_rule_id_labels`")  # noqa: E501
        # verify the required parameter 'label_mapping' is set
        if ('label_mapping' not in local_var_params or
                local_var_params['label_mapping'] is None):
            raise ValueError("Missing the required parameter `label_mapping` when calling `post_notification_rule_id_labels`")  # noqa: E501

        path_params = {}
        if 'rule_id' in local_var_params:
            path_params['ruleID'] = local_var_params['rule_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'label_mapping' in local_var_params:
            body_params = local_var_params['label_mapping']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def put_notification_rules_id(self, rule_id, notification_rule, **kwargs):  # noqa: E501,D401,D403
        """Update a notification rule.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_notification_rules_id(rule_id, notification_rule, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_id: The notification rule ID. (required)
        :param NotificationRule notification_rule: Notification rule update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: NotificationRule
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_notification_rules_id_with_http_info(rule_id, notification_rule, **kwargs)  # noqa: E501
        else:
            (data) = self.put_notification_rules_id_with_http_info(rule_id, notification_rule, **kwargs)  # noqa: E501
            return data

    def put_notification_rules_id_with_http_info(self, rule_id, notification_rule, **kwargs):  # noqa: E501,D401,D403
        """Update a notification rule.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_notification_rules_id_with_http_info(rule_id, notification_rule, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_id: The notification rule ID. (required)
        :param NotificationRule notification_rule: Notification rule update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: NotificationRule
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._put_notification_rules_id_prepare(rule_id, notification_rule, **kwargs)

        return self.api_client.call_api(
            '/api/v2/notificationRules/{ruleID}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='NotificationRule',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def put_notification_rules_id_async(self, rule_id, notification_rule, **kwargs):  # noqa: E501,D401,D403
        """Update a notification rule.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str rule_id: The notification rule ID. (required)
        :param NotificationRule notification_rule: Notification rule update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: NotificationRule
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._put_notification_rules_id_prepare(rule_id, notification_rule, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/notificationRules/{ruleID}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='NotificationRule',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _put_notification_rules_id_prepare(self, rule_id, notification_rule, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['rule_id', 'notification_rule', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('put_notification_rules_id', all_params, local_var_params)
        # verify the required parameter 'rule_id' is set
        if ('rule_id' not in local_var_params or
                local_var_params['rule_id'] is None):
            raise ValueError("Missing the required parameter `rule_id` when calling `put_notification_rules_id`")  # noqa: E501
        # verify the required parameter 'notification_rule' is set
        if ('notification_rule' not in local_var_params or
                local_var_params['notification_rule'] is None):
            raise ValueError("Missing the required parameter `notification_rule` when calling `put_notification_rules_id`")  # noqa: E501

        path_params = {}
        if 'rule_id' in local_var_params:
            path_params['ruleID'] = local_var_params['rule_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'notification_rule' in local_var_params:
            body_params = local_var_params['notification_rule']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params
