/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.timescale;

import com.projectlibre1.pm.time.HasStartAndEnd;
import com.projectlibre1.util.DateTime;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class CalendarUtil {
    public static final long SECOND_ms = 1000L;
    public static final long MINUTE_ms = 60000L;
    public static final long HOUR_ms = 3600000L;
    public static final long DAY_ms = 86400000L;
    public static final long WEEK_ms = (long)DateTime.calendarInstance().getLeastMaximum(7) * 86400000L;
    public static final long MONTH_ms = (long)DateTime.calendarInstance().getLeastMaximum(5) * 86400000L;
    public static final long YEAR_ms = (long)DateTime.calendarInstance().getLeastMaximum(6) * 86400000L;

    private CalendarUtil() {
    }

    public static Date min(Date date, Date date2) {
        return date.before(date2) ? date : date2;
    }

    public static Date max(Date date, Date date2) {
        return date.after(date2) ? date : date2;
    }

    public static int compareEra(Calendar calendar, Calendar calendar2) {
        if (calendar.getClass() != calendar2.getClass()) {
            throw new IllegalArgumentException("Cannot compare calendars of dissimilar classes: " + calendar + ", " + calendar2);
        }
        return calendar.get(0) - calendar2.get(0);
    }

    public static int compareYear(Calendar calendar, Calendar calendar2) {
        int n = CalendarUtil.compareEra(calendar, calendar2);
        if (n != 0) {
            return n;
        }
        return calendar.get(1) - calendar2.get(1);
    }

    public static int compareMonth(Calendar calendar, Calendar calendar2) {
        int n = CalendarUtil.compareYear(calendar, calendar2);
        if (n != 0) {
            return n;
        }
        return calendar.get(2) - calendar2.get(2);
    }

    public static int compareDay(Calendar calendar, Calendar calendar2) {
        int n = CalendarUtil.compareYear(calendar, calendar2);
        if (n != 0) {
            return n;
        }
        return calendar.get(6) - calendar2.get(6);
    }

    public static void secondFloor(Calendar calendar) {
        calendar.set(14, 0);
    }

    public static void minuteFloor(Calendar calendar) {
        CalendarUtil.secondFloor(calendar);
        calendar.set(13, 0);
    }

    public static void minuteFloor(Calendar calendar, int n) {
        CalendarUtil.secondFloor(calendar);
        calendar.set(13, 0);
        if (n > 1) {
            int n2 = calendar.get(13);
            calendar.set(13, n2 / n * n);
        }
    }

    public static void hourFloor(Calendar calendar) {
        CalendarUtil.minuteFloor(calendar);
        calendar.set(12, 0);
    }

    public static void hourFloor(Calendar calendar, int n) {
        CalendarUtil.minuteFloor(calendar);
        calendar.set(12, 0);
        if (n > 1) {
            int n2 = calendar.get(10);
            calendar.set(10, n2 / n * n);
        }
    }

    public static void dayFloor(Calendar calendar) {
        CalendarUtil.hourFloor(calendar);
        calendar.set(11, 0);
    }

    public static void weekFloor(Calendar calendar) {
        int n;
        int n2 = calendar.get(1);
        int n3 = calendar.get(6);
        int n4 = calendar.get(7);
        int n5 = n4 - (n = calendar.getFirstDayOfWeek());
        if (n5 > 0) {
            n3 -= n5;
        } else if (n5 < 0) {
            n3 -= 7 + n5;
        }
        calendar.clear();
        boolean bl = calendar.isLenient();
        if (!bl) {
            calendar.setLenient(true);
        }
        calendar.set(1, n2);
        calendar.set(6, n3);
        if (!bl) {
            int n6 = calendar.get(1);
            calendar.setLenient(false);
        }
    }

    public static void monthFloor(Calendar calendar) {
        CalendarUtil.dayFloor(calendar);
        calendar.set(5, 1);
    }

    public static void monthFloor(Calendar calendar, int n) {
        CalendarUtil.dayFloor(calendar);
        calendar.set(5, 1);
        if (n > 1) {
            int n2 = calendar.get(2);
            calendar.set(2, n2 / n * n);
        }
    }

    public static void yearFloor(Calendar calendar) {
        CalendarUtil.monthFloor(calendar);
        calendar.set(2, 0);
    }

    public static void floor(Calendar calendar, int n) {
        CalendarUtil.floor(calendar, n, 1);
    }

    public static void floor(Calendar calendar, int n, int n2) {
        switch (n) {
            case 1: {
                CalendarUtil.yearFloor(calendar);
                break;
            }
            case 2: {
                CalendarUtil.monthFloor(calendar, n2);
                break;
            }
            case 3: {
                CalendarUtil.weekFloor(calendar);
                break;
            }
            case 7: {
                CalendarUtil.dayFloor(calendar);
                break;
            }
            case 5: {
                CalendarUtil.dayFloor(calendar);
                break;
            }
            case 11: {
                CalendarUtil.hourFloor(calendar, n2);
                break;
            }
            case 12: {
                CalendarUtil.minuteFloor(calendar, n2);
                break;
            }
            case 13: {
                CalendarUtil.secondFloor(calendar);
            }
        }
    }

    public static long getMinDuration(int n) {
        switch (n) {
            case 1: {
                return YEAR_ms;
            }
            case 2: {
                return MONTH_ms;
            }
            case 3: {
                return WEEK_ms;
            }
            case 7: {
                return 86400000L;
            }
            case 5: {
                return 86400000L;
            }
            case 11: {
                return 3600000L;
            }
            case 12: {
                return 60000L;
            }
            case 13: {
                return 1000L;
            }
        }
        return -1L;
    }

    public static String toString(long l) {
        GregorianCalendar gregorianCalendar = DateTime.calendarInstance();
        gregorianCalendar.setTimeInMillis(l);
        return CalendarUtil.toString(gregorianCalendar);
    }

    public static String toString(Calendar calendar) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        return dateFormat.format(calendar.getTime());
    }

    public static long toLongTime(double d) {
        return Math.round(d / 1000.0) * 1000L;
    }

    public static long roundTime(double d, Calendar calendar) {
        long l = CalendarUtil.toLongTime(d);
        calendar.setTimeInMillis(l);
        int n = calendar.get(13);
        return n > 30 ? l + (long)(60 - n) : l - (long)n;
    }

    public static void roundTime(Calendar calendar) {
        calendar.setTimeInMillis(CalendarUtil.roundTime(calendar.getTimeInMillis(), calendar));
    }

    public static class DayIterator {
        private Calendar calendar;
        protected long end;

        public void setInterval(HasStartAndEnd hasStartAndEnd) {
            this.calendar = DateTime.calendarInstance();
            this.calendar.setTimeInMillis(hasStartAndEnd.getEnd());
            CalendarUtil.dayFloor(this.calendar);
            this.end = this.calendar.getTimeInMillis();
            this.calendar.setTimeInMillis(hasStartAndEnd.getStart());
            CalendarUtil.dayFloor(this.calendar);
        }

        public boolean hasMoreDays() {
            return this.calendar.getTimeInMillis() <= this.end;
        }

        public long nextDay() {
            long l = this.calendar.getTimeInMillis();
            this.calendar.add(5, 1);
            return l;
        }
    }
}

