"use strict";

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
// @ts-check
// workaround for Safari support before https://github.com/niklasvh/html2canvas/pull/2911 is merged
const https = require('https');

const fs = require('fs');

const replace = require('replace-in-file');

const options = {
  files: [__dirname + '/../node_modules/html2canvas/**/*.js', __dirname + '/../node_modules/html2canvas/**/*.js.map'],
  from: 'if (image.width === width && image.height === height) {',
  to: 'if (false && image.width === width && image.height === height) {'
};

try {
  const changedFiles = replace.sync(options);
  console.log('Modified files for html2canvas Safari support:\n', changedFiles.filter(file => file.hasChanged).map(file => file.file).join('\n'));
} catch (error) {
  console.error('Error occurred when modifiying files for html2canvas Safari support:', error);
} // download tesseract model


const modelFile = fs.createWriteStream(__dirname + '/../common/tesseract/eng.traineddata.gz');
https.get('https://raw.githubusercontent.com/naptha/tessdata/gh-pages/4.0.0_best/eng.traineddata.gz', function (response) {
  response.pipe(modelFile);
  modelFile.on('finish', () => {
    modelFile.close();
    console.log('Downloaded eng.traineddata.gz for tesseract.js');
  });
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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