/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn.matchers;

import com.nulabinc.zxcvbn.Context;
import com.nulabinc.zxcvbn.WipeableString;
import com.nulabinc.zxcvbn.matchers.BaseMatcher;
import com.nulabinc.zxcvbn.matchers.Match;
import com.nulabinc.zxcvbn.matchers.MatchFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class SequenceMatcher
extends BaseMatcher {
    private static final int MAX_DELTA = 5;

    public SequenceMatcher(Context context) {
        super(context);
    }

    private static Match update(CharSequence password, int i, int j, Integer delta) {
        Match match = null;
        if ((j - i > 1 || delta != null && Math.abs(delta) == 1) && 0 < Math.abs(delta) && Math.abs(delta) <= 5) {
            int sequenceSpace;
            String sequenceName;
            WipeableString token = WipeableString.copy(password, i, j + 1);
            if (Pattern.compile("^[a-z]+$").matcher(token).find()) {
                sequenceName = "lower";
                sequenceSpace = 26;
            } else if (Pattern.compile("^[A-Z]+$").matcher(token).find()) {
                sequenceName = "upper";
                sequenceSpace = 26;
            } else if (Pattern.compile("^\\d+$").matcher(token).find()) {
                sequenceName = "digits";
                sequenceSpace = 10;
            } else {
                sequenceName = "unicode";
                sequenceSpace = 26;
            }
            match = MatchFactory.createSequenceMatch(i, j, token, sequenceName, sequenceSpace, delta > 0);
        }
        return match;
    }

    @Override
    public List<Match> execute(CharSequence password) {
        ArrayList<Match> matches = new ArrayList<Match>();
        if (password == null || password.length() == 1) {
            return matches;
        }
        int i = 0;
        Integer lastDelta = null;
        WipeableString wipeable = new WipeableString(password);
        for (int k = 1; k < password.length(); ++k) {
            int delta = wipeable.codePointAt(k) - wipeable.codePointAt(k - 1);
            if (lastDelta == null) {
                lastDelta = delta;
            }
            if (delta == lastDelta) continue;
            int j = k - 1;
            Match match = SequenceMatcher.update(password, i, j, lastDelta);
            if (match != null) {
                matches.add(match);
            }
            i = j;
            lastDelta = delta;
        }
        wipeable.wipe();
        Match match = SequenceMatcher.update(password, i, password.length() - 1, lastDelta);
        if (match != null) {
            matches.add(match);
        }
        return matches;
    }
}

