/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.input.nlp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.dataset.MLInputDataset;
import org.opensearch.ml.common.dataset.TextDocsInputDataSet;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.output.model.ModelResultFilter;

@org.opensearch.ml.common.annotation.MLInput(functionNames={FunctionName.TEXT_EMBEDDING})
public class TextDocsMLInput
extends MLInput {
    public static final String TEXT_DOCS_FIELD = "text_docs";
    public static final String RESULT_FILTER_FIELD = "result_filter";

    public TextDocsMLInput(FunctionName algorithm, MLInputDataset inputDataset) {
        super(algorithm, null, inputDataset);
    }

    public TextDocsMLInput(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("algorithm", this.algorithm.name());
        if (this.parameters != null) {
            builder.field("parameters", (ToXContent)this.parameters);
        }
        if (this.inputDataset != null) {
            TextDocsInputDataSet textInputDataSet = (TextDocsInputDataSet)this.inputDataset;
            List<String> docs = textInputDataSet.getDocs();
            ModelResultFilter resultFilter = textInputDataSet.getResultFilter();
            if (docs != null && docs.size() > 0) {
                builder.field(TEXT_DOCS_FIELD, (Object)docs.toArray(new String[0]));
            }
            if (resultFilter != null) {
                List<Integer> targetPositions;
                builder.startObject(RESULT_FILTER_FIELD);
                builder.field("return_bytes", resultFilter.isReturnBytes());
                builder.field("return_number", resultFilter.isReturnNumber());
                List<String> targetResponse = resultFilter.getTargetResponse();
                if (targetResponse != null && targetResponse.size() > 0) {
                    builder.field("target_response", (Object)targetResponse.toArray(new String[0]));
                }
                if ((targetPositions = resultFilter.getTargetResponsePositions()) != null && targetPositions.size() > 0) {
                    builder.field("target_response_positions", (Object)targetPositions.toArray(new Integer[0]));
                }
                builder.endObject();
            }
        }
        builder.endObject();
        return builder;
    }

    public TextDocsMLInput(XContentParser parser, FunctionName functionName) throws IOException {
        ModelResultFilter filter;
        this.algorithm = functionName;
        ArrayList<String> docs = new ArrayList<String>();
        ModelResultFilter resultFilter = null;
        boolean returnBytes = false;
        boolean returnNumber = true;
        ArrayList<String> targetResponse = new ArrayList<String>();
        ArrayList<Integer> targetResponsePositions = new ArrayList<Integer>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block16: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "return_bytes": {
                    returnBytes = parser.booleanValue();
                    continue block16;
                }
                case "return_number": {
                    returnNumber = parser.booleanValue();
                    continue block16;
                }
                case "target_response": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        targetResponse.add(parser.text());
                    }
                    continue block16;
                }
                case "target_response_positions": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        targetResponsePositions.add(parser.intValue());
                    }
                    continue block16;
                }
                case "text_docs": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        docs.add(parser.text());
                    }
                    continue block16;
                }
                case "result_filter": {
                    resultFilter = ModelResultFilter.parse(parser);
                    continue block16;
                }
            }
            parser.skipChildren();
        }
        ModelResultFilter modelResultFilter = filter = resultFilter != null ? resultFilter : ModelResultFilter.builder().returnBytes(returnBytes).returnNumber(returnNumber).targetResponse(targetResponse).targetResponsePositions(targetResponsePositions).build();
        if (docs.size() == 0) {
            throw new IllegalArgumentException("Empty text docs");
        }
        this.inputDataset = new TextDocsInputDataSet(docs, filter);
    }
}

