/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.commons.os;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.opensearch.performanceanalyzer.commons.collectors.StatsCollector;
import org.opensearch.performanceanalyzer.commons.metrics_generator.linux.LinuxDiskIOMetricsGenerator;
import org.opensearch.performanceanalyzer.commons.os.OSGlobals;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;

public class ThreadDiskIO {
    private static String pid = OSGlobals.getPid();
    private static List<String> tids = null;
    private static final Logger LOGGER = LogManager.getLogger(ThreadDiskIO.class);
    private static Map<String, Map<String, Long>> tidKVMap = new HashMap<String, Map<String, Long>>();
    private static Map<String, Map<String, Long>> oldtidKVMap = new HashMap<String, Map<String, Long>>();
    private static long kvTimestamp = 0L;
    private static long oldkvTimestamp = 0L;

    private static void addSampleTid(String tid) {
        try (FileReader fileReader = new FileReader(new File("/proc/" + pid + "/task/" + tid + "/io"));
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String line = null;
            HashMap<String, Long> kvmap = new HashMap<String, Long>();
            while ((line = bufferedReader.readLine()) != null) {
                String[] toks = line.split("[: ]+");
                String key = toks[0];
                long val = Long.parseLong(toks[1]);
                kvmap.put(key, val);
            }
            tidKVMap.put(tid, kvmap);
        }
        catch (FileNotFoundException e) {
            LOGGER.debug("FileNotFound in parse with exception: {}", new Supplier[]{() -> e.toString()});
        }
        catch (Exception e) {
            LOGGER.debug("Error In addSample Tid for: {}  with error: {} with ExceptionCode: {}", new Supplier[]{() -> tid, () -> e.toString(), () -> StatExceptionCode.THREAD_IO_ERROR.toString()});
            StatsCollector.instance().logException(StatExceptionCode.THREAD_IO_ERROR);
        }
    }

    public static synchronized void addSample() {
        tids = OSGlobals.getTids();
        oldtidKVMap.clear();
        oldtidKVMap.putAll(tidKVMap);
        tidKVMap.clear();
        oldkvTimestamp = kvTimestamp;
        kvTimestamp = System.currentTimeMillis();
        for (String tid : tids) {
            ThreadDiskIO.addSampleTid(tid);
        }
    }

    public static synchronized LinuxDiskIOMetricsGenerator getIOUtilization() {
        LinuxDiskIOMetricsGenerator linuxDiskIOMetricsHandler = new LinuxDiskIOMetricsGenerator();
        if (oldkvTimestamp == kvTimestamp) {
            return linuxDiskIOMetricsHandler;
        }
        for (Map.Entry<String, Map<String, Long>> entry : tidKVMap.entrySet()) {
            Map<String, Long> v = entry.getValue();
            Map<String, Long> oldv = oldtidKVMap.get(entry.getKey());
            if (v == null || oldv == null) continue;
            double duration = 0.001 * (double)(kvTimestamp - oldkvTimestamp);
            double readBytes = v.get("read_bytes") - oldv.get("read_bytes");
            double writeBytes = v.get("write_bytes") - oldv.get("write_bytes");
            double readSyscalls = v.get("syscr") - oldv.get("syscr");
            double writeSyscalls = v.get("syscw") - oldv.get("syscw");
            double readPcBytes = (double)(v.get("rchar") - oldv.get("rchar")) - readBytes;
            double writePcBytes = (double)(v.get("wchar") - oldv.get("wchar")) - writeBytes;
            linuxDiskIOMetricsHandler.setDiskIOMetrics(entry.getKey(), new IOMetrics(readBytes, readSyscalls /= duration, writeBytes /= duration, writeSyscalls /= duration, (readBytes /= duration) + writeBytes, readSyscalls + writeSyscalls, readPcBytes /= duration, writePcBytes /= duration, readPcBytes + writePcBytes));
        }
        return linuxDiskIOMetricsHandler;
    }

    public static class IOMetrics {
        public double avgReadThroughputBps;
        public double avgWriteThroughputBps;
        public double avgTotalThroughputBps;
        public double avgReadSyscallRate;
        public double avgWriteSyscallRate;
        public double avgTotalSyscallRate;
        public double avgPageCacheReadThroughputBps;
        public double avgPageCacheWriteThroughputBps;
        public double avgPageCacheTotalThroughputBps;

        IOMetrics(double avgReadThroughputBps, double avgReadSyscallRate, double avgWriteThroughputBps, double avgWriteSyscallRate, double avgTotalThroughputBps, double avgTotalSyscallRate, double avgPageCacheReadThroughputBps, double avgPageCacheWriteThroughputBps, double avgPageCacheTotalThroughputBps) {
            this.avgReadThroughputBps = avgReadThroughputBps;
            this.avgWriteThroughputBps = avgWriteThroughputBps;
            this.avgTotalThroughputBps = avgTotalThroughputBps;
            this.avgReadSyscallRate = avgReadSyscallRate;
            this.avgWriteSyscallRate = avgWriteSyscallRate;
            this.avgTotalSyscallRate = avgTotalSyscallRate;
            this.avgPageCacheReadThroughputBps = avgPageCacheReadThroughputBps;
            this.avgPageCacheWriteThroughputBps = avgPageCacheWriteThroughputBps;
            this.avgPageCacheTotalThroughputBps = avgPageCacheTotalThroughputBps;
        }

        public String toString() {
            return "rBps:" + this.avgReadThroughputBps + " wBps:" + this.avgWriteThroughputBps + " totBps:" + this.avgTotalThroughputBps + " rSysc:" + this.avgReadSyscallRate + " wSysc:" + this.avgWriteSyscallRate + " totSysc:" + this.avgTotalSyscallRate + " rPcBps:" + this.avgPageCacheReadThroughputBps + " wPcBps:" + this.avgPageCacheWriteThroughputBps + " totPcBps:" + this.avgPageCacheTotalThroughputBps;
        }
    }
}

