/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.support;

import com.amazon.dlic.auth.ldap.LdapUser;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.AccessController;
import java.security.Permission;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.ldaptive.AbstractLdapBean;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.SearchEntry;
import org.opensearch.OpenSearchException;
import org.opensearch.SpecialPermission;
import org.opensearch.core.common.Strings;
import org.opensearch.security.support.SourceFieldsContext;
import org.opensearch.security.user.User;

public class Base64Helper {
    private static final Set<Class<?>> SAFE_CLASSES = ImmutableSet.of(String.class, SocketAddress.class, InetSocketAddress.class, Pattern.class, User.class, SourceFieldsContext.class, (Object[])new Class[]{LdapUser.class, SearchEntry.class, LdapEntry.class, AbstractLdapBean.class, LdapAttribute.class});
    private static final List<Class<?>> SAFE_ASSIGNABLE_FROM_CLASSES = ImmutableList.of(InetAddress.class, Number.class, Collection.class, Map.class, Enum.class);
    private static final Set<String> SAFE_CLASS_NAMES = Collections.singleton("org.ldaptive.LdapAttribute$LdapAttributeValues");

    private static boolean isSafeClass(Class<?> cls) {
        return cls.isArray() || SAFE_CLASSES.contains(cls) || SAFE_CLASS_NAMES.contains(cls.getName()) || SAFE_ASSIGNABLE_FROM_CLASSES.stream().anyMatch(c -> c.isAssignableFrom(cls));
    }

    public static String serializeObject(Serializable object) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)"object must not be null");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ObjectOutputStream out = SafeObjectOutputStream.create(bos);){
            out.writeObject(object);
        }
        catch (Exception e) {
            throw new OpenSearchException("Instance {} of class {} is not serializable", (Throwable)e, new Object[]{object, object.getClass()});
        }
        byte[] bytes = bos.toByteArray();
        return BaseEncoding.base64().encode(bytes);
    }

    public static Serializable deserializeObject(String string) {
        Serializable serializable;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)string) ? 1 : 0) != 0, (Object)"string must not be null or empty");
        byte[] bytes = BaseEncoding.base64().decode((CharSequence)string);
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        SafeObjectInputStream in = new SafeObjectInputStream(bis);
        try {
            serializable = (Serializable)in.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new OpenSearchException((Throwable)e);
            }
        }
        in.close();
        return serializable;
    }

    private static final class SafeObjectOutputStream
    extends ObjectOutputStream {
        private static final boolean useSafeObjectOutputStream = SafeObjectOutputStream.checkSubstitutionPermission();

        private static boolean checkSubstitutionPermission() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                try {
                    sm.checkPermission((Permission)new SpecialPermission());
                    AccessController.doPrivileged(() -> {
                        AccessController.checkPermission(SUBSTITUTION_PERMISSION);
                        return null;
                    });
                }
                catch (SecurityException e) {
                    return false;
                }
            }
            return true;
        }

        static ObjectOutputStream create(ByteArrayOutputStream out) throws IOException {
            try {
                return useSafeObjectOutputStream ? new SafeObjectOutputStream(out) : new ObjectOutputStream(out);
            }
            catch (SecurityException e) {
                out.reset();
                return new ObjectOutputStream(out);
            }
        }

        private SafeObjectOutputStream(OutputStream out) throws IOException {
            super(out);
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)new SpecialPermission());
            }
            AccessController.doPrivileged(() -> this.enableReplaceObject(true));
        }

        @Override
        protected Object replaceObject(Object obj) throws IOException {
            Class<?> clazz = obj.getClass();
            if (Base64Helper.isSafeClass(clazz)) {
                return obj;
            }
            throw new IOException("Unauthorized serialization attempt " + clazz.getName());
        }
    }

    private static final class SafeObjectInputStream
    extends ObjectInputStream {
        public SafeObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            Class<?> clazz = super.resolveClass(desc);
            if (Base64Helper.isSafeClass(clazz)) {
                return clazz;
            }
            throw new InvalidClassException("Unauthorized deserialization attempt ", clazz.getName());
        }
    }
}

