/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.http;

import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.security.auth.HTTPAuthenticator;
import org.opensearch.security.support.HTTPHelper;
import org.opensearch.security.user.AuthCredentials;

public class HTTPBasicAuthenticator
implements HTTPAuthenticator {
    protected final Logger log = LogManager.getLogger(this.getClass());

    public HTTPBasicAuthenticator(Settings settings, Path configPath) {
    }

    @Override
    public AuthCredentials extractCredentials(RestRequest request, ThreadContext threadContext) {
        boolean forceLogin = request.paramAsBoolean("force_login", false);
        if (forceLogin) {
            return null;
        }
        String authorizationHeader = request.header("Authorization");
        return HTTPHelper.extractCredentials(authorizationHeader, this.log);
    }

    @Override
    public boolean reRequestAuthentication(RestChannel channel, AuthCredentials creds) {
        BytesRestResponse wwwAuthenticateResponse = new BytesRestResponse(RestStatus.UNAUTHORIZED, "Unauthorized");
        wwwAuthenticateResponse.addHeader("WWW-Authenticate", "Basic realm=\"OpenSearch Security\"");
        channel.sendResponse((RestResponse)wwwAuthenticateResponse);
        return true;
    }

    @Override
    public String getType() {
        return "basic";
    }
}

