/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.configuration.AdminDNs;
import org.opensearch.security.configuration.ConfigurationRepository;
import org.opensearch.security.dlic.rest.api.AccountApiAction;
import org.opensearch.security.dlic.rest.api.ActionGroupsApiAction;
import org.opensearch.security.dlic.rest.api.AllowlistApiAction;
import org.opensearch.security.dlic.rest.api.AuditApiAction;
import org.opensearch.security.dlic.rest.api.AuthTokenProcessorAction;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.api.FlushCacheApiAction;
import org.opensearch.security.dlic.rest.api.InternalUsersApiAction;
import org.opensearch.security.dlic.rest.api.MigrateApiAction;
import org.opensearch.security.dlic.rest.api.MultiTenancyConfigApiAction;
import org.opensearch.security.dlic.rest.api.NodesDnApiAction;
import org.opensearch.security.dlic.rest.api.PermissionsInfoAction;
import org.opensearch.security.dlic.rest.api.RestApiAdminPrivilegesEvaluator;
import org.opensearch.security.dlic.rest.api.RestApiPrivilegesEvaluator;
import org.opensearch.security.dlic.rest.api.RolesApiAction;
import org.opensearch.security.dlic.rest.api.RolesMappingApiAction;
import org.opensearch.security.dlic.rest.api.SecurityApiDependencies;
import org.opensearch.security.dlic.rest.api.SecurityConfigApiAction;
import org.opensearch.security.dlic.rest.api.SecuritySSLCertsAction;
import org.opensearch.security.dlic.rest.api.TenantsApiAction;
import org.opensearch.security.dlic.rest.api.ValidateApiAction;
import org.opensearch.security.dlic.rest.api.WhitelistApiAction;
import org.opensearch.security.privileges.PrivilegesEvaluator;
import org.opensearch.security.ssl.SecurityKeyStore;
import org.opensearch.security.ssl.transport.PrincipalExtractor;
import org.opensearch.security.user.UserService;
import org.opensearch.threadpool.ThreadPool;

public class SecurityRestApiActions {
    public static Collection<RestHandler> getHandler(Settings settings, Path configPath, RestController controller, Client client, AdminDNs adminDns, ConfigurationRepository configurationRepository, ClusterService clusterService, PrincipalExtractor principalExtractor, PrivilegesEvaluator evaluator, ThreadPool threadPool, AuditLog auditLog, UserService userService, SecurityKeyStore securityKeyStore, boolean certificatesReloadEnabled) {
        SecurityApiDependencies securityApiDependencies = new SecurityApiDependencies(adminDns, configurationRepository, evaluator, new RestApiPrivilegesEvaluator(settings, adminDns, evaluator, principalExtractor, configPath, threadPool), new RestApiAdminPrivilegesEvaluator(threadPool.getThreadContext(), evaluator, adminDns, settings.getAsBoolean("plugins.security.restapi.admin.enabled", Boolean.valueOf(false))), auditLog, settings);
        return List.of(new RestHandler[]{new InternalUsersApiAction(clusterService, threadPool, userService, securityApiDependencies), new RolesMappingApiAction(clusterService, threadPool, securityApiDependencies), new RolesApiAction(clusterService, threadPool, securityApiDependencies), new ActionGroupsApiAction(clusterService, threadPool, securityApiDependencies), new FlushCacheApiAction(clusterService, threadPool, securityApiDependencies), new SecurityConfigApiAction(clusterService, threadPool, securityApiDependencies), new PermissionsInfoAction(settings, configPath, controller, client, adminDns, configurationRepository, clusterService, principalExtractor, evaluator, threadPool, auditLog), new AuthTokenProcessorAction(clusterService, threadPool, securityApiDependencies), new TenantsApiAction(clusterService, threadPool, securityApiDependencies), new MigrateApiAction(clusterService, threadPool, securityApiDependencies), new ValidateApiAction(clusterService, threadPool, securityApiDependencies), new AccountApiAction(clusterService, threadPool, securityApiDependencies), new NodesDnApiAction(clusterService, threadPool, securityApiDependencies), new WhitelistApiAction(clusterService, threadPool, securityApiDependencies), new AllowlistApiAction(Endpoint.ALLOWLIST, clusterService, threadPool, securityApiDependencies), new AuditApiAction(clusterService, threadPool, securityApiDependencies), new MultiTenancyConfigApiAction(clusterService, threadPool, securityApiDependencies), new SecuritySSLCertsAction(clusterService, threadPool, securityKeyStore, certificatesReloadEnabled, securityApiDependencies)});
    }
}

