/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.shard;

import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.ReferenceManager;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.threadpool.ThreadPool;

public abstract class CloseableRetryableRefreshListener
implements ReferenceManager.RefreshListener,
Closeable {
    private static final int TOTAL_PERMITS = 1;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Semaphore semaphore = new Semaphore(1);
    private final ThreadPool threadPool;
    private final AtomicBoolean retryScheduled = new AtomicBoolean(false);

    public CloseableRetryableRefreshListener() {
        this.threadPool = null;
    }

    public CloseableRetryableRefreshListener(ThreadPool threadPool) {
        assert (Objects.nonNull(threadPool));
        this.threadPool = threadPool;
    }

    public final void afterRefresh(boolean didRefresh) throws IOException {
        if (this.closed.get()) {
            return;
        }
        this.runAfterRefreshExactlyOnce(didRefresh);
        this.runAfterRefreshWithPermit(didRefresh, () -> {});
    }

    protected void runAfterRefreshExactlyOnce(boolean didRefresh) {
    }

    protected String getRetryThreadPoolName() {
        return "same";
    }

    protected TimeValue getNextRetryInterval() {
        return TimeValue.timeValueSeconds((long)1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleRetry(TimeValue interval, String retryThreadPoolName, boolean didRefresh) {
        if (this.closed.get() || !this.isRetryEnabled()) {
            return;
        }
        assert (Objects.nonNull(interval) && ThreadPool.THREAD_POOL_TYPES.containsKey(retryThreadPoolName));
        if (this.retryScheduled.getAndSet(true)) {
            return;
        }
        boolean scheduled = false;
        try {
            this.threadPool.schedule(() -> this.runAfterRefreshWithPermit(didRefresh, () -> this.retryScheduled.set(false)), interval, retryThreadPoolName);
            scheduled = true;
            this.getLogger().info("Scheduled retry with didRefresh={}", (Object)didRefresh);
        }
        finally {
            if (!scheduled) {
                this.retryScheduled.set(false);
            }
        }
    }

    protected boolean isRetryEnabled() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void runAfterRefreshWithPermit(boolean didRefresh, Runnable runFinally) {
        boolean successful;
        if (this.closed.get()) {
            return;
        }
        boolean permitAcquired = this.semaphore.tryAcquire();
        try {
            successful = permitAcquired && this.performAfterRefreshWithPermit(didRefresh);
        }
        finally {
            if (permitAcquired) {
                this.semaphore.release();
            }
            runFinally.run();
        }
        this.scheduleRetry(successful, didRefresh);
    }

    private void scheduleRetry(boolean afterRefreshSuccessful, boolean didRefresh) {
        if (!afterRefreshSuccessful) {
            this.scheduleRetry(this.getNextRetryInterval(), this.getRetryThreadPoolName(), didRefresh);
        }
    }

    protected abstract boolean performAfterRefreshWithPermit(boolean var1);

    @Override
    public final void close() throws IOException {
        try {
            if (this.semaphore.tryAcquire(1, 10L, TimeUnit.MINUTES)) {
                boolean result = this.closed.compareAndSet(false, true);
                assert (result && this.semaphore.availablePermits() == 0);
            } else {
                throw new TimeoutException("timeout while closing gated refresh listener");
            }
            this.getLogger().info("Closed");
        }
        catch (InterruptedException | TimeoutException e) {
            throw new RuntimeException("Failed to close the closeable retryable listener", e);
        }
    }

    protected abstract Logger getLogger();

    boolean getRetryScheduledStatus() {
        return this.retryScheduled.get();
    }
}

