/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.queries.function.FunctionScoreQuery;
import org.apache.lucene.search.Query;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.InnerHitContextBuilder;
import org.opensearch.index.query.MatchNoneQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryRewriteContext;
import org.opensearch.index.query.QueryShardContext;

public class BoostingQueryBuilder
extends AbstractQueryBuilder<BoostingQueryBuilder> {
    public static final String NAME = "boosting";
    private static final ParseField POSITIVE_FIELD = new ParseField("positive", new String[0]);
    private static final ParseField NEGATIVE_FIELD = new ParseField("negative", new String[0]);
    private static final ParseField NEGATIVE_BOOST_FIELD = new ParseField("negative_boost", new String[0]);
    private final QueryBuilder positiveQuery;
    private final QueryBuilder negativeQuery;
    private float negativeBoost = -1.0f;

    public BoostingQueryBuilder(QueryBuilder positiveQuery, QueryBuilder negativeQuery) {
        if (positiveQuery == null) {
            throw new IllegalArgumentException("inner clause [positive] cannot be null.");
        }
        if (negativeQuery == null) {
            throw new IllegalArgumentException("inner clause [negative] cannot be null.");
        }
        this.positiveQuery = positiveQuery;
        this.negativeQuery = negativeQuery;
    }

    public BoostingQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.positiveQuery = (QueryBuilder)in.readNamedWriteable(QueryBuilder.class);
        this.negativeQuery = (QueryBuilder)in.readNamedWriteable(QueryBuilder.class);
        this.negativeBoost = in.readFloat();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.positiveQuery);
        out.writeNamedWriteable((NamedWriteable)this.negativeQuery);
        out.writeFloat(this.negativeBoost);
    }

    public QueryBuilder positiveQuery() {
        return this.positiveQuery;
    }

    public QueryBuilder negativeQuery() {
        return this.negativeQuery;
    }

    public BoostingQueryBuilder negativeBoost(float negativeBoost) {
        if (negativeBoost < 0.0f) {
            throw new IllegalArgumentException("query requires negativeBoost to be set to positive value");
        }
        this.negativeBoost = negativeBoost;
        return this;
    }

    public float negativeBoost() {
        return this.negativeBoost;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(POSITIVE_FIELD.getPreferredName());
        this.positiveQuery.toXContent(builder, params);
        builder.field(NEGATIVE_FIELD.getPreferredName());
        this.negativeQuery.toXContent(builder, params);
        builder.field(NEGATIVE_BOOST_FIELD.getPreferredName(), this.negativeBoost);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static BoostingQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        QueryBuilder positiveQuery = null;
        boolean positiveQueryFound = false;
        QueryBuilder negativeQuery = null;
        boolean negativeQueryFound = false;
        float boost = 1.0f;
        float negativeBoost = -1.0f;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (POSITIVE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    positiveQuery = BoostingQueryBuilder.parseInnerQueryBuilder(parser);
                    positiveQueryFound = true;
                    continue;
                }
                if (NEGATIVE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    negativeQuery = BoostingQueryBuilder.parseInnerQueryBuilder(parser);
                    negativeQueryFound = true;
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[boosting] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (!token.isValue()) continue;
            if (NEGATIVE_BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                negativeBoost = parser.floatValue();
                continue;
            }
            if (NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                queryName = parser.text();
                continue;
            }
            if (BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                boost = parser.floatValue();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "[boosting] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (!positiveQueryFound) {
            throw new ParsingException(parser.getTokenLocation(), "[boosting] query requires 'positive' query to be set'", new Object[0]);
        }
        if (!negativeQueryFound) {
            throw new ParsingException(parser.getTokenLocation(), "[boosting] query requires 'negative' query to be set'", new Object[0]);
        }
        if (negativeBoost < 0.0f) {
            throw new ParsingException(parser.getTokenLocation(), "[boosting] query requires 'negative_boost' to be set to be a positive value'", new Object[0]);
        }
        BoostingQueryBuilder boostingQuery = new BoostingQueryBuilder(positiveQuery, negativeQuery);
        boostingQuery.negativeBoost(negativeBoost);
        boostingQuery.boost(boost);
        boostingQuery.queryName(queryName);
        return boostingQuery;
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        Query positive = this.positiveQuery.toQuery(context);
        Query negative = this.negativeQuery.toQuery(context);
        return FunctionScoreQuery.boostByQuery((Query)positive, (Query)negative, (float)this.negativeBoost);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(Float.valueOf(this.negativeBoost), this.positiveQuery, this.negativeQuery);
    }

    @Override
    protected boolean doEquals(BoostingQueryBuilder other) {
        return Objects.equals(Float.valueOf(this.negativeBoost), Float.valueOf(other.negativeBoost)) && Objects.equals(this.positiveQuery, other.positiveQuery) && Objects.equals(this.negativeQuery, other.negativeQuery);
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        QueryBuilder positiveQuery = this.positiveQuery.rewrite(queryRewriteContext);
        if (positiveQuery instanceof MatchNoneQueryBuilder) {
            return positiveQuery;
        }
        QueryBuilder negativeQuery = this.negativeQuery.rewrite(queryRewriteContext);
        if (positiveQuery != this.positiveQuery || negativeQuery != this.negativeQuery) {
            BoostingQueryBuilder newQueryBuilder = new BoostingQueryBuilder(positiveQuery, negativeQuery);
            newQueryBuilder.negativeBoost = this.negativeBoost;
            return newQueryBuilder;
        }
        return this;
    }

    @Override
    protected void extractInnerHitBuilders(Map<String, InnerHitContextBuilder> innerHits) {
        InnerHitContextBuilder.extractInnerHits(this.positiveQuery, innerHits);
        InnerHitContextBuilder.extractInnerHits(this.negativeQuery, innerHits);
    }
}

