/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.datasources.service;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.datasource.DataSourceService;
import org.opensearch.sql.datasource.model.DataSource;
import org.opensearch.sql.datasource.model.DataSourceMetadata;
import org.opensearch.sql.datasources.auth.DataSourceUserAuthorizationHelper;
import org.opensearch.sql.datasources.exceptions.DataSourceNotFoundException;
import org.opensearch.sql.datasources.service.DataSourceLoaderCache;
import org.opensearch.sql.datasources.service.DataSourceLoaderCacheImpl;
import org.opensearch.sql.datasources.service.DataSourceMetadataStorage;
import org.opensearch.sql.storage.DataSourceFactory;

public class DataSourceServiceImpl
implements DataSourceService {
    private static String DATASOURCE_NAME_REGEX = "[@*A-Za-z]+?[*a-zA-Z_\\-0-9]*";
    private final DataSourceLoaderCache dataSourceLoaderCache;
    private final DataSourceMetadataStorage dataSourceMetadataStorage;
    private final DataSourceUserAuthorizationHelper dataSourceUserAuthorizationHelper;

    public DataSourceServiceImpl(Set<DataSourceFactory> dataSourceFactories, DataSourceMetadataStorage dataSourceMetadataStorage, DataSourceUserAuthorizationHelper dataSourceUserAuthorizationHelper) {
        this.dataSourceMetadataStorage = dataSourceMetadataStorage;
        this.dataSourceUserAuthorizationHelper = dataSourceUserAuthorizationHelper;
        this.dataSourceLoaderCache = new DataSourceLoaderCacheImpl(dataSourceFactories);
    }

    public Set<DataSourceMetadata> getDataSourceMetadata(boolean isDefaultDataSourceRequired) {
        List<DataSourceMetadata> dataSourceMetadataList = this.dataSourceMetadataStorage.getDataSourceMetadata();
        HashSet<DataSourceMetadata> dataSourceMetadataSet = new HashSet<DataSourceMetadata>(dataSourceMetadataList);
        if (isDefaultDataSourceRequired) {
            dataSourceMetadataSet.add(DataSourceMetadata.defaultOpenSearchDataSourceMetadata());
        }
        this.removeAuthInfo(dataSourceMetadataSet);
        return dataSourceMetadataSet;
    }

    public DataSourceMetadata getDataSourceMetadata(String datasourceName) {
        Optional<DataSourceMetadata> dataSourceMetadataOptional = this.getDataSourceMetadataFromName(datasourceName);
        if (dataSourceMetadataOptional.isEmpty()) {
            throw new IllegalArgumentException("DataSource with name: " + datasourceName + " doesn't exist.");
        }
        this.removeAuthInfo(dataSourceMetadataOptional.get());
        return dataSourceMetadataOptional.get();
    }

    public DataSource getDataSource(String dataSourceName) {
        Optional<DataSourceMetadata> dataSourceMetadataOptional = this.getDataSourceMetadataFromName(dataSourceName);
        if (dataSourceMetadataOptional.isEmpty()) {
            throw new DataSourceNotFoundException(String.format("DataSource with name %s doesn't exist.", dataSourceName));
        }
        DataSourceMetadata dataSourceMetadata = dataSourceMetadataOptional.get();
        this.dataSourceUserAuthorizationHelper.authorizeDataSource(dataSourceMetadata);
        return this.dataSourceLoaderCache.getOrLoadDataSource(dataSourceMetadata);
    }

    public void createDataSource(DataSourceMetadata metadata) {
        this.validateDataSourceMetaData(metadata);
        if (!metadata.getName().equals("@opensearch")) {
            this.dataSourceLoaderCache.getOrLoadDataSource(metadata);
            this.dataSourceMetadataStorage.createDataSourceMetadata(metadata);
        }
    }

    public void updateDataSource(DataSourceMetadata dataSourceMetadata) {
        this.validateDataSourceMetaData(dataSourceMetadata);
        if (dataSourceMetadata.getName().equals("@opensearch")) {
            throw new UnsupportedOperationException("Not allowed to update default datasource :@opensearch");
        }
        this.dataSourceLoaderCache.getOrLoadDataSource(dataSourceMetadata);
        this.dataSourceMetadataStorage.updateDataSourceMetadata(dataSourceMetadata);
    }

    public void deleteDataSource(String dataSourceName) {
        if (dataSourceName.equals("@opensearch")) {
            throw new UnsupportedOperationException("Not allowed to delete default datasource :@opensearch");
        }
        this.dataSourceMetadataStorage.deleteDataSourceMetadata(dataSourceName);
    }

    public Boolean dataSourceExists(String dataSourceName) {
        return "@opensearch".equals(dataSourceName) || this.dataSourceMetadataStorage.getDataSourceMetadata(dataSourceName).isPresent();
    }

    private void validateDataSourceMetaData(DataSourceMetadata metadata) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)metadata.getName()) ? 1 : 0) != 0, (Object)"Missing Name Field from a DataSource. Name is a required parameter.");
        Preconditions.checkArgument((boolean)metadata.getName().matches(DATASOURCE_NAME_REGEX), (Object)StringUtils.format((String)"DataSource Name: %s contains illegal characters. Allowed characters: a-zA-Z0-9_-*@.", (Object[])new Object[]{metadata.getName()}));
        Preconditions.checkArgument((!Objects.isNull(metadata.getProperties()) ? 1 : 0) != 0, (Object)"Missing properties field in datasource configuration. Properties are required parameters.");
    }

    private Optional<DataSourceMetadata> getDataSourceMetadataFromName(String dataSourceName) {
        if (dataSourceName.equals("@opensearch")) {
            return Optional.of(DataSourceMetadata.defaultOpenSearchDataSourceMetadata());
        }
        return this.dataSourceMetadataStorage.getDataSourceMetadata(dataSourceName);
    }

    private void removeAuthInfo(Set<DataSourceMetadata> dataSourceMetadataSet) {
        dataSourceMetadataSet.forEach(this::removeAuthInfo);
    }

    private void removeAuthInfo(DataSourceMetadata dataSourceMetadata) {
        HashMap safeProperties = new HashMap(dataSourceMetadata.getProperties());
        safeProperties.entrySet().removeIf(entry -> ((String)entry.getKey()).contains("auth"));
        dataSourceMetadata.setProperties(safeProperties);
    }
}

