/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.transport;

import java.io.IOException;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.securityanalytics.action.UpdateIndexMappingsAction;
import org.opensearch.securityanalytics.action.UpdateIndexMappingsRequest;
import org.opensearch.securityanalytics.mapper.MapperService;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportUpdateIndexMappingsAction
extends HandledTransportAction<UpdateIndexMappingsRequest, AcknowledgedResponse> {
    private MapperService mapperService;
    private ClusterService clusterService;
    private final ThreadPool threadPool;

    @Inject
    public TransportUpdateIndexMappingsAction(TransportService transportService, ActionFilters actionFilters, ThreadPool threadPool, UpdateIndexMappingsAction updateIndexMappingsAction, MapperService mapperService, ClusterService clusterService) {
        super("cluster:admin/opensearch/securityanalytics/mapping/update", transportService, actionFilters, UpdateIndexMappingsRequest::new);
        this.clusterService = clusterService;
        this.mapperService = mapperService;
        this.threadPool = threadPool;
    }

    protected void doExecute(Task task, UpdateIndexMappingsRequest request, ActionListener<AcknowledgedResponse> actionListener) {
        this.threadPool.getThreadContext().stashContext();
        try {
            IndexMetadata index = this.clusterService.state().metadata().index(request.getIndexName());
            if (index == null) {
                actionListener.onFailure((Exception)SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException("Could not find index [" + request.getIndexName() + "]", RestStatus.NOT_FOUND, new Object[0])));
                return;
            }
            this.mapperService.updateMappingAction(request.getIndexName(), request.getAlias(), this.buildAliasJson(request.getField()), actionListener);
        }
        catch (IOException e) {
            actionListener.onFailure((Exception)e);
        }
    }

    private String buildAliasJson(String fieldName) throws IOException {
        return "type=alias,path=" + fieldName;
    }
}

