/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.transport;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRunnable;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.routing.Preference;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.securityanalytics.action.ListCorrelationsRequest;
import org.opensearch.securityanalytics.action.ListCorrelationsResponse;
import org.opensearch.securityanalytics.model.CorrelatedFinding;
import org.opensearch.securityanalytics.transport.SecureTransportAction;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportListCorrelationAction
extends HandledTransportAction<ListCorrelationsRequest, ListCorrelationsResponse>
implements SecureTransportAction {
    private static final Logger log = LogManager.getLogger(TransportListCorrelationAction.class);
    private final ClusterService clusterService;
    private final Settings settings;
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;
    private final ThreadPool threadPool;

    @Inject
    public TransportListCorrelationAction(TransportService transportService, Client client, NamedXContentRegistry xContentRegistry, ClusterService clusterService, Settings settings, ActionFilters actionFilters) {
        super("cluster:admin/opensearch/securityanalytics/correlations/list", transportService, actionFilters, ListCorrelationsRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.settings = settings;
        this.threadPool = this.client.threadPool();
    }

    protected void doExecute(Task task, ListCorrelationsRequest request, ActionListener<ListCorrelationsResponse> actionListener) {
        AsyncListCorrelationAction asyncAction = new AsyncListCorrelationAction(task, request, actionListener);
        asyncAction.start();
    }

    class AsyncListCorrelationAction {
        private ListCorrelationsRequest request;
        private ActionListener<ListCorrelationsResponse> listener;
        private final AtomicReference<Object> response;
        private final AtomicBoolean counter = new AtomicBoolean();
        private final Task task;

        AsyncListCorrelationAction(Task task, ListCorrelationsRequest request, ActionListener<ListCorrelationsResponse> listener) {
            this.task = task;
            this.request = request;
            this.listener = listener;
            this.response = new AtomicReference();
        }

        void start() {
            Long startTimestamp = this.request.getStartTimestamp();
            Long endTimestamp = this.request.getEndTimestamp();
            BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"finding1", (Object)"")).mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"finding2", (Object)"")).filter((QueryBuilder)QueryBuilders.rangeQuery((String)"timestamp").gte((Object)startTimestamp).lte((Object)endTimestamp));
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)queryBuilder);
            searchSourceBuilder.fetchSource(true);
            searchSourceBuilder.size(10000);
            SearchRequest searchRequest = new SearchRequest();
            searchRequest.indices(new String[]{".opensearch-sap-correlation-history"});
            searchRequest.source(searchSourceBuilder);
            searchRequest.preference(Preference.PRIMARY_FIRST.type());
            TransportListCorrelationAction.this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                public void onResponse(SearchResponse response) {
                    if (response.isTimedOut()) {
                        AsyncListCorrelationAction.this.onFailures((Exception)new OpenSearchStatusException(response.toString(), RestStatus.REQUEST_TIMEOUT, new Object[0]));
                    }
                    HashMap<CallSite, CorrelatedFinding> correlatedFindings = new HashMap<CallSite, CorrelatedFinding>();
                    for (SearchHit hit : response.getHits()) {
                        Map source = hit.getSourceAsMap();
                        CorrelatedFinding correlatedFinding = new CorrelatedFinding(source.get("finding1").toString(), source.get("logType").toString().split("-")[0], source.get("finding2").toString(), source.get("logType").toString().split("-")[1], (List)source.get("corrRules"));
                        correlatedFindings.put((CallSite)((Object)(source.get("finding1").toString() + ":" + source.get("finding2").toString())), correlatedFinding);
                    }
                    AsyncListCorrelationAction.this.onOperation(new ListCorrelationsResponse(new ArrayList<CorrelatedFinding>(correlatedFindings.values())));
                }

                public void onFailure(Exception e) {
                    AsyncListCorrelationAction.this.onFailures(e);
                }
            });
        }

        private void onOperation(ListCorrelationsResponse response) {
            this.response.set((Object)response);
            if (this.counter.compareAndSet(false, true)) {
                this.finishHim(response, null);
            }
        }

        private void onFailures(Exception t) {
            if (this.counter.compareAndSet(false, true)) {
                this.finishHim(null, t);
            }
        }

        private void finishHim(ListCorrelationsResponse response, Exception t) {
            TransportListCorrelationAction.this.threadPool.executor("generic").execute((Runnable)ActionRunnable.supply(this.listener, () -> {
                if (t != null) {
                    if (t instanceof OpenSearchStatusException) {
                        throw t;
                    }
                    throw SecurityAnalyticsException.wrap(t);
                }
                return response;
            }));
        }
    }
}

