/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.rules.backend;

import java.util.Locale;
import org.apache.commons.lang3.NotImplementedException;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.aggregations.metrics.AvgAggregationBuilder;
import org.opensearch.search.aggregations.metrics.MaxAggregationBuilder;
import org.opensearch.search.aggregations.metrics.MedianAbsoluteDeviationAggregationBuilder;
import org.opensearch.search.aggregations.metrics.MinAggregationBuilder;
import org.opensearch.search.aggregations.metrics.SumAggregationBuilder;
import org.opensearch.search.aggregations.metrics.ValueCountAggregationBuilder;
import org.opensearch.search.aggregations.support.ValuesSourceAggregationBuilder;

public final class AggregationBuilders {
    public static AggregationBuilder getAggregationBuilderByFunction(String aggregationFunction, String name) {
        ValuesSourceAggregationBuilder aggregationBuilder;
        switch (aggregationFunction.toLowerCase(Locale.ROOT)) {
            case "avg": {
                aggregationBuilder = new AvgAggregationBuilder(name).field(name);
                break;
            }
            case "max": {
                aggregationBuilder = new MaxAggregationBuilder(name).field(name);
                break;
            }
            case "median_absolute_deviation": {
                aggregationBuilder = new MedianAbsoluteDeviationAggregationBuilder(name).field(name);
                break;
            }
            case "min": {
                aggregationBuilder = new MinAggregationBuilder(name).field(name);
                break;
            }
            case "sum": {
                aggregationBuilder = new SumAggregationBuilder(name).field(name);
                break;
            }
            case "terms": {
                aggregationBuilder = new TermsAggregationBuilder(name).field(name);
                break;
            }
            case "count": {
                aggregationBuilder = new ValueCountAggregationBuilder(name).field(name);
                break;
            }
            default: {
                throw new NotImplementedException(String.format(Locale.getDefault(), "Aggregation %s not supported by the backend", aggregationFunction));
            }
        }
        return aggregationBuilder;
    }
}

