/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.model;

import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.securityanalytics.model.Detector;

public class CustomLogType
implements Writeable,
ToXContentObject {
    private static final Logger log = LogManager.getLogger(CustomLogType.class);
    public static final String CUSTOM_LOG_TYPE_ID_FIELD = "custom_logtype_id";
    private static final String NAME_FIELD = "name";
    private static final String DESCRIPTION_FIELD = "description";
    private static final String SOURCE_FIELD = "source";
    private static final String TAGS_FIELD = "tags";
    private String id;
    private Long version;
    private String name;
    private String description;
    private String source;
    private Map<String, Object> tags;
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(CustomLogType.class, new ParseField("logType", new String[0]), xcp -> CustomLogType.parse(xcp, null, null));

    public CustomLogType(String id, Long version, String name, String description, String source, Map<String, Object> tags) {
        this.id = id != null ? id : "";
        this.version = version != null ? version : Detector.NO_VERSION;
        this.name = name;
        this.description = description;
        this.source = source;
        this.tags = tags;
    }

    public CustomLogType(StreamInput sin) throws IOException {
        this(sin.readString(), sin.readLong(), sin.readString(), sin.readString(), sin.readString(), sin.readMap());
    }

    public CustomLogType(Map<String, Object> input) {
        this(null, null, input.get(NAME_FIELD).toString(), input.get(DESCRIPTION_FIELD).toString(), input.get(SOURCE_FIELD).toString(), (Map)input.get(TAGS_FIELD));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeLong(this.version.longValue());
        out.writeString(this.name);
        out.writeString(this.description);
        out.writeString(this.source);
        out.writeMap(this.tags);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(NAME_FIELD, this.name).field(DESCRIPTION_FIELD, this.description).field(SOURCE_FIELD, this.source).field(TAGS_FIELD, this.tags).endObject();
    }

    public static CustomLogType parse(XContentParser xcp, String id, Long version) throws IOException {
        if (id == null) {
            id = "";
        }
        if (version == null) {
            version = Detector.NO_VERSION;
        }
        String name = null;
        String description = null;
        String source = null;
        Map tags = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block12: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "name": {
                    name = xcp.text();
                    continue block12;
                }
                case "description": {
                    description = xcp.text();
                    continue block12;
                }
                case "source": {
                    source = xcp.text();
                    continue block12;
                }
                case "tags": {
                    tags = xcp.map();
                    continue block12;
                }
            }
            xcp.skipChildren();
        }
        return new CustomLogType(id, version, name, description, source, tags);
    }

    public static CustomLogType readFrom(StreamInput sin) throws IOException {
        return new CustomLogType(sin);
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public Long getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSource() {
        return this.source;
    }

    public void setTags(Map<String, Object> tags) {
        this.tags = tags;
    }

    public Map<String, Object> getTags() {
        return this.tags;
    }
}

