/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.reader;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.jooq.BatchBindStep;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.opensearch.performanceanalyzer.commons.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.reader.Removable;

public class AdmissionControlSnapshot
implements Removable {
    private final DSLContext create;
    private final String tableName;
    private List<Field<?>> columns;

    public AdmissionControlSnapshot(Connection conn, Long windowStartTime) {
        this.create = DSL.using((Connection)conn, (SQLDialect)SQLDialect.SQLITE);
        this.tableName = "admission_control_" + windowStartTime;
        this.columns = new ArrayList<Field<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)Fields.CONTROLLER_NAME.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.REJECTION_COUNT.toString()), Long.class));
            }
        };
        this.create.createTable(this.tableName).columns(this.columns).execute();
    }

    public DSLContext getDSLContext() {
        return this.create;
    }

    public BatchBindStep startBatchPut() {
        ArrayList<Object> dummyValues = new ArrayList<Object>();
        for (int i = 0; i < this.columns.size(); ++i) {
            dummyValues.add(null);
        }
        return this.create.batch((Query)this.create.insertInto(DSL.table((String)this.tableName)).values(dummyValues));
    }

    public Result<Record> fetchAll() {
        return this.create.select(new SelectField[0]).from((TableLike)DSL.table((String)this.tableName)).fetch();
    }

    @Override
    public void remove() throws Exception {
        this.create.dropTable(DSL.table((String)this.tableName)).execute();
    }

    public static enum Fields {
        CONTROLLER_NAME(AllMetrics.AdmissionControlDimension.CONTROLLER_NAME.toString()),
        REJECTION_COUNT(AllMetrics.AdmissionControlValue.REJECTION_COUNT.toString());

        private final String fieldValue;

        private Fields(String fieldValue) {
            this.fieldValue = fieldValue;
        }

        public String toString() {
            return this.fieldValue;
        }
    }
}

