/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.metrics;

import java.util.Collections;
import java.util.List;
import org.opensearch.performanceanalyzer.commons.stats.eval.Statistics;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatsType;

public enum JvmMetrics implements MeasurementSet
{
    JVM_FREE_MEM_SAMPLER("JvmFreeMem", "bytes"),
    JVM_TOTAL_MEM_SAMPLER("JvmTotalMem", "bytes"),
    THREAD_COUNT("ThreadCount", "count");

    private String name;
    private String unit;
    private StatsType statsType;

    private JvmMetrics(String name, String unit) {
        this.name = name;
        this.unit = unit;
        this.statsType = StatsType.STATS_DATA;
    }

    public List<Statistics> getStatsList() {
        return Collections.singletonList(Statistics.SAMPLE);
    }

    public StatsType getStatsType() {
        return this.statsType;
    }

    public String getName() {
        return this.name;
    }

    public String getUnit() {
        return this.unit;
    }

    public String toString() {
        return this.name + "-" + this.unit;
    }
}

