/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.MetadataAwareCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.SegmentSpecificCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.ReadOnlyKeyCommand;
import org.infinispan.commands.functional.ReadOnlyManyCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.remote.ClusteredGetAllCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.IracPutKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.ArrayCollector;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.NullCacheEntry;
import org.infinispan.container.entries.RemoteMetadata;
import org.infinispan.container.entries.RepeatableReadEntry;
import org.infinispan.container.entries.metadata.MetadataImmortalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataImmortalCacheValue;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.InequalVersionComparisonResult;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.group.impl.GroupManager;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.eviction.impl.ActivationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.functional.impl.FunctionalNotifier;
import org.infinispan.interceptors.BaseAsyncInterceptor;
import org.infinispan.interceptors.InvocationFinallyAction;
import org.infinispan.interceptors.InvocationSuccessFunction;
import org.infinispan.interceptors.distribution.ConcurrentChangeException;
import org.infinispan.interceptors.distribution.CountDownCompletableFuture;
import org.infinispan.interceptors.distribution.MergingCompletableFuture;
import org.infinispan.interceptors.distribution.PutMapHelper;
import org.infinispan.interceptors.distribution.ReadWriteManyEntriesHelper;
import org.infinispan.interceptors.distribution.ReadWriteManyHelper;
import org.infinispan.interceptors.distribution.WriteManyCommandHelper;
import org.infinispan.interceptors.distribution.WriteOnlyManyEntriesHelper;
import org.infinispan.interceptors.distribution.WriteOnlyManyHelper;
import org.infinispan.interceptors.impl.ClusteringInterceptor;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.NotifyHelper;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.responses.UnsuccessfulResponse;
import org.infinispan.remoting.responses.UnsureResponse;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollectors;
import org.infinispan.remoting.transport.impl.MapResponseCollector;
import org.infinispan.remoting.transport.impl.PassthroughSingleResponseCollector;
import org.infinispan.remoting.transport.impl.SingleResponseCollector;
import org.infinispan.remoting.transport.impl.SingletonMapResponseCollector;
import org.infinispan.scattered.ScatteredVersionManager;
import org.infinispan.statetransfer.AllOwnersLostException;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.topology.CacheTopology;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CommandAckCollector;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.concurrent.DataOperationOrderer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ScatteredDistributionInterceptor
extends ClusteringInterceptor {
    private static final Log log = LogFactory.getLog(ScatteredDistributionInterceptor.class);
    @Inject
    protected ScatteredVersionManager<Object> svm;
    @Inject
    protected GroupManager groupManager;
    @Inject
    protected TimeService timeService;
    @Inject
    protected CacheNotifier cacheNotifier;
    @Inject
    protected FunctionalNotifier functionalNotifier;
    @Inject
    protected KeyPartitioner keyPartitioner;
    @Inject
    PersistenceManager persistenceManager;
    @Inject
    Configuration configuration;
    @Inject
    DataOperationOrderer orderer;
    @Inject
    EvictionManager evictionManager;
    @Inject
    ActivationManager activationManager;
    private boolean hasPassivation;
    private volatile Address cachedNextMember;
    private volatile int cachedNextMemberTopology = -1;
    private final InvocationSuccessFunction<PutMapCommand> putMapCommandHandler = (rCtx, putMapCommand, rv) -> {
        AggregateCompletionStage<Void> aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
        for (Object key : putMapCommand.getAffectedKeys()) {
            aggregateCompletionStage.dependsOn(this.commitSingleEntryIfNewer((RepeatableReadEntry)rCtx.lookupEntry(key), rCtx, putMapCommand));
        }
        return ScatteredDistributionInterceptor.delayedValue(aggregateCompletionStage.freeze(), rv);
    };
    private final InvocationSuccessFunction<ClearCommand> clearHandler = this::handleClear;
    private final InvocationSuccessFunction<DataWriteCommand> handleWritePrimaryResponse = this::handleWritePrimaryResponse;
    private final InvocationSuccessFunction<WriteCommand> handleWriteManyOnPrimary = this::handleWriteManyOnPrimary;
    private PutMapHelper putMapHelper = new PutMapHelper(helper -> null);
    private ReadWriteManyHelper readWriteManyHelper = new ReadWriteManyHelper(helper -> null);
    private ReadWriteManyEntriesHelper readWriteManyEntriesHelper = new ReadWriteManyEntriesHelper(helper -> null);
    private WriteOnlyManyHelper writeOnlyManyHelper = new WriteOnlyManyHelper(helper -> null);
    private WriteOnlyManyEntriesHelper writeOnlyManyEntriesHelper = new WriteOnlyManyEntriesHelper(helper -> null);

    @Start
    public void start() {
        this.hasPassivation = this.configuration.persistence().passivation();
    }

    private Object handleWriteCommand(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        RepeatableReadEntry contextEntry;
        RepeatableReadEntry cacheEntry = (RepeatableReadEntry)ctx.lookupEntry(command.getKey());
        EntryVersion seenVersion = this.getVersionOrNull(cacheEntry);
        LocalizedCacheTopology cacheTopology = this.checkTopology(command);
        DistributionInfo info = cacheTopology.getSegmentDistribution(command.getSegment());
        if (info.primary() == null) {
            throw OutdatedTopologyException.RETRY_NEXT_TOPOLOGY;
        }
        if (this.isLocalModeForced(command)) {
            RepeatableReadEntry contextEntry2 = cacheEntry;
            if (cacheEntry == null) {
                this.entryFactory.wrapExternalEntry(ctx, command.getKey(), null, false, true);
                contextEntry2 = (RepeatableReadEntry)ctx.lookupEntry(command.getKey());
            }
            EntryVersion nextVersion = null;
            if (!command.hasAnyFlag(FlagBitSets.PUT_FOR_STATE_TRANSFER) && info.isPrimary()) {
                if (!cacheTopology.isConnected() && command instanceof MetadataAwareCommand) {
                    Metadata metadata = ((MetadataAwareCommand)((Object)command)).getMetadata();
                    this.svm.updatePreloadedEntryVersion(metadata.version());
                } else {
                    nextVersion = this.svm.incrementVersion(info.segmentId());
                }
            }
            return this.commitSingleEntryOnReturn(ctx, command, contextEntry2, nextVersion);
        }
        if (ctx.isOriginLocal()) {
            if (info.isPrimary()) {
                Object seenValue = cacheEntry.getValue();
                return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> this.handleWriteOnOriginPrimary(rCtx, (DataWriteCommand)rCommand, rv, cacheEntry, seenValue, seenVersion, cacheTopology, info));
            }
            CompletionStage<ValidResponse> rpcFuture = this.singleWriteOnRemotePrimary(info.primary(), command);
            return ScatteredDistributionInterceptor.asyncValue(rpcFuture).thenApply(ctx, command, this.handleWritePrimaryResponse);
        }
        if (info.isPrimary()) {
            return this.invokeNextThenApply(ctx, command, (rCtx, cmd, rv) -> {
                if (!cmd.isSuccessful()) {
                    if (log.isTraceEnabled()) {
                        log.tracef("Skipping the replication of the command as it did not succeed on primary owner (%s).", cmd);
                    }
                    return this.singleWriteResponse(rCtx, (DataWriteCommand)cmd, rv);
                }
                EntryVersion nextVersion = this.svm.incrementVersion(info.segmentId());
                Metadata metadata = ScatteredDistributionInterceptor.addVersion(cacheEntry.getMetadata(), nextVersion);
                cacheEntry.setMetadata(metadata);
                CompletionStage<Void> stage = cmd.loadType() != VisitableCommand.LoadType.DONT_LOAD ? this.commitSingleEntryIfNoChange(cacheEntry, rCtx, cmd) : this.commitSingleEntryIfNewer(cacheEntry, rCtx, cmd);
                Object returnValue = cmd.acceptVisitor(ctx, new PrimaryResponseGenerator(cacheEntry, rv));
                return ScatteredDistributionInterceptor.asyncValue(stage).thenApply(rCtx, cmd, (rCtx2, rCommand2, rv2) -> this.singleWriteResponse(rCtx, (DataWriteCommand)rCommand2, returnValue));
            });
        }
        assert (cacheEntry == null || command.hasAnyFlag(FlagBitSets.SKIP_OWNERSHIP_CHECK));
        if (cacheEntry == null) {
            this.entryFactory.wrapExternalEntry(ctx, command.getKey(), null, false, true);
            contextEntry = (RepeatableReadEntry)ctx.lookupEntry(command.getKey());
        } else {
            contextEntry = cacheEntry;
        }
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> ScatteredDistributionInterceptor.delayedNull(this.commitSingleEntryIfNewer(contextEntry, rCtx, rCommand)));
    }

    @Override
    public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) {
        this.dataContainer.evict(command.getKey());
        return null;
    }

    protected CompletionStage<ValidResponse> singleWriteOnRemotePrimary(Address target, DataWriteCommand command) {
        return this.rpcManager.invokeCommand(target, (ReplicableCommand)command, SingleResponseCollector.validOnly(), this.rpcManager.getSyncRpcOptions());
    }

    protected CompletionStage<ValidResponse> manyWriteOnRemotePrimary(Address target, WriteCommand command, CommandAckCollector.MultiTargetCollector multiTargetCollector) {
        return this.rpcManager.invokeCommand(target, (ReplicableCommand)command, SingleResponseCollector.validOnly(), this.rpcManager.getSyncRpcOptions());
    }

    protected CompletionStage<?> completeSingleWriteOnPrimaryOriginator(DataWriteCommand command, Address backup, CompletionStage<?> rpcFuture) {
        return rpcFuture;
    }

    private Object handleWriteOnOriginPrimary(InvocationContext ctx, DataWriteCommand command, Object rv, RepeatableReadEntry cacheEntry, Object seenValue, EntryVersion seenVersion, CacheTopology cacheTopology, DistributionInfo info) {
        AbstractDataWriteCommand backupCommand;
        if (!command.isSuccessful()) {
            if (log.isTraceEnabled()) {
                log.tracef("Skipping the replication of the command as it did not succeed on primary owner (%s).", command);
            }
            return rv;
        }
        EntryVersion nextVersion = this.svm.incrementVersion(info.segmentId());
        Metadata metadata = ScatteredDistributionInterceptor.addVersion(cacheEntry.getMetadata(), nextVersion);
        cacheEntry.setMetadata(metadata);
        CompletionStage<Void> stage = command.loadType() != VisitableCommand.LoadType.DONT_LOAD ? this.commitSingleEntryIfNoChange(cacheEntry, ctx, command) : this.commitSingleEntryIfNewer(cacheEntry, ctx, command);
        long flags = command.getFlagsBitSet() | FlagBitSets.SKIP_OWNERSHIP_CHECK;
        if (cacheEntry.isRemoved()) {
            backupCommand = this.cf.buildRemoveCommand(command.getKey(), null, info.segmentId(), flags);
            ((RemoveCommand)backupCommand).setMetadata(cacheEntry.getMetadata());
        } else {
            backupCommand = this.cf.buildPutKeyValueCommand(command.getKey(), cacheEntry.getValue(), info.segmentId(), cacheEntry.getMetadata(), flags);
        }
        backupCommand.setTopologyId(command.getTopologyId());
        Address backup = this.getNextMember(cacheTopology);
        if (backup != null) {
            CompletionStage<ValidResponse> rpcFuture = this.rpcManager.invokeCommand(backup, (ReplicableCommand)backupCommand, SingleResponseCollector.validOnly(), this.rpcManager.getSyncRpcOptions());
            rpcFuture.thenRun(() -> {
                if (cacheEntry.isCommitted() && !command.hasAnyFlag(FlagBitSets.PUT_FOR_STATE_TRANSFER)) {
                    this.scheduleKeyInvalidation(command.getKey(), cacheEntry.getMetadata().version(), cacheEntry.isRemoved());
                }
            });
            rpcFuture = this.completeSingleWriteOnPrimaryOriginator(command, backup, rpcFuture);
            return ScatteredDistributionInterceptor.delayedValue(CompletionStages.allOf(new CompletionStage[]{stage.toCompletableFuture(), rpcFuture.toCompletableFuture()}), rv);
        }
        return ScatteredDistributionInterceptor.delayedValue(stage, rv);
    }

    private Object handleWritePrimaryResponse(InvocationContext ctx, DataWriteCommand command, Object rv) {
        Response response = (Response)rv;
        if (!response.isSuccessful()) {
            command.fail();
            if (response instanceof UnsuccessfulResponse) {
                return ((UnsuccessfulResponse)response).getResponseValue();
            }
            throw new CacheException("Unexpected response " + response);
        }
        Object responseValue = ((SuccessfulResponse)response).getResponseValue();
        try {
            return command.acceptVisitor(ctx, new PrimaryResponseHandler(responseValue));
        }
        catch (Throwable throwable) {
            throw CompletableFutures.asCompletionException((Throwable)throwable);
        }
    }

    private <T extends FlagAffectedCommand & TopologyAffectedCommand> LocalizedCacheTopology checkTopology(T command) {
        LocalizedCacheTopology cacheTopology = this.distributionManager.getCacheTopology();
        if (!command.hasAnyFlag(FlagBitSets.SKIP_OWNERSHIP_CHECK | FlagBitSets.CACHE_MODE_LOCAL) && ((TopologyAffectedCommand)command).getTopologyId() != cacheTopology.getTopologyId()) {
            assert (((TopologyAffectedCommand)command).getTopologyId() >= 0);
            throw OutdatedTopologyException.RETRY_SAME_TOPOLOGY;
        }
        if (log.isTraceEnabled()) {
            log.tracef("%s has topology %d (current is %d)", command, ((TopologyAffectedCommand)command).getTopologyId(), cacheTopology.getTopologyId());
        }
        return cacheTopology;
    }

    private Object commitSingleEntryOnReturn(InvocationContext ctx, DataWriteCommand command, RepeatableReadEntry cacheEntry, EntryVersion nextVersion) {
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            if (nextVersion != null) {
                cacheEntry.setMetadata(ScatteredDistributionInterceptor.addVersion(cacheEntry.getMetadata(), nextVersion));
            }
            CompletionStage<Void> stage = command.loadType() != VisitableCommand.LoadType.DONT_LOAD ? this.commitSingleEntryIfNoChange(cacheEntry, rCtx, rCommand) : this.commitSingleEntryIfNewer(cacheEntry, rCtx, rCommand);
            if (cacheEntry.isCommitted() && rCtx.isOriginLocal() && nextVersion != null) {
                this.scheduleKeyInvalidation(rCommand.getKey(), nextVersion, cacheEntry.isRemoved());
            }
            return ScatteredDistributionInterceptor.delayedValue(stage, rv);
        });
    }

    protected void scheduleKeyInvalidation(Object key, EntryVersion nextVersion, boolean removed) {
        this.svm.scheduleKeyInvalidation(key, nextVersion, removed);
    }

    private CompletionStage<Void> commitOperation(RepeatableReadEntry entry, Predicate<RepeatableReadEntry> wasCommitted, InvocationContext ctx, VisitableCommand command) {
        CompletableFuture<DataOperationOrderer.Operation> orderingStage;
        if (!entry.isChanged()) {
            if (log.isTraceEnabled()) {
                log.tracef("Entry has not changed, not committing", new Object[0]);
            }
        } else if (entry.isRemoved()) {
            entry.setValue(null);
        }
        if (!this.hasPassivation && wasCommitted.test(entry)) {
            return NotifyHelper.entryCommitted(this.cacheNotifier, this.functionalNotifier, entry.isCreated(), entry.isRemoved(), entry.isExpired(), entry, ctx, (FlagAffectedCommand)command, entry.getOldValue(), entry.getOldMetadata(), this.evictionManager);
        }
        Object key = entry.getKey();
        CompletionStage<DataOperationOrderer.Operation> waitStage = this.orderer.orderOn(key, orderingStage = new CompletableFuture<DataOperationOrderer.Operation>());
        CompletionStage committedStage = waitStage == null ? CompletableFutures.booleanStage((boolean)wasCommitted.test(entry)) : waitStage.thenCompose(ignore -> CompletableFutures.booleanStage((boolean)wasCommitted.test(entry)));
        CompletionStage lastStage = committedStage.thenCompose(committed -> {
            if (committed.booleanValue()) {
                CompletionStage<Void> notificationStage = NotifyHelper.entryCommitted(this.cacheNotifier, this.functionalNotifier, entry.isCreated(), entry.isRemoved(), entry.isExpired(), entry, ctx, (FlagAffectedCommand)command, entry.getOldValue(), entry.getOldMetadata(), this.evictionManager);
                return notificationStage.thenCompose(ignore -> this.activationManager.activateAsync(key, SegmentSpecificCommand.extractSegment(command, key, this.keyPartitioner)));
            }
            return CompletableFutures.completedNull();
        });
        return lastStage.whenComplete((ignore, ignoreT) -> this.orderer.completeOperation(key, orderingStage, entry.isRemoved() ? DataOperationOrderer.Operation.REMOVE : DataOperationOrderer.Operation.WRITE));
    }

    private CompletionStage<Void> commitSingleEntryIfNewer(RepeatableReadEntry entry, InvocationContext ctx, VisitableCommand command) {
        return this.commitOperation(entry, this::updateEntryIfNewer, ctx, command);
    }

    private boolean updateEntryIfNewer(RepeatableReadEntry entry) {
        this.dataContainer.compute(entry.getKey(), (key, oldEntry, factory) -> {
            InequalVersionComparisonResult comparisonResult;
            Metadata newMetadata = entry.getMetadata();
            if (oldEntry == null) {
                if (entry.getValue() == null && newMetadata == null) {
                    if (log.isTraceEnabled()) {
                        log.trace("No previous record and this is a removal, not committing anything.");
                    }
                    return null;
                }
                if (log.isTraceEnabled()) {
                    log.trace("Committing new entry " + entry);
                }
                entry.setCommitted();
                return factory.create(entry);
            }
            Metadata oldMetadata = oldEntry.getMetadata();
            if (oldMetadata == null || oldMetadata.version() == null || newMetadata == null || newMetadata.version() == null || (comparisonResult = oldMetadata.version().compareTo(newMetadata.version())) == InequalVersionComparisonResult.BEFORE || oldMetadata instanceof RemoteMetadata && comparisonResult == InequalVersionComparisonResult.EQUAL) {
                if (log.isTraceEnabled()) {
                    log.tracef("Committing entry %s, replaced %s", entry, oldEntry);
                }
                entry.setCommitted();
                if (entry.getValue() != null || newMetadata != null) {
                    return factory.create(entry);
                }
                return null;
            }
            if (log.isTraceEnabled()) {
                log.tracef("Not committing %s, current entry is %s", entry, oldEntry);
            }
            return oldEntry;
        });
        return entry.isCommitted();
    }

    private CompletionStage<Void> commitSingleEntryIfNoChange(RepeatableReadEntry entry, InvocationContext ctx, VisitableCommand command) {
        return this.commitOperation(entry, this::updateEntryIfNoChange, ctx, command);
    }

    private boolean updateEntryIfNoChange(RepeatableReadEntry entry) {
        this.dataContainer.compute(entry.getKey(), (key, oldEntry, factory) -> {
            InequalVersionComparisonResult comparisonResult;
            EntryVersion oldVersion;
            Metadata oldMetadata;
            Metadata newMetadata;
            block19: {
                EntryVersion seenVersion;
                block20: {
                    block18: {
                        newMetadata = entry.getMetadata();
                        if (oldEntry == null) {
                            if (entry.getOldValue() != null) {
                                if (log.isTraceEnabled()) {
                                    log.trace("Non-null value in context, not committing");
                                }
                                throw new ConcurrentChangeException();
                            }
                            if (entry.getValue() == null && newMetadata == null) {
                                if (log.isTraceEnabled()) {
                                    log.trace("No previous record and this is a removal, not committing anything.");
                                }
                                return null;
                            }
                            if (log.isTraceEnabled()) {
                                log.trace("Committing new entry " + entry);
                            }
                            entry.setCommitted();
                            return factory.create(entry);
                        }
                        oldMetadata = oldEntry.getMetadata();
                        oldVersion = oldMetadata == null ? null : oldMetadata.version();
                        Metadata seenMetadata = entry.getOldMetadata();
                        EntryVersion entryVersion = seenVersion = seenMetadata == null ? null : seenMetadata.version();
                        if (oldVersion != null) break block18;
                        if (seenVersion != null) {
                            if (log.isTraceEnabled()) {
                                log.tracef("Current version is null but seen version is %s, throwing", seenVersion);
                            }
                            throw new ConcurrentChangeException();
                        }
                        break block19;
                    }
                    if (seenVersion != null) break block20;
                    if (oldEntry.canExpire() && oldEntry.isExpired(this.timeService.wallClockTime())) {
                        if (log.isTraceEnabled()) {
                            log.trace("Current entry is expired and therefore we haven't seen it");
                        }
                        break block19;
                    } else {
                        if (log.isTraceEnabled()) {
                            log.tracef("Current version is %s but seen version is null, throwing", oldVersion);
                        }
                        throw new ConcurrentChangeException();
                    }
                }
                if (seenVersion.compareTo(oldVersion) != InequalVersionComparisonResult.EQUAL) {
                    if (log.isTraceEnabled()) {
                        log.tracef("Current version is %s but seen version is %s, throwing", oldVersion, seenVersion);
                    }
                    throw new ConcurrentChangeException();
                }
            }
            if (oldVersion == null || newMetadata == null || newMetadata.version() == null || (comparisonResult = oldMetadata.version().compareTo(newMetadata.version())) == InequalVersionComparisonResult.BEFORE || oldMetadata instanceof RemoteMetadata && comparisonResult == InequalVersionComparisonResult.EQUAL) {
                if (log.isTraceEnabled()) {
                    log.tracef("Committing entry %s, replaced %s", entry, oldEntry);
                }
                entry.setCommitted();
                if (entry.getValue() == null && newMetadata == null) {
                    return null;
                }
                return factory.create(entry);
            }
            if (log.isTraceEnabled()) {
                log.tracef("Not committing %s, current entry is %s", entry, oldEntry);
            }
            return oldEntry;
        });
        return entry.isCommitted();
    }

    private EntryVersion getVersionOrNull(CacheEntry cacheEntry) {
        if (cacheEntry == null) {
            return null;
        }
        Metadata metadata = cacheEntry.getMetadata();
        if (metadata != null) {
            return metadata.version();
        }
        return null;
    }

    private static Metadata addVersion(Metadata metadata, EntryVersion nextVersion) {
        Metadata.Builder builder = metadata == null ? new EmbeddedMetadata.Builder() : metadata.builder();
        metadata = builder.version(nextVersion).build();
        return metadata;
    }

    private Address getNextMember(CacheTopology cacheTopology) {
        if (cacheTopology.getTopologyId() == this.cachedNextMemberTopology) {
            return this.cachedNextMember;
        }
        ConsistentHash ch = cacheTopology.getWriteConsistentHash();
        List<Address> members = ch.getMembers();
        Address address = this.rpcManager.getAddress();
        Address nextMember = null;
        if (members.size() > 1) {
            for (int i = 0; i < members.size(); ++i) {
                Address member = members.get(i);
                if (!member.equals(address)) continue;
                if (i + 1 < members.size()) {
                    nextMember = members.get(i + 1);
                    break;
                }
                nextMember = members.get(0);
                break;
            }
        }
        this.cachedNextMember = nextMember;
        this.cachedNextMemberTopology = cacheTopology.getTopologyId();
        return nextMember;
    }

    private Object handleReadCommand(InvocationContext ctx, AbstractDataCommand command) throws Throwable {
        LocalizedCacheTopology cacheTopology = this.checkTopology(command);
        CacheEntry entry = ctx.lookupEntry(command.getKey());
        if (entry != null) {
            return this.invokeNext(ctx, command);
        }
        DistributionInfo info = cacheTopology.getSegmentDistribution(command.getSegment());
        if (info.isPrimary()) {
            if (log.isTraceEnabled()) {
                log.tracef("In topology %d this is primary owner", cacheTopology.getTopologyId());
            }
            return this.invokeNext(ctx, command);
        }
        if (command.hasAnyFlag(FlagBitSets.SKIP_OWNERSHIP_CHECK)) {
            if (log.isTraceEnabled()) {
                log.trace("Ignoring ownership");
            }
            return this.invokeNext(ctx, command);
        }
        if (info.primary() == null) {
            throw OutdatedTopologyException.RETRY_NEXT_TOPOLOGY;
        }
        if (ctx.isOriginLocal()) {
            if (this.isLocalModeForced(command) || command.hasAnyFlag(FlagBitSets.SKIP_REMOTE_LOOKUP)) {
                this.entryFactory.wrapExternalEntry(ctx, command.getKey(), NullCacheEntry.getInstance(), false, false);
                return this.invokeNext(ctx, command);
            }
            ClusteredGetCommand clusteredGetCommand = this.cf.buildClusteredGetCommand(command.getKey(), info.segmentId(), command.getFlagsBitSet());
            clusteredGetCommand.setTopologyId(command.getTopologyId());
            PassthroughSingleResponseCollector collector = PassthroughSingleResponseCollector.INSTANCE;
            CompletionStage<Response> rpcFuture = this.rpcManager.invokeCommand(info.primary(), (ReplicableCommand)clusteredGetCommand, collector, this.rpcManager.getSyncRpcOptions());
            Object key = clusteredGetCommand.getKey();
            return this.asyncInvokeNext(ctx, (VisitableCommand)command, rpcFuture.thenAccept(response -> {
                if (response.isSuccessful()) {
                    InternalCacheValue value = (InternalCacheValue)((SuccessfulResponse)response).getResponseValue();
                    if (value != null) {
                        InternalCacheEntry cacheEntry = value.toInternalCacheEntry(key);
                        this.entryFactory.wrapExternalEntry(ctx, key, cacheEntry, true, false);
                    } else {
                        this.entryFactory.wrapExternalEntry(ctx, key, NullCacheEntry.getInstance(), false, false);
                    }
                } else {
                    if (response instanceof UnsureResponse) {
                        throw OutdatedTopologyException.RETRY_NEXT_TOPOLOGY;
                    }
                    if (response instanceof CacheNotFoundResponse) {
                        throw AllOwnersLostException.INSTANCE;
                    }
                    if (response instanceof ExceptionResponse) {
                        throw ResponseCollectors.wrapRemoteException(info.primary(), ((ExceptionResponse)response).getException());
                    }
                    throw new IllegalArgumentException("Unexpected response " + response);
                }
            }));
        }
        return UnsureResponse.INSTANCE;
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitIracPutKeyValueCommand(InvocationContext ctx, IracPutKeyValueCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        if (command.isForwarded() || command.hasAnyFlag(FlagBitSets.PUT_FOR_STATE_TRANSFER)) {
            assert (command.getMetadata() == null || command.getMetadata().version() == null);
            HashMap<Object, Object> valueMap = new HashMap<Object, Object>(command.getMap().size());
            for (Map.Entry<Object, Object> entry : command.getMap().entrySet()) {
                Object key = entry.getKey();
                CacheEntry cacheEntry = ctx.lookupEntry(key);
                if (cacheEntry == null) {
                    this.entryFactory.wrapExternalEntry(ctx, key, null, false, true);
                    cacheEntry = ctx.lookupEntry(key);
                }
                InternalCacheValue value = (InternalCacheValue)entry.getValue();
                Metadata entryMetadata = command.getMetadata() == null ? value.getMetadata() : command.getMetadata().builder().version(value.getMetadata().version()).build();
                cacheEntry.setMetadata(entryMetadata);
                cacheEntry.setCreated(value.getCreated());
                cacheEntry.setLastUsed(value.getLastUsed());
                valueMap.put(key, value.getValue());
            }
            command.setMap(valueMap);
            return this.invokeNextThenApply(ctx, command, this.putMapCommandHandler);
        }
        return this.handleWriteManyCommand(ctx, command, this.putMapHelper);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.handleReadCommand(ctx, command);
    }

    @Override
    public Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        return this.handleReadCommand(ctx, command);
    }

    @Override
    public Object visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        LocalizedCacheTopology cacheTopology = this.checkTopology(command);
        if (command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL | FlagBitSets.SKIP_REMOTE_LOOKUP | FlagBitSets.SKIP_OWNERSHIP_CHECK)) {
            return this.invokeNext(ctx, command);
        }
        if (ctx.isOriginLocal()) {
            HashMap<Address, List> remoteKeys = new HashMap<Address, List>();
            for (Object key : command.getKeys()) {
                if (ctx.lookupEntry(key) != null) continue;
                DistributionInfo info = cacheTopology.getDistribution(key);
                if (info.primary() == null) {
                    throw OutdatedTopologyException.RETRY_NEXT_TOPOLOGY;
                }
                if (info.isPrimary()) continue;
                remoteKeys.computeIfAbsent(info.primary(), k -> new ArrayList()).add(key);
            }
            if (remoteKeys.isEmpty()) {
                return this.invokeNext(ctx, command);
            }
            ClusteringInterceptor.ClusteredGetAllFuture sync = new ClusteringInterceptor.ClusteredGetAllFuture(this, remoteKeys.size());
            for (Map.Entry remote : remoteKeys.entrySet()) {
                List keys = (List)remote.getValue();
                ClusteredGetAllCommand clusteredGetAllCommand = this.cf.buildClusteredGetAllCommand(keys, command.getFlagsBitSet(), null);
                clusteredGetAllCommand.setTopologyId(command.getTopologyId());
                SingletonMapResponseCollector collector = SingletonMapResponseCollector.ignoreLeavers();
                CompletionStage<Map<Address, Response>> rpcFuture = this.rpcManager.invokeCommand((Address)remote.getKey(), (ReplicableCommand)clusteredGetAllCommand, collector, this.rpcManager.getSyncRpcOptions());
                rpcFuture.whenComplete((responseMap, throwable) -> this.handleGetAllResponse((Map<Address, Response>)responseMap, (Throwable)throwable, ctx, keys, sync));
            }
            return this.asyncInvokeNext(ctx, (VisitableCommand)command, sync);
        }
        for (Object key : command.getKeys()) {
            if (ctx.lookupEntry(key) != null) continue;
            return UnsureResponse.INSTANCE;
        }
        return this.invokeNext(ctx, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGetAllResponse(Map<Address, Response> responseMap, Throwable throwable, InvocationContext ctx, List<?> keys, ClusteringInterceptor.ClusteredGetAllFuture allFuture) {
        if (throwable != null) {
            allFuture.completeExceptionally(throwable);
            return;
        }
        SuccessfulResponse response = ScatteredDistributionInterceptor.getSuccessfulResponseOrFail(responseMap, allFuture, rsp -> allFuture.completeExceptionally(rsp instanceof UnsureResponse ? OutdatedTopologyException.RETRY_NEXT_TOPOLOGY : AllOwnersLostException.INSTANCE));
        if (response == null) {
            return;
        }
        Object responseValue = response.getResponseValue();
        if (!(responseValue instanceof InternalCacheValue[])) {
            allFuture.completeExceptionally(new IllegalStateException("Unexpected response value: " + responseValue));
            return;
        }
        Object[] values = (InternalCacheValue[])responseValue;
        if (keys.size() != values.length) {
            allFuture.completeExceptionally(new CacheException("Request and response lengths differ: keys=" + keys + ", response=" + Arrays.toString(values)));
            return;
        }
        ClusteringInterceptor.ClusteredGetAllFuture clusteredGetAllFuture = allFuture;
        synchronized (clusteredGetAllFuture) {
            if (allFuture.isDone()) {
                return;
            }
            for (int i = 0; i < values.length; ++i) {
                Object key = keys.get(i);
                Object value = values[i];
                NullCacheEntry entry = value == null ? NullCacheEntry.getInstance() : value.toInternalCacheEntry(key);
                this.entryFactory.wrapExternalEntry(ctx, key, entry, true, false);
            }
            if (--allFuture.counter == 0) {
                allFuture.complete(null);
            }
        }
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        this.svm.clearInvalidations();
        if (ctx.isOriginLocal() && !this.isLocalModeForced(command)) {
            if (this.isSynchronous(command)) {
                RpcOptions rpcOptions = this.rpcManager.getSyncRpcOptions();
                MapResponseCollector collector = MapResponseCollector.ignoreLeavers();
                return ScatteredDistributionInterceptor.makeStage(this.asyncInvokeNext(ctx, (VisitableCommand)command, this.rpcManager.invokeCommandOnAll(command, collector, rpcOptions))).thenApply(ctx, command, this.clearHandler);
            }
            this.rpcManager.sendToAll(command, DeliverOrder.PER_SENDER);
            return this.invokeNextThenApply(ctx, command, this.clearHandler);
        }
        return this.invokeNextThenApply(ctx, command, this.clearHandler);
    }

    protected Object handleClear(InvocationContext ctx, ClearCommand command, Object ignored) {
        if (this.cacheNotifier.hasListener(CacheEntryRemoved.class)) {
            Iterator iterator = this.dataContainer.iteratorIncludingExpired();
            AggregateCompletionStage<Void> aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
            while (iterator.hasNext()) {
                InternalCacheEntry entry = iterator.next();
                this.dataContainer.remove(entry.getKey());
                aggregateCompletionStage.dependsOn(this.cacheNotifier.notifyCacheEntryRemoved(entry.getKey(), entry.getValue(), entry.getMetadata(), false, ctx, command));
            }
            return aggregateCompletionStage.freeze();
        }
        this.dataContainer.clear();
        return CompletableFutures.completedNull();
    }

    @Override
    public Object visitReadOnlyKeyCommand(InvocationContext ctx, ReadOnlyKeyCommand command) throws Throwable {
        Object key = command.getKey();
        CacheEntry entry = ctx.lookupEntry(key);
        if (entry != null) {
            return this.invokeNext(ctx, command);
        }
        if (!ctx.isOriginLocal()) {
            return UnsureResponse.INSTANCE;
        }
        if (this.isLocalModeForced(command) || command.hasAnyFlag(FlagBitSets.SKIP_REMOTE_LOOKUP)) {
            if (ctx.lookupEntry(command.getKey()) == null) {
                this.entryFactory.wrapExternalEntry(ctx, command.getKey(), NullCacheEntry.getInstance(), false, false);
            }
            return this.invokeNext(ctx, command);
        }
        DistributionInfo info = this.checkTopology(command).getDistribution(command.getKey());
        if (info.primary() == null) {
            throw AllOwnersLostException.INSTANCE;
        }
        PassthroughSingleResponseCollector collector = PassthroughSingleResponseCollector.INSTANCE;
        CompletionStage<Response> rpc = this.rpcManager.invokeCommand(info.primary(), (ReplicableCommand)command, collector, this.rpcManager.getSyncRpcOptions());
        return ScatteredDistributionInterceptor.asyncValue(rpc.thenApply(response -> {
            if (response.isSuccessful()) {
                return ((SuccessfulResponse)response).getResponseValue();
            }
            if (response instanceof UnsureResponse) {
                throw OutdatedTopologyException.RETRY_NEXT_TOPOLOGY;
            }
            if (response instanceof CacheNotFoundResponse) {
                throw AllOwnersLostException.INSTANCE;
            }
            if (response instanceof ExceptionResponse) {
                throw ResponseCollectors.wrapRemoteException(info.primary(), ((ExceptionResponse)response).getException());
            }
            throw new IllegalArgumentException("Unexpected response " + response);
        }));
    }

    @Override
    public Object visitReadOnlyManyCommand(InvocationContext ctx, ReadOnlyManyCommand command) throws Throwable {
        if (command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL | FlagBitSets.SKIP_REMOTE_LOOKUP)) {
            return this.handleLocalOnlyReadManyCommand(ctx, command, command.getKeys());
        }
        LocalizedCacheTopology cacheTopology = this.checkTopology(command);
        if (!ctx.isOriginLocal()) {
            return this.handleRemoteReadManyCommand(ctx, command, command.getKeys());
        }
        if (command.getKeys().isEmpty()) {
            return Stream.empty();
        }
        ConsistentHash ch = cacheTopology.getReadConsistentHash();
        int estimateForOneNode = 2 * command.getKeys().size() / ch.getMembers().size();
        Function<Address, List> createList = k -> new ArrayList(estimateForOneNode);
        HashMap<Address, List> requestedKeys = new HashMap<Address, List>();
        ArrayList localKeys = null;
        for (Object key : command.getKeys()) {
            if (ctx.lookupEntry(key) != null) {
                if (localKeys == null) {
                    localKeys = new ArrayList();
                }
                localKeys.add(key);
                continue;
            }
            DistributionInfo info = cacheTopology.getDistribution(key);
            assert (!info.isPrimary());
            if (info.primary() == null) {
                throw AllOwnersLostException.INSTANCE;
            }
            requestedKeys.computeIfAbsent(info.primary(), createList).add(key);
        }
        MergingCompletableFuture<Object> allFuture = new MergingCompletableFuture<Object>(requestedKeys.size() + (localKeys == null ? 0 : 1), new Object[command.getKeys().size()], Arrays::stream);
        int offset = 0;
        if (localKeys != null) {
            offset += localKeys.size();
            ReadOnlyManyCommand localCommand = new ReadOnlyManyCommand(command).withKeys(localKeys);
            this.invokeNextAndFinally(ctx, localCommand, (rCtx, rCommand, rv, throwable) -> {
                if (throwable != null) {
                    allFuture.completeExceptionally(throwable);
                } else {
                    try {
                        ((Stream)rv).collect(new ArrayCollector((Object[])allFuture.results));
                        allFuture.countDown();
                    }
                    catch (Throwable t) {
                        allFuture.completeExceptionally(t);
                    }
                }
            });
        }
        for (Map.Entry addressKeys : requestedKeys.entrySet()) {
            List keysForAddress = (List)addressKeys.getValue();
            ReadOnlyManyCommand remoteCommand = new ReadOnlyManyCommand(command).withKeys(keysForAddress);
            remoteCommand.setTopologyId(command.getTopologyId());
            Set<Address> target = Collections.singleton((Address)addressKeys.getKey());
            int myOffset = offset;
            SingletonMapResponseCollector collector = SingletonMapResponseCollector.ignoreLeavers();
            CompletionStage<Map<Address, Response>> rpc = this.rpcManager.invokeCommand(target, remoteCommand, collector, this.rpcManager.getSyncRpcOptions());
            rpc.whenComplete((responseMap, throwable) -> {
                if (throwable != null) {
                    allFuture.completeExceptionally((Throwable)throwable);
                    return;
                }
                SuccessfulResponse response = ScatteredDistributionInterceptor.getSuccessfulResponseOrFail(responseMap, allFuture, rsp -> allFuture.completeExceptionally(rsp instanceof UnsureResponse ? OutdatedTopologyException.RETRY_NEXT_TOPOLOGY : AllOwnersLostException.INSTANCE));
                if (response == null) {
                    return;
                }
                try {
                    Object[] values = (Object[])response.getResponseValue();
                    if (values != null) {
                        System.arraycopy(values, 0, allFuture.results, myOffset, values.length);
                        allFuture.countDown();
                    } else {
                        allFuture.completeExceptionally(new IllegalStateException("Unexpected response value " + response.getResponseValue()));
                    }
                }
                catch (Throwable t) {
                    allFuture.completeExceptionally(t);
                }
            });
            offset += keysForAddress.size();
        }
        return ScatteredDistributionInterceptor.asyncValue(allFuture);
    }

    private Object handleLocalOnlyReadManyCommand(InvocationContext ctx, VisitableCommand command, Collection<?> keys) {
        for (Object key : keys) {
            if (ctx.lookupEntry(key) != null) continue;
            this.entryFactory.wrapExternalEntry(ctx, key, NullCacheEntry.getInstance(), true, false);
        }
        return this.invokeNext(ctx, command);
    }

    private <C extends VisitableCommand & TopologyAffectedCommand> Object handleRemoteReadManyCommand(InvocationContext ctx, C command, Collection<?> keys) {
        for (Object key : keys) {
            if (ctx.lookupEntry(key) != null) continue;
            return UnsureResponse.INSTANCE;
        }
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> ((Stream)rv).toArray());
    }

    @Override
    public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    private <C extends WriteCommand, Container, Item> Object handleWriteManyCommand(InvocationContext ctx, C command, WriteManyCommandHelper<C, Container, Item> helper) {
        if (ctx.isOriginLocal()) {
            return this.handleWriteManyOnOrigin(ctx, command, helper);
        }
        this.checkTopology((FlagAffectedCommand & TopologyAffectedCommand)command);
        assert (helper.shouldRegisterRemoteCallback(command));
        return this.invokeNextThenApply(ctx, command, this.handleWriteManyOnPrimary);
    }

    private <C extends WriteCommand, Container, Item> Object handleWriteManyOnOrigin(InvocationContext ctx, C command, WriteManyCommandHelper<C, Container, Item> helper) {
        LocalizedCacheTopology cacheTopology = this.checkTopology((FlagAffectedCommand & TopologyAffectedCommand)command);
        HashMap<Address, Object> remoteEntries = new HashMap<Address, Object>();
        for (Item item : helper.getItems(command)) {
            Object key = helper.item2key(item);
            DistributionInfo info = cacheTopology.getDistribution(key);
            Address primary = info.primary();
            if (primary == null) {
                throw AllOwnersLostException.INSTANCE;
            }
            Object currentEntries = remoteEntries.computeIfAbsent(primary, k -> helper.newContainer());
            helper.accumulate(currentEntries, item);
        }
        Object[] results = command.loadType() == VisitableCommand.LoadType.DONT_LOAD ? null : new Object[command.getAffectedKeys().size()];
        SyncMergingCompletableFuture<Object> allFuture = new SyncMergingCompletableFuture<Object>(remoteEntries.size(), results, helper::transformResult);
        int offset = 0;
        Object localEntries = remoteEntries.remove(this.rpcManager.getAddress());
        if (localEntries != null) {
            helper.containerSize(localEntries);
            C localCommand = helper.copyForLocal(command, localEntries);
            localCommand.setTopologyId(command.getTopologyId());
            LocalWriteManyHandler handler = new LocalWriteManyHandler(allFuture, localCommand.getAffectedKeys(), cacheTopology);
            this.invokeNextAndFinally(ctx, localCommand, handler);
        }
        CommandAckCollector.MultiTargetCollector multiTargetCollector = this.createMultiTargetCollector(command, remoteEntries.size());
        for (Map.Entry ownerEntry : remoteEntries.entrySet()) {
            Address owner = (Address)ownerEntry.getKey();
            Object container = ownerEntry.getValue();
            C toPrimary = helper.copyForLocal(command, container);
            toPrimary.setTopologyId(command.getTopologyId());
            CompletionStage<ValidResponse> rpcFuture = this.manyWriteOnRemotePrimary(owner, (WriteCommand)toPrimary, multiTargetCollector);
            int myOffset = offset;
            offset += helper.containerSize(container);
            rpcFuture.whenComplete((response, t) -> {
                if (t != null) {
                    allFuture.completeExceptionally((Throwable)t);
                    return;
                }
                Object responseValue = response.getResponseValue();
                try {
                    InternalCacheValue[] values;
                    if (command.loadType() == VisitableCommand.LoadType.DONT_LOAD) {
                        if (!(responseValue instanceof InternalCacheValue[])) {
                            allFuture.completeExceptionally(new CacheException("Response from " + owner + ": expected InternalCacheValue[] but it is " + responseValue));
                            return;
                        }
                        values = (InternalCacheValue[])responseValue;
                    } else {
                        if (!(responseValue instanceof Object[]) || ((Object[])responseValue).length != 2) {
                            allFuture.completeExceptionally(new CacheException("Response from " + owner + ": expected Object[2] but it is " + responseValue));
                            return;
                        }
                        values = (InternalCacheValue[])((Object[])responseValue)[0];
                        MergingCompletableFuture.moveListItemsToFuture(((Object[])responseValue)[1], allFuture, myOffset);
                    }
                    AggregateCompletionStage<Void> aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
                    MergingCompletableFuture mergingCompletableFuture = allFuture;
                    synchronized (mergingCompletableFuture) {
                        if (allFuture.isDone()) {
                            return;
                        }
                        int i = 0;
                        for (Object key : helper.toKeys(container)) {
                            InternalCacheEntry ice = values[i++].toInternalCacheEntry(key);
                            this.entryFactory.wrapExternalEntry(ctx, key, ice, true, true);
                            RepeatableReadEntry entry = (RepeatableReadEntry)ctx.lookupEntry(key);
                            entry.setChanged(true);
                            aggregateCompletionStage.dependsOn(this.commitSingleEntryIfNewer(entry, ctx, command));
                            if (!entry.isCommitted() || command.hasAnyFlag(FlagBitSets.PUT_FOR_STATE_TRANSFER)) continue;
                            this.scheduleKeyInvalidation(entry.getKey(), entry.getMetadata().version(), entry.isRemoved());
                        }
                        assert (i == values.length);
                    }
                    aggregateCompletionStage.freeze().thenRun(allFuture::countDown);
                }
                catch (Throwable t2) {
                    allFuture.completeExceptionally(t2);
                }
            });
        }
        return ScatteredDistributionInterceptor.asyncValue(allFuture);
    }

    protected <C extends WriteCommand> CommandAckCollector.MultiTargetCollector createMultiTargetCollector(C command, int primaries) {
        return null;
    }

    private Object handleWriteManyOnPrimary(InvocationContext ctx, WriteCommand cmd, Object rv) {
        Object[] returnValue;
        int numKeys = cmd.getAffectedKeys().size();
        InternalCacheValue[] values = new InternalCacheValue[numKeys];
        int i = 0;
        AggregateCompletionStage<Void> aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
        for (Object key : cmd.getAffectedKeys()) {
            RepeatableReadEntry entry = (RepeatableReadEntry)ctx.lookupEntry(key);
            EntryVersion nextVersion = this.svm.incrementVersion(this.keyPartitioner.getSegment(key));
            entry.setMetadata(ScatteredDistributionInterceptor.addVersion(entry.getMetadata(), nextVersion));
            if (cmd.loadType() == VisitableCommand.LoadType.DONT_LOAD) {
                aggregateCompletionStage.dependsOn(this.commitSingleEntryIfNewer(entry, ctx, cmd));
            } else {
                aggregateCompletionStage.dependsOn(this.commitSingleEntryIfNoChange(entry, ctx, cmd));
            }
            values[i++] = new MetadataImmortalCacheValue(entry.getValue(), entry.getMetadata());
        }
        CompletionStage<Void> aggregatedStage = aggregateCompletionStage.freeze();
        if (cmd.loadType() == VisitableCommand.LoadType.DONT_LOAD) {
            cmd.setFlagsBitSet(cmd.getFlagsBitSet() & (FlagBitSets.IGNORE_RETURN_VALUES ^ 0xFFFFFFFFFFFFFFFFL));
            returnValue = values;
        } else {
            returnValue = new Object[]{values, ((List)rv).toArray()};
        }
        return ScatteredDistributionInterceptor.asyncValue(aggregatedStage).thenApply(ctx, cmd, (rCtx, rCommand, rv1) -> this.manyWriteResponse(rCtx, cmd, returnValue));
    }

    @Override
    public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) throws Throwable {
        return this.handleWriteManyCommand(ctx, command, this.writeOnlyManyEntriesHelper);
    }

    @Override
    public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyManyCommand(InvocationContext ctx, WriteOnlyManyCommand command) throws Throwable {
        return this.handleWriteManyCommand(ctx, command, this.writeOnlyManyHelper);
    }

    @Override
    public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) throws Throwable {
        return this.handleWriteManyCommand(ctx, command, this.readWriteManyHelper);
    }

    @Override
    public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) throws Throwable {
        return this.handleWriteManyCommand(ctx, command, this.readWriteManyEntriesHelper);
    }

    @Override
    protected Log getLog() {
        return log;
    }

    protected Object singleWriteResponse(InvocationContext ctx, DataWriteCommand cmd, Object returnValue) {
        return returnValue;
    }

    protected Object manyWriteResponse(InvocationContext ctx, WriteCommand cmd, Object returnValue) {
        return returnValue;
    }

    protected void completeManyWriteOnPrimaryOriginator(WriteCommand command, Address backup, CountDownCompletableFuture future) {
    }

    protected class PrimaryResponseHandler
    extends AbstractVisitor
    implements InvocationSuccessFunction {
        private final Object responseValue;
        private Object returnValue;
        private EntryVersion version;

        public PrimaryResponseHandler(Object responseValue) {
            this.responseValue = responseValue;
        }

        private Object handleDataWriteCommand(InvocationContext ctx, DataWriteCommand command) {
            if (command.isReturnValueExpected()) {
                if (!(this.responseValue instanceof Object[])) {
                    throw new CacheException("Expected Object[] { return-value, version } as response but it is " + this.responseValue);
                }
                Object[] array = (Object[])this.responseValue;
                if (array.length != 2) {
                    throw new CacheException("Expected Object[] { return-value, version } but it is " + Arrays.toString(array));
                }
                this.version = (EntryVersion)array[1];
                this.returnValue = array[0];
            } else {
                if (!(this.responseValue instanceof EntryVersion)) {
                    throw new CacheException("Expected EntryVersion as response but it is " + this.responseValue);
                }
                this.version = (EntryVersion)this.responseValue;
                this.returnValue = null;
            }
            ScatteredDistributionInterceptor.this.entryFactory.wrapExternalEntry(ctx, command.getKey(), NullCacheEntry.getInstance(), false, true);
            command.setValueMatcher(ValueMatcher.MATCH_ALWAYS);
            return ScatteredDistributionInterceptor.this.invokeNextThenApply(ctx, command, this);
        }

        private Object handleValueResponseCommand(InvocationContext ctx, DataWriteCommand command) throws Throwable {
            if (!(this.responseValue instanceof MetadataImmortalCacheValue)) {
                throw new CacheException("Expected MetadataImmortalCacheValue as response but it is " + this.responseValue);
            }
            MetadataImmortalCacheValue micv = (MetadataImmortalCacheValue)this.responseValue;
            InternalCacheEntry<?, ?> ice = micv.toInternalCacheEntry(command.getKey());
            this.returnValue = ice.getValue();
            this.version = ice.getMetadata().version();
            ScatteredDistributionInterceptor.this.entryFactory.wrapExternalEntry(ctx, command.getKey(), ice, true, true);
            return this.apply(ctx, command, (Object)null);
        }

        private Object handleFunctionalCommand(InvocationContext ctx, DataWriteCommand command) throws Throwable {
            if (!(this.responseValue instanceof Object[])) {
                throw new CacheException("Expected Object[] { value, metadata, return-value } but it is " + this.responseValue);
            }
            Object[] array = (Object[])this.responseValue;
            if (array.length != 3) {
                throw new CacheException("Expected Object[] { value, metadata, return-value } but it is " + Arrays.toString(array));
            }
            Metadata metadata = (Metadata)array[1];
            this.returnValue = array[2];
            this.version = metadata.version();
            ScatteredDistributionInterceptor.this.entryFactory.wrapExternalEntry(ctx, command.getKey(), new MetadataImmortalCacheEntry(command.getKey(), array[0], metadata), true, true);
            return this.apply(ctx, command, (Object)null);
        }

        public Object apply(InvocationContext rCtx, VisitableCommand rCommand, Object rv) throws Throwable {
            DataWriteCommand cmd = (DataWriteCommand)rCommand;
            RepeatableReadEntry cacheEntry = (RepeatableReadEntry)rCtx.lookupEntry(cmd.getKey());
            Metadata metadata = ScatteredDistributionInterceptor.addVersion(cacheEntry.getMetadata(), this.version);
            cacheEntry.setMetadata(metadata);
            cacheEntry.setChanged(true);
            CompletionStage<Void> stage = ScatteredDistributionInterceptor.this.commitSingleEntryIfNewer(cacheEntry, rCtx, cmd);
            if (cacheEntry.isCommitted() && !cmd.hasAnyFlag(FlagBitSets.PUT_FOR_STATE_TRANSFER)) {
                ScatteredDistributionInterceptor.this.scheduleKeyInvalidation(cmd.getKey(), cacheEntry.getMetadata().version(), cacheEntry.isRemoved());
            }
            return BaseAsyncInterceptor.delayedValue(stage, this.returnValue);
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            return this.handleDataWriteCommand(ctx, command);
        }

        @Override
        public Object visitIracPutKeyValueCommand(InvocationContext ctx, IracPutKeyValueCommand command) {
            return this.handleDataWriteCommand(ctx, command);
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            return this.handleDataWriteCommand(ctx, command);
        }

        @Override
        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
            return this.handleDataWriteCommand(ctx, command);
        }

        @Override
        public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) throws Throwable {
            return this.handleValueResponseCommand(ctx, command);
        }

        @Override
        public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) throws Throwable {
            return this.handleValueResponseCommand(ctx, command);
        }

        @Override
        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) throws Throwable {
            return this.handleFunctionalCommand(ctx, command);
        }

        @Override
        public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
            return this.handleFunctionalCommand(ctx, command);
        }

        @Override
        public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) throws Throwable {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) throws Throwable {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) throws Throwable {
            return this.handleFunctionalCommand(ctx, command);
        }

        @Override
        public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) throws Throwable {
            return this.handleFunctionalCommand(ctx, command);
        }
    }

    private static class SyncMergingCompletableFuture<T>
    extends MergingCompletableFuture<T> {
        SyncMergingCompletableFuture(int participants, T[] results, Function<T[], Object> transform) {
            super(participants, results, transform);
        }

        @Override
        public synchronized boolean completeExceptionally(Throwable ex) {
            return super.completeExceptionally(ex);
        }
    }

    private class LocalWriteManyHandler
    implements InvocationFinallyAction<VisitableCommand> {
        private final MergingCompletableFuture allFuture;
        private final Collection<?> keys;
        private final LocalizedCacheTopology cacheTopology;

        private LocalWriteManyHandler(MergingCompletableFuture allFuture, Collection<?> keys, LocalizedCacheTopology cacheTopology) {
            this.allFuture = allFuture;
            this.keys = keys;
            this.cacheTopology = cacheTopology;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(InvocationContext ctx, VisitableCommand command, Object rv, Throwable throwable) throws Throwable {
            if (throwable != null) {
                this.allFuture.completeExceptionally(throwable);
            } else {
                try {
                    CompletionStage<Map<Object, Object>> rpcFuture;
                    CompletionStage<Void> aggregatedStage;
                    if (this.allFuture.results != null) {
                        MergingCompletableFuture.moveListItemsToFuture(rv, this.allFuture, 0);
                    }
                    WriteCommand writeCommand = (WriteCommand)command;
                    HashMap backupMap = new HashMap();
                    MergingCompletableFuture mergingCompletableFuture = this.allFuture;
                    synchronized (mergingCompletableFuture) {
                        if (this.allFuture.isDone()) {
                            return;
                        }
                        AggregateCompletionStage<Void> aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
                        for (Object key : this.keys) {
                            DistributionInfo info = this.cacheTopology.getDistribution(key);
                            EntryVersion version = ScatteredDistributionInterceptor.this.svm.incrementVersion(info.segmentId());
                            RepeatableReadEntry entry = (RepeatableReadEntry)ctx.lookupEntry(key);
                            if (entry == null) {
                                throw new CacheException("Entry not looked up for " + key);
                            }
                            Metadata metadata = ScatteredDistributionInterceptor.addVersion(entry.getMetadata(), version);
                            entry.setMetadata(metadata);
                            backupMap.put(key, new MetadataImmortalCacheValue(entry.getValue(), metadata));
                            if (writeCommand.loadType() == VisitableCommand.LoadType.DONT_LOAD) {
                                aggregateCompletionStage.dependsOn(ScatteredDistributionInterceptor.this.commitSingleEntryIfNewer(entry, ctx, command));
                                continue;
                            }
                            aggregateCompletionStage.dependsOn(ScatteredDistributionInterceptor.this.commitSingleEntryIfNoChange(entry, ctx, command));
                        }
                        aggregatedStage = aggregateCompletionStage.freeze();
                    }
                    Address backup = ScatteredDistributionInterceptor.this.getNextMember(this.cacheTopology);
                    ScatteredDistributionInterceptor.this.completeManyWriteOnPrimaryOriginator(writeCommand, backup, this.allFuture);
                    PutMapCommand backupCommand = ScatteredDistributionInterceptor.this.cf.buildPutMapCommand(backupMap, null, writeCommand.getFlagsBitSet());
                    if (backup != null) {
                        backupCommand.setForwarded(true);
                        backupCommand.setTopologyId(writeCommand.getTopologyId());
                        SingletonMapResponseCollector collector = SingletonMapResponseCollector.ignoreLeavers();
                        rpcFuture = ScatteredDistributionInterceptor.this.rpcManager.invokeCommand(backup, (ReplicableCommand)backupCommand, collector, ScatteredDistributionInterceptor.this.rpcManager.getSyncRpcOptions());
                    } else {
                        rpcFuture = CompletableFuture.completedFuture(Collections.emptyMap());
                    }
                    CompletionStage combinedResponse = CompletionStages.isCompletedSuccessfully(aggregatedStage) ? rpcFuture : aggregatedStage.thenCombine(rpcFuture, (v, map) -> map);
                    combinedResponse.whenComplete((ignore, throwable1) -> {
                        if (throwable1 != null) {
                            this.allFuture.completeExceptionally((Throwable)throwable1);
                        } else {
                            this.allFuture.countDown();
                            for (Map.Entry<Object, Object> entry : backupCommand.getMap().entrySet()) {
                                EntryVersion version = ((InternalCacheValue)entry.getValue()).getMetadata().version();
                                ScatteredDistributionInterceptor.this.scheduleKeyInvalidation(entry.getKey(), version, false);
                            }
                        }
                    });
                }
                catch (Throwable t) {
                    this.allFuture.completeExceptionally(t);
                }
            }
        }
    }

    protected static class PrimaryResponseGenerator
    extends AbstractVisitor {
        private final CacheEntry cacheEntry;
        private final Object returnValue;

        public PrimaryResponseGenerator(CacheEntry cacheEntry, Object rv) {
            this.cacheEntry = cacheEntry;
            this.returnValue = rv;
        }

        private Object handleDataWriteCommand(InvocationContext ctx, DataWriteCommand cmd) {
            if (cmd.isReturnValueExpected()) {
                return new Object[]{this.returnValue, this.cacheEntry.getMetadata().version()};
            }
            cmd.setFlagsBitSet(cmd.getFlagsBitSet() & ((FlagBitSets.IGNORE_RETURN_VALUES | FlagBitSets.SKIP_REMOTE_LOOKUP) ^ 0xFFFFFFFFFFFFFFFFL));
            return this.cacheEntry.getMetadata().version();
        }

        private Object handleValueResponseCommand(InvocationContext ctx, DataWriteCommand cmd) {
            return new MetadataImmortalCacheValue(this.cacheEntry.getValue(), this.cacheEntry.getMetadata());
        }

        private Object handleFunctionalCommand(InvocationContext ctx, DataWriteCommand cmd) {
            return new Object[]{this.cacheEntry.getValue(), this.cacheEntry.getMetadata(), this.returnValue};
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            return this.handleDataWriteCommand(ctx, command);
        }

        @Override
        public Object visitIracPutKeyValueCommand(InvocationContext ctx, IracPutKeyValueCommand command) {
            return this.handleDataWriteCommand(ctx, command);
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            return this.handleDataWriteCommand(ctx, command);
        }

        @Override
        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
            return this.handleDataWriteCommand(ctx, command);
        }

        @Override
        public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) throws Throwable {
            return this.handleValueResponseCommand(ctx, command);
        }

        @Override
        public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) throws Throwable {
            return this.handleValueResponseCommand(ctx, command);
        }

        @Override
        public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) throws Throwable {
            return this.handleFunctionalCommand(ctx, command);
        }

        @Override
        public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) throws Throwable {
            return this.handleFunctionalCommand(ctx, command);
        }

        @Override
        public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
            return this.handleFunctionalCommand(ctx, command);
        }

        @Override
        public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) throws Throwable {
            return this.handleFunctionalCommand(ctx, command);
        }

        @Override
        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) throws Throwable {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) throws Throwable {
            throw new UnsupportedOperationException();
        }
    }
}

