/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.embeddable.internal;

import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.internal.BasicAttributeMapping;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.results.graph.AbstractFetchParent;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.embeddable.EmbeddableInitializer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResult;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResultGraphNode;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableAssembler;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableResultInitializer;
import org.hibernate.sql.results.graph.internal.ImmutableFetchList;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class EmbeddableExpressionResultImpl<T>
extends AbstractFetchParent
implements EmbeddableResultGraphNode,
DomainResult<T>,
EmbeddableResult<T> {
    private final String resultVariable;
    private final boolean containsAnyNonScalars;

    public EmbeddableExpressionResultImpl(NavigablePath navigablePath, EmbeddableValuedModelPart modelPart, SqlTuple sqlExpression, String resultVariable, DomainResultCreationState creationState) {
        super(modelPart.getEmbeddableTypeDescriptor(), navigablePath);
        this.resultVariable = resultVariable;
        ImmutableFetchList.Builder fetches = new ImmutableFetchList.Builder(modelPart);
        EmbeddableMappingType mappingType = modelPart.getEmbeddableTypeDescriptor();
        int numberOfAttributeMappings = mappingType.getNumberOfAttributeMappings();
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        TypeConfiguration typeConfiguration = sqlAstCreationState.getCreationContext().getSessionFactory().getTypeConfiguration();
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        for (int i = 0; i < numberOfAttributeMappings; ++i) {
            BasicAttributeMapping attribute = (BasicAttributeMapping)mappingType.getAttributeMapping(i);
            SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(sqlExpression.getExpressions().get(i), attribute.getJavaType(), this, typeConfiguration);
            fetches.add(new BasicFetch(sqlSelection.getValuesArrayPosition(), this, this.resolveNavigablePath(attribute), attribute, FetchTiming.IMMEDIATE, creationState));
        }
        this.resetFetches(fetches.build());
        this.containsAnyNonScalars = EmbeddableExpressionResultImpl.determineIfContainedAnyScalars(this.getFetches());
    }

    private static boolean determineIfContainedAnyScalars(ImmutableFetchList fetches) {
        for (Fetch fetch : fetches) {
            if (!fetch.containsAnyNonScalarResults()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getResultVariable() {
        return this.resultVariable;
    }

    @Override
    public boolean containsAnyNonScalarResults() {
        return this.containsAnyNonScalars;
    }

    @Override
    public EmbeddableMappingType getFetchContainer() {
        return (EmbeddableMappingType)super.getFetchContainer();
    }

    @Override
    public JavaType<?> getResultJavaType() {
        return this.getReferencedMappingType().getJavaType();
    }

    @Override
    public EmbeddableMappingType getReferencedMappingType() {
        return this.getFetchContainer();
    }

    @Override
    public EmbeddableValuedModelPart getReferencedMappingContainer() {
        return this.getFetchContainer().getEmbeddedValueMapping();
    }

    @Override
    public DomainResultAssembler<T> createResultAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        EmbeddableInitializer initializer = creationState.resolveInitializer(this.getNavigablePath(), this.getReferencedModePart(), () -> new EmbeddableResultInitializer(this, parentAccess, creationState)).asEmbeddableInitializer();
        assert (initializer != null);
        return new EmbeddableAssembler(initializer);
    }
}

