/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.persistence.remote.configuration.AbstractRemoteStoreConfigurationChildBuilder;
import org.infinispan.persistence.remote.configuration.AuthenticationConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.SecurityConfiguration;
import org.infinispan.persistence.remote.configuration.SslConfigurationBuilder;

public class SecurityConfigurationBuilder
extends AbstractRemoteStoreConfigurationChildBuilder
implements Builder<SecurityConfiguration> {
    private final AuthenticationConfigurationBuilder authentication = new AuthenticationConfigurationBuilder(this);
    private final SslConfigurationBuilder ssl = new SslConfigurationBuilder(this);

    SecurityConfigurationBuilder(RemoteStoreConfigurationBuilder builder) {
        super(builder, null);
    }

    public AuthenticationConfigurationBuilder authentication() {
        return this.authentication;
    }

    public SslConfigurationBuilder ssl() {
        return this.ssl;
    }

    public SecurityConfiguration create() {
        return new SecurityConfiguration(this.authentication.create(), this.ssl.create());
    }

    public Builder<?> read(SecurityConfiguration template, Combine combine) {
        this.authentication.read(template.authentication(), combine);
        this.ssl.read(template.ssl(), combine);
        return this;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public void validate() {
        this.authentication.validate();
        this.ssl.validate();
    }

    public String toString() {
        return "SecurityConfigurationBuilder{authentication=" + this.authentication + ", ssl=" + this.ssl + "}";
    }
}

