/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.rest.root.colibri.drain;

import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.rest.RestApis;
import org.jitsi.videobridge.rest.annotations.EnabledByConfig;
import org.json.simple.JSONObject;

@Path(value="/colibri/drain")
@EnabledByConfig(value=RestApis.DRAIN)
public class Drain {
    @Inject
    protected Videobridge videobridge;

    private Response setDrainMode(boolean enable) {
        try {
            this.videobridge.setDrainMode(enable);
            return Response.ok().build();
        }
        catch (Throwable t) {
            return Response.status(500).build();
        }
    }

    @POST
    @Path(value="/enable")
    public Response drainEnable() {
        return this.setDrainMode(true);
    }

    @POST
    @Path(value="/disable")
    public Response drainDisable() {
        return this.setDrainMode(false);
    }

    @GET
    @Produces(value={"application/json"})
    public String getDrainState() {
        JSONObject obj = new JSONObject();
        obj.put("drain", this.videobridge.getDrainMode());
        return obj.toJSONString();
    }
}

