/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime.linux_x86;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.JVMDebugger;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.x86.X86ThreadContext;
import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.JavaThreadPDAccess;
import sun.jvm.hotspot.runtime.RegisterMap;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.x86.X86CurrentFrameGuess;
import sun.jvm.hotspot.runtime.x86.X86Frame;
import sun.jvm.hotspot.runtime.x86.X86RegisterMap;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class LinuxX86JavaThreadPDAccess
implements JavaThreadPDAccess {
    private static AddressField lastJavaFPField;
    private static AddressField osThreadField;
    private static CIntegerField osThreadThreadIDField;
    private static final long GUESS_SCAN_RANGE = 131072L;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("JavaThread");
        osThreadField = type.getAddressField("_osthread");
        Type anchorType = db.lookupType("JavaFrameAnchor");
        lastJavaFPField = anchorType.getAddressField("_last_Java_fp");
        Type osThreadType = db.lookupType("OSThread");
        osThreadThreadIDField = osThreadType.getCIntegerField("_thread_id");
    }

    @Override
    public Address getLastJavaFP(Address addr) {
        return lastJavaFPField.getValue(addr.addOffsetTo(JavaThread.getAnchorField().getOffset()));
    }

    @Override
    public Address getLastJavaPC(Address addr) {
        return null;
    }

    @Override
    public Address getBaseOfStackPointer(Address addr) {
        return null;
    }

    @Override
    public Frame getLastFramePD(JavaThread thread, Address addr) {
        Address fp = thread.getLastJavaFP();
        if (fp == null) {
            return null;
        }
        return new X86Frame(thread.getLastJavaSP(), fp);
    }

    @Override
    public RegisterMap newRegisterMap(JavaThread thread, boolean updateMap) {
        return new X86RegisterMap(thread, updateMap);
    }

    @Override
    public Frame getCurrentFrameGuess(JavaThread thread, Address addr) {
        ThreadProxy t = this.getThreadProxy(addr);
        X86ThreadContext context = (X86ThreadContext)t.getContext();
        X86CurrentFrameGuess guesser = new X86CurrentFrameGuess(context, thread);
        if (!guesser.run(131072L)) {
            return null;
        }
        if (guesser.getPC() == null) {
            return new X86Frame(guesser.getSP(), guesser.getFP());
        }
        return new X86Frame(guesser.getSP(), guesser.getFP(), guesser.getPC());
    }

    @Override
    public void printThreadIDOn(Address addr, PrintStream tty) {
        tty.print(this.getThreadProxy(addr));
    }

    @Override
    public void printInfoOn(Address threadAddr, PrintStream tty) {
        tty.print("Thread id: ");
        this.printThreadIDOn(threadAddr, tty);
    }

    @Override
    public Address getLastSP(Address addr) {
        ThreadProxy t = this.getThreadProxy(addr);
        X86ThreadContext context = (X86ThreadContext)t.getContext();
        return context.getRegisterAsAddress(7);
    }

    @Override
    public ThreadProxy getThreadProxy(Address addr) {
        Address osThreadAddr = osThreadField.getValue(addr);
        Address threadIdAddr = osThreadAddr.addOffsetTo(osThreadThreadIDField.getOffset());
        JVMDebugger debugger = VM.getVM().getDebugger();
        return debugger.getThreadForIdentifierAddress(threadIdAddr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                LinuxX86JavaThreadPDAccess.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

