/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.named.support;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Retry {
    private static final Logger LOGGER = LoggerFactory.getLogger(Retry.class);

    private Retry() {
    }

    public static <R> R retry(long time2, TimeUnit unit, long sleepMillis, Callable<R> operation, Predicate<Exception> retryPredicate, R defaultResult) throws InterruptedException {
        long now = System.nanoTime();
        long barrier = now + unit.toNanos(time2);
        int attempt = 1;
        Object result = null;
        while (now < barrier && result == null) {
            block5: {
                try {
                    result = operation.call();
                    if (result == null) {
                        LOGGER.trace("Retry attempt {}: no result", (Object)attempt);
                        Thread.sleep(sleepMillis);
                    }
                }
                catch (InterruptedException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    LOGGER.trace("Retry attempt {}: operation failure", (Object)attempt, (Object)e3);
                    if (retryPredicate == null || retryPredicate.test(e3)) break block5;
                    throw new IllegalStateException(e3);
                }
            }
            now = System.nanoTime();
            ++attempt;
        }
        return (R)(result == null ? defaultResult : result);
    }
}

