/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.commons.io.file.NoopPathVisitor;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.PathVisitor;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class PathVisitorFileFilter
extends AbstractFileFilter {
    private final PathVisitor pathVisitor;

    public PathVisitorFileFilter(PathVisitor pathVisitor) {
        this.pathVisitor = pathVisitor == null ? NoopPathVisitor.INSTANCE : pathVisitor;
    }

    @Override
    public boolean accept(File file2) {
        try {
            Path path2 = file2.toPath();
            return this.visitFile(path2, file2.exists() ? PathUtils.readBasicFileAttributes(path2) : null) == FileVisitResult.CONTINUE;
        }
        catch (IOException e2) {
            return this.handle(e2) == FileVisitResult.CONTINUE;
        }
    }

    @Override
    public boolean accept(File dir2, String name2) {
        try {
            Path path2 = dir2.toPath().resolve(name2);
            return this.accept(path2, PathUtils.readBasicFileAttributes(path2)) == FileVisitResult.CONTINUE;
        }
        catch (IOException e2) {
            return this.handle(e2) == FileVisitResult.CONTINUE;
        }
    }

    @Override
    public FileVisitResult accept(Path path2, BasicFileAttributes attributes) {
        try {
            return Files.isDirectory(path2, new LinkOption[0]) ? this.pathVisitor.postVisitDirectory(path2, null) : this.visitFile(path2, attributes);
        }
        catch (IOException e2) {
            return this.handle(e2);
        }
    }

    @Override
    public FileVisitResult visitFile(Path path2, BasicFileAttributes attributes) throws IOException {
        return this.pathVisitor.visitFile(path2, attributes);
    }
}

