/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.architect.swingui.olap.OLAPObjectListCellRenderer;
import ca.sqlpower.architect.swingui.olap.OLAPObjectNameValidator;
import ca.sqlpower.validation.Validator;
import ca.sqlpower.validation.swingui.FormValidationHandler;
import ca.sqlpower.validation.swingui.StatusComponent;
import ca.sqlpower.validation.swingui.ValidatableDataEntryPanel;
import ca.sqlpower.validation.swingui.ValidationHandler;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class VirtualCubeEditPanel
implements ValidatableDataEntryPanel {
    private final MondrianModel.VirtualCube vCube;
    private final JPanel panel;
    private JTextField nameField;
    private JTextField captionField;
    private JComboBox defMeasure;
    private FormValidationHandler handler;
    private StatusComponent status = new StatusComponent();

    public VirtualCubeEditPanel(MondrianModel.VirtualCube vCube) {
        this.vCube = vCube;
        FormLayout layout = new FormLayout("left:max(40dlu;pref), 3dlu, 80dlu:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append((Component)this.status, 3);
        this.nameField = new JTextField(vCube.getName());
        builder.append("Name", (Component)this.nameField);
        this.captionField = new JTextField(vCube.getCaption());
        builder.append("Caption", (Component)this.captionField);
        ArrayList<MondrianModel.VirtualCubeMeasure> measures = new ArrayList<MondrianModel.VirtualCubeMeasure>(vCube.getMeasures());
        measures.add(0, null);
        this.defMeasure = new JComboBox<Object>(measures.toArray());
        builder.append("Default Measure", this.defMeasure);
        this.defMeasure.setRenderer(new OLAPObjectListCellRenderer());
        for (MondrianModel.VirtualCubeMeasure vMs : vCube.getMeasures()) {
            if (!vMs.getName().equals(vCube.getDefaultMeasure())) continue;
            this.defMeasure.setSelectedItem((Object)vMs);
            break;
        }
        this.handler = new FormValidationHandler(this.status);
        OLAPObjectNameValidator validator = new OLAPObjectNameValidator((OLAPObject)vCube.getParent(), vCube, false);
        this.handler.addValidateObject((JComponent)this.nameField, (Validator)validator);
        this.panel = builder.getPanel();
    }

    public boolean applyChanges() {
        this.vCube.begin("Started modifying virtual cube properties");
        this.vCube.setName(this.nameField.getText());
        if (!this.captionField.getText().equals("")) {
            this.vCube.setCaption(this.captionField.getText());
        } else {
            this.vCube.setCaption(null);
        }
        MondrianModel.VirtualCubeMeasure ms = (MondrianModel.VirtualCubeMeasure)((Object)this.defMeasure.getSelectedItem());
        this.vCube.setDefaultMeasure(ms == null ? null : ms.getName());
        this.vCube.commit();
        return true;
    }

    public void discardChanges() {
    }

    public JComponent getPanel() {
        return this.panel;
    }

    public boolean hasUnsavedChanges() {
        return true;
    }

    public ValidationHandler getValidationHandler() {
        return this.handler;
    }
}

