/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log;

import org.apache.log.ContextMap;
import org.apache.log.ErrorAware;
import org.apache.log.ErrorHandler;
import org.apache.log.LogEvent;
import org.apache.log.LogTarget;
import org.apache.log.Priority;
import org.apache.log.util.LoggerListener;

public class Logger {
    private static final Logger[] EMPTY_SET = new Logger[0];
    public static final char CATEGORY_SEPARATOR = '.';
    private final ErrorHandler m_errorHandler;
    private final LoggerListener m_loggerListener;
    private final Logger m_parent;
    private final String m_category;
    private Logger[] m_children;
    private LogTarget[] m_logTargets;
    private boolean m_logTargetsForceSet;
    private Priority m_priority;
    private boolean m_priorityForceSet;
    private boolean m_additivity;

    Logger(ErrorHandler errorHandler, LoggerListener loggerListener, String category, LogTarget[] logTargets, Logger parent) {
        this.m_errorHandler = errorHandler;
        this.m_loggerListener = loggerListener;
        this.m_category = category;
        this.m_logTargets = logTargets;
        this.m_parent = parent;
        if (null == this.m_logTargets) {
            this.unsetLogTargets();
        }
        this.unsetPriority();
    }

    public final boolean isDebugEnabled() {
        return this.m_priority.isLowerOrEqual(Priority.DEBUG);
    }

    public final void debug(String message, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.output(Priority.DEBUG, message, throwable);
        }
    }

    public final void debug(String message) {
        if (this.isDebugEnabled()) {
            this.output(Priority.DEBUG, message, null);
        }
    }

    public final boolean isInfoEnabled() {
        return this.m_priority.isLowerOrEqual(Priority.INFO);
    }

    public final void info(String message, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.output(Priority.INFO, message, throwable);
        }
    }

    public final void info(String message) {
        if (this.isInfoEnabled()) {
            this.output(Priority.INFO, message, null);
        }
    }

    public final boolean isWarnEnabled() {
        return this.m_priority.isLowerOrEqual(Priority.WARN);
    }

    public final void warn(String message, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.output(Priority.WARN, message, throwable);
        }
    }

    public final void warn(String message) {
        if (this.isWarnEnabled()) {
            this.output(Priority.WARN, message, null);
        }
    }

    public final boolean isErrorEnabled() {
        return this.m_priority.isLowerOrEqual(Priority.ERROR);
    }

    public final void error(String message, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.output(Priority.ERROR, message, throwable);
        }
    }

    public final void error(String message) {
        if (this.isErrorEnabled()) {
            this.output(Priority.ERROR, message, null);
        }
    }

    public final boolean isFatalErrorEnabled() {
        return this.m_priority.isLowerOrEqual(Priority.FATAL_ERROR);
    }

    public final void fatalError(String message, Throwable throwable) {
        if (this.isFatalErrorEnabled()) {
            this.output(Priority.FATAL_ERROR, message, throwable);
        }
    }

    public final void fatalError(String message) {
        if (this.isFatalErrorEnabled()) {
            this.output(Priority.FATAL_ERROR, message, null);
        }
    }

    public final void setAdditivity(boolean additivity) {
        this.m_additivity = additivity;
    }

    public final boolean isPriorityEnabled(Priority priority) {
        return this.m_priority.isLowerOrEqual(priority);
    }

    public final void log(Priority priority, String message, Throwable throwable) {
        if (this.m_priority.isLowerOrEqual(priority)) {
            this.output(priority, message, throwable);
        }
    }

    public final void log(Priority priority, String message) {
        if (this.m_priority.isLowerOrEqual(priority)) {
            this.log(priority, message, null);
        }
    }

    public synchronized void setPriority(Priority priority) {
        this.m_priority = priority;
        this.m_priorityForceSet = true;
        this.resetChildPriorities(false);
    }

    public synchronized void unsetPriority() {
        this.unsetPriority(false);
    }

    public synchronized void unsetPriority(boolean recursive) {
        this.m_priority = null != this.m_parent ? this.m_parent.m_priority : Priority.DEBUG;
        this.m_priorityForceSet = false;
        this.resetChildPriorities(recursive);
    }

    public synchronized void setLogTargets(LogTarget[] logTargets) {
        if (null != logTargets) {
            for (int i = 0; i < logTargets.length; ++i) {
                if (null != logTargets[i]) continue;
                String message = "logTargets[ " + i + " ]";
                throw new NullPointerException(message);
            }
        }
        this.m_logTargets = logTargets;
        this.setupErrorHandlers();
        this.m_logTargetsForceSet = true;
        this.resetChildLogTargets(false);
    }

    public synchronized void unsetLogTargets() {
        this.unsetLogTargets(false);
    }

    public synchronized void unsetLogTargets(boolean recursive) {
        this.m_logTargets = null != this.m_parent ? this.m_parent.safeGetLogTargets() : null;
        this.m_logTargetsForceSet = false;
        this.resetChildLogTargets(recursive);
    }

    public synchronized Logger[] getChildren() {
        if (null == this.m_children) {
            return EMPTY_SET;
        }
        Logger[] children = new Logger[this.m_children.length];
        for (int i = 0; i < children.length; ++i) {
            children[i] = this.m_children[i];
        }
        return children;
    }

    public synchronized Logger getChildLogger(String subCategory) throws IllegalArgumentException {
        int end = subCategory.indexOf(46);
        String nextCategory = null;
        String remainder = null;
        if (-1 == end) {
            nextCategory = subCategory;
        } else {
            if (end == 0) {
                throw new IllegalArgumentException("Logger categories MUST not have empty elements");
            }
            nextCategory = subCategory.substring(0, end);
            remainder = subCategory.substring(end + 1);
        }
        String category = null;
        category = this.m_category.equals("") ? nextCategory : this.m_category + '.' + nextCategory;
        if (null != this.m_children) {
            for (int i = 0; i < this.m_children.length; ++i) {
                if (!this.m_children[i].m_category.equals(category)) continue;
                if (null == remainder) {
                    return this.m_children[i];
                }
                return this.m_children[i].getChildLogger(remainder);
            }
        }
        Logger child = new Logger(this.m_errorHandler, this.m_loggerListener, category, null, this);
        if (this.m_additivity) {
            child.setAdditivity(true);
        }
        this.m_loggerListener.loggerCreated(child.m_category, child);
        if (null == this.m_children) {
            this.m_children = new Logger[]{child};
        } else {
            Logger[] children = new Logger[this.m_children.length + 1];
            System.arraycopy(this.m_children, 0, children, 0, this.m_children.length);
            children[this.m_children.length] = child;
            this.m_children = children;
        }
        if (null == remainder) {
            return child;
        }
        return child.getChildLogger(remainder);
    }

    private final void output(Priority priority, String message, Throwable throwable) {
        LogEvent event = new LogEvent();
        event.setCategory(this.m_category);
        event.setContextMap(ContextMap.getCurrentContext(false));
        if (null != message) {
            event.setMessage(message);
        } else {
            event.setMessage("");
        }
        event.setThrowable(throwable);
        event.setPriority(priority);
        event.setTime(System.currentTimeMillis());
        this.output(event);
    }

    private final void output(LogEvent event) {
        LogTarget[] targets = this.m_logTargets;
        if (null == targets) {
            String message = "LogTarget is null for category '" + this.m_category + "'";
            this.m_errorHandler.error(message, null, event);
        } else if (!this.m_additivity) {
            this.fireEvent(event, targets);
        } else {
            if (this.m_logTargetsForceSet) {
                this.fireEvent(event, targets);
            }
            if (null != this.m_parent) {
                this.m_parent.output(event);
            }
        }
    }

    private final void fireEvent(LogEvent event, LogTarget[] targets) {
        for (int i = 0; i < targets.length; ++i) {
            targets[i].processEvent(event);
        }
    }

    private synchronized void resetChildPriorities(boolean recursive) {
        if (null == this.m_children) {
            return;
        }
        Logger[] children = this.m_children;
        for (int i = 0; i < children.length; ++i) {
            children[i].resetPriority(recursive);
        }
    }

    private synchronized void resetPriority(boolean recursive) {
        if (recursive) {
            this.m_priorityForceSet = false;
        } else if (this.m_priorityForceSet) {
            return;
        }
        this.m_priority = this.m_parent.m_priority;
        this.resetChildPriorities(recursive);
    }

    private synchronized LogTarget[] safeGetLogTargets() {
        if (null == this.m_logTargets) {
            if (null == this.m_parent) {
                return new LogTarget[0];
            }
            return this.m_parent.safeGetLogTargets();
        }
        LogTarget[] logTargets = new LogTarget[this.m_logTargets.length];
        for (int i = 0; i < logTargets.length; ++i) {
            logTargets[i] = this.m_logTargets[i];
        }
        return logTargets;
    }

    private synchronized void resetChildLogTargets(boolean recursive) {
        if (null == this.m_children) {
            return;
        }
        for (int i = 0; i < this.m_children.length; ++i) {
            this.m_children[i].resetLogTargets(recursive);
        }
    }

    private synchronized void setupErrorHandlers() {
        if (null == this.m_logTargets) {
            return;
        }
        for (int i = 0; i < this.m_logTargets.length; ++i) {
            LogTarget target = this.m_logTargets[i];
            if (!(target instanceof ErrorAware)) continue;
            ((ErrorAware)((Object)target)).setErrorHandler(this.m_errorHandler);
        }
    }

    private synchronized void resetLogTargets(boolean recursive) {
        if (recursive) {
            this.m_logTargetsForceSet = false;
        } else if (this.m_logTargetsForceSet) {
            return;
        }
        this.m_logTargets = this.m_parent.safeGetLogTargets();
        this.resetChildLogTargets(recursive);
    }
}

