"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sampleLogPatternData = exports.VIZ_CONTAIN_XY_AXIS = exports.VALUEFIELD = exports.UNSELECTED_FIELDS = exports.UNITS_OF_MEASURE = exports.TYPE_TAB_MAPPING = exports.TIME_INTERVAL_OPTIONS = exports.TIME_FIELD = exports.TIMESTAMP = exports.TAB_TITLE = exports.TAB_ID_TXT_PFX = exports.TAB_EVENT_TITLE = exports.TAB_EVENT_ID_TXT_PFX = exports.TAB_EVENT_ID = exports.TAB_CREATED_TYPE = exports.TAB_CHART_TITLE = exports.TAB_CHART_ID_TXT_PFX = exports.TAB_CHART_ID = exports.SPAN = exports.SIMILAR_VIZ_TYPES = exports.SELECTED_TIMESTAMP = exports.SELECTED_QUERY_TAB = exports.SELECTED_PATTERN_FIELD = exports.SELECTED_FIELDS = exports.SELECTED_DATE_RANGE = exports.SAVED_VISUALIZATION = exports.SAVED_QUERY = exports.SAVED_OBJECT_TYPE = exports.SAVED_OBJECT_ID = exports.ROW_DENSITIES = exports.REDUX_EXPL_SLICE_VISUALIZATION = exports.REDUX_EXPL_SLICE_QUERY_TABS = exports.REDUX_EXPL_SLICE_QUERY_RESULT = exports.REDUX_EXPL_SLICE_QUERIES = exports.REDUX_EXPL_SLICE_PATTERNS = exports.REDUX_EXPL_SLICE_FIELDS = exports.REDUX_EXPL_SLICE_COUNT_DISTRIBUTION = exports.REDIRECT_TAB = exports.RAW_QUERY = exports.QUERY_TAB_IDS = exports.QUERIED_FIELDS = exports.PPL_DEFAULT_PATTERN_REGEX_FILETER = exports.PLOTLY_PIE_COLUMN_NUMBER = exports.PLOTLY_GAUGE_COLUMN_NUMBER = exports.PIE_YAXIS_GAP = exports.PIE_XAXIS_GAP = exports.PATTERN_REGEX = exports.PATTERNS_REGEX = exports.PATTERNS_EXTRACTOR_REGEX = exports.PARENTFIELDS = exports.PAGE_SIZE = exports.OTEL_TRACE_ID = exports.OPEN_TELEMETRY_LOG_CORRELATION_LINK = exports.NUMERICAL_TYPES = exports.NUMBER_INPUT_MIN_LIMIT = exports.NEW_TAB = exports.NEW_SELECTED_QUERY_TAB = exports.METRICS_SERIES_UNIT_SUBSTRING_LENGTH = exports.METRICS_REDUCE_VALUE_SIZE_PERCENTAGE = exports.METRICS_REDUCE_TITLE_SIZE_PERCENTAGE = exports.METRICS_REDUCE_SERIES_UNIT_SIZE_PERCENTAGE = exports.METRICS_GRID_SPACE_BETWEEN_Y_AXIS = exports.METRICS_GRID_SPACE_BETWEEN_X_AXIS = exports.METRICS_AXIS_MARGIN = exports.METRICS_ANNOTATION = exports.JAEGER_TRACE_ID = exports.INDEX = exports.HEADER_HEIGHT = exports.HAS_SAVED_TIMESTAMP = exports.GROUPBY = exports.GRID_PAGE_SIZES = exports.GRID_PAGE_RANGE_DISPLAY = exports.GRID_HEADER_COLUMN_MAX_WIDTH = exports.FINAL_QUERY = exports.FILTER_OPTIONS = exports.FILTERED_PATTERN = exports.EVENT_ANALYTICS_DOCUMENTATION_URL = exports.DISABLED_COLOUR = exports.DEFAULT_PIE_CHART_PARAMETERS = exports.DEFAULT_METRICS_CHART_PARAMETERS = exports.DEFAULT_GAUGE_CHART_PARAMETERS = exports.DEFAULT_COLUMNS = exports.DEFAULT_BAR_CHART_STYLES = exports.DEFAULT_AVAILABILITY_QUERY = exports.DATE_PICKER_FORMAT = exports.DATA_CONFIG_HINTS_INFO = exports.ConfigChartOptionsEnum = exports.CUSTOM_LABEL = exports.CREATE_TAB_PARAM_KEY = exports.CREATE_TAB_PARAM = exports.COLUMN_DEFAULT_MIN_WIDTH = exports.CHILDFIELD = exports.BREAKDOWNS = exports.AVAILABLE_FIELDS = exports.APP_ANALYTICS_TAB_ID_REGEX = exports.AGGREGATION_OPTIONS = exports.AGGREGATIONS = exports.ADD_BUTTON_TEXT = void 0;

var _eui = require("@elastic/eui");

var _shared = require("./shared");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const EVENT_ANALYTICS_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/observability-plugin/event-analytics/';
exports.EVENT_ANALYTICS_DOCUMENTATION_URL = EVENT_ANALYTICS_DOCUMENTATION_URL;
const OPEN_TELEMETRY_LOG_CORRELATION_LINK = 'https://opentelemetry.io/docs/reference/specification/logs/overview/#log-correlation';
exports.OPEN_TELEMETRY_LOG_CORRELATION_LINK = OPEN_TELEMETRY_LOG_CORRELATION_LINK;
const RAW_QUERY = 'rawQuery';
exports.RAW_QUERY = RAW_QUERY;
const FINAL_QUERY = 'finalQuery';
exports.FINAL_QUERY = FINAL_QUERY;
const SELECTED_DATE_RANGE = 'selectedDateRange';
exports.SELECTED_DATE_RANGE = SELECTED_DATE_RANGE;
const INDEX = 'index';
exports.INDEX = INDEX;
const SELECTED_PATTERN_FIELD = 'selectedPatternField';
exports.SELECTED_PATTERN_FIELD = SELECTED_PATTERN_FIELD;
const PATTERN_REGEX = 'patternRegex';
exports.PATTERN_REGEX = PATTERN_REGEX;
const FILTERED_PATTERN = 'filteredPattern';
exports.FILTERED_PATTERN = FILTERED_PATTERN;
const SELECTED_TIMESTAMP = 'selectedTimestamp';
exports.SELECTED_TIMESTAMP = SELECTED_TIMESTAMP;
const SELECTED_FIELDS = 'selectedFields';
exports.SELECTED_FIELDS = SELECTED_FIELDS;
const UNSELECTED_FIELDS = 'unselectedFields';
exports.UNSELECTED_FIELDS = UNSELECTED_FIELDS;
const AVAILABLE_FIELDS = 'availableFields';
exports.AVAILABLE_FIELDS = AVAILABLE_FIELDS;
const QUERIED_FIELDS = 'queriedFields';
exports.QUERIED_FIELDS = QUERIED_FIELDS;
const TAB_ID_TXT_PFX = 'explorer-tab-';
exports.TAB_ID_TXT_PFX = TAB_ID_TXT_PFX;
const TAB_TITLE = 'New query';
exports.TAB_TITLE = TAB_TITLE;
const TAB_CHART_TITLE = 'Visualizations';
exports.TAB_CHART_TITLE = TAB_CHART_TITLE;
const TAB_EVENT_TITLE = 'Events';
exports.TAB_EVENT_TITLE = TAB_EVENT_TITLE;
const TAB_EVENT_ID_TXT_PFX = 'main-content-events-';
exports.TAB_EVENT_ID_TXT_PFX = TAB_EVENT_ID_TXT_PFX;
const TAB_CHART_ID_TXT_PFX = 'main-content-vis-';
exports.TAB_CHART_ID_TXT_PFX = TAB_CHART_ID_TXT_PFX;
const TAB_EVENT_ID = 'main-content-events';
exports.TAB_EVENT_ID = TAB_EVENT_ID;
const TAB_CHART_ID = 'main-content-vis';
exports.TAB_CHART_ID = TAB_CHART_ID;
const CREATE_TAB_PARAM_KEY = 'create';
exports.CREATE_TAB_PARAM_KEY = CREATE_TAB_PARAM_KEY;
const CREATE_TAB_PARAM = {
  [TAB_EVENT_ID]: 'events',
  [TAB_CHART_ID]: 'visualizations'
};
exports.CREATE_TAB_PARAM = CREATE_TAB_PARAM;
const HAS_SAVED_TIMESTAMP = 'hasSavedTimestamp';
exports.HAS_SAVED_TIMESTAMP = HAS_SAVED_TIMESTAMP;
const FILTER_OPTIONS = ['Visualization', 'Query', 'Metric'];
exports.FILTER_OPTIONS = FILTER_OPTIONS;
const SAVED_QUERY = 'savedQuery';
exports.SAVED_QUERY = SAVED_QUERY;
const SAVED_VISUALIZATION = 'savedVisualization';
exports.SAVED_VISUALIZATION = SAVED_VISUALIZATION;
const SAVED_OBJECT_ID = 'savedObjectId';
exports.SAVED_OBJECT_ID = SAVED_OBJECT_ID;
const SAVED_OBJECT_TYPE = 'objectType';
exports.SAVED_OBJECT_TYPE = SAVED_OBJECT_TYPE;
const TAB_CREATED_TYPE = 'tabCreatedType';
exports.TAB_CREATED_TYPE = TAB_CREATED_TYPE;
const NEW_TAB = 'newTab';
exports.NEW_TAB = NEW_TAB;
const REDIRECT_TAB = 'redirect_tab';
exports.REDIRECT_TAB = REDIRECT_TAB;
const PAGE_SIZE = 50;
exports.PAGE_SIZE = PAGE_SIZE;
const DEFAULT_COLUMNS = ['', 'Time', '_source'];
exports.DEFAULT_COLUMNS = DEFAULT_COLUMNS;
const OTEL_TRACE_ID = 'traceId';
exports.OTEL_TRACE_ID = OTEL_TRACE_ID;
const JAEGER_TRACE_ID = 'traceID';
exports.JAEGER_TRACE_ID = JAEGER_TRACE_ID;
const DATE_PICKER_FORMAT = 'YYYY-MM-DD HH:mm:ss';
exports.DATE_PICKER_FORMAT = DATE_PICKER_FORMAT;
const TIME_INTERVAL_OPTIONS = [{
  text: 'Minute',
  value: 'm'
}, {
  text: 'Hour',
  value: 'h'
}, {
  text: 'Day',
  value: 'd'
}, {
  text: 'Week',
  value: 'w'
}, {
  text: 'Month',
  value: 'M'
}, {
  text: 'Year',
  value: 'y'
}]; // redux

exports.TIME_INTERVAL_OPTIONS = TIME_INTERVAL_OPTIONS;
const SELECTED_QUERY_TAB = 'selectedQueryTab';
exports.SELECTED_QUERY_TAB = SELECTED_QUERY_TAB;
const QUERY_TAB_IDS = 'queryTabIds';
exports.QUERY_TAB_IDS = QUERY_TAB_IDS;
const NEW_SELECTED_QUERY_TAB = 'newSelectedQueryTab';
exports.NEW_SELECTED_QUERY_TAB = NEW_SELECTED_QUERY_TAB;
const REDUX_EXPL_SLICE_QUERIES = 'queries';
exports.REDUX_EXPL_SLICE_QUERIES = REDUX_EXPL_SLICE_QUERIES;
const REDUX_EXPL_SLICE_QUERY_RESULT = 'queryResults';
exports.REDUX_EXPL_SLICE_QUERY_RESULT = REDUX_EXPL_SLICE_QUERY_RESULT;
const REDUX_EXPL_SLICE_FIELDS = 'fields';
exports.REDUX_EXPL_SLICE_FIELDS = REDUX_EXPL_SLICE_FIELDS;
const REDUX_EXPL_SLICE_QUERY_TABS = 'queryTabs';
exports.REDUX_EXPL_SLICE_QUERY_TABS = REDUX_EXPL_SLICE_QUERY_TABS;
const REDUX_EXPL_SLICE_VISUALIZATION = 'explorerVisualization';
exports.REDUX_EXPL_SLICE_VISUALIZATION = REDUX_EXPL_SLICE_VISUALIZATION;
const REDUX_EXPL_SLICE_COUNT_DISTRIBUTION = 'countDistributionVisualization';
exports.REDUX_EXPL_SLICE_COUNT_DISTRIBUTION = REDUX_EXPL_SLICE_COUNT_DISTRIBUTION;
const REDUX_EXPL_SLICE_PATTERNS = 'patterns';
exports.REDUX_EXPL_SLICE_PATTERNS = REDUX_EXPL_SLICE_PATTERNS;
const PLOTLY_GAUGE_COLUMN_NUMBER = 4;
exports.PLOTLY_GAUGE_COLUMN_NUMBER = PLOTLY_GAUGE_COLUMN_NUMBER;
const APP_ANALYTICS_TAB_ID_REGEX = /application-analytics-tab.+/;
exports.APP_ANALYTICS_TAB_ID_REGEX = APP_ANALYTICS_TAB_ID_REGEX;
const DEFAULT_AVAILABILITY_QUERY = 'stats count() by span( timestamp, 1h )';
exports.DEFAULT_AVAILABILITY_QUERY = DEFAULT_AVAILABILITY_QUERY;
const PPL_DEFAULT_PATTERN_REGEX_FILETER = '[a-zA-Z\\d]'; // Greedily matches the longest substring for example (patterns referer | patterns pattern='[0-9]' message | where ...) used to modify the query for patterns table

exports.PPL_DEFAULT_PATTERN_REGEX_FILETER = PPL_DEFAULT_PATTERN_REGEX_FILETER;
const PATTERNS_REGEX = /\|\s*patterns.+?\|.*\s*where\s+patterns_field\s*\=\s*'[^a-zA-Z0-9]+'/; // Used to extract the initial pattern applied

exports.PATTERNS_REGEX = PATTERNS_REGEX;
const PATTERNS_EXTRACTOR_REGEX = /patterns\s+(?<pattern>\S+)/;
exports.PATTERNS_EXTRACTOR_REGEX = PATTERNS_EXTRACTOR_REGEX;
const ADD_BUTTON_TEXT = '+ Add color theme';
exports.ADD_BUTTON_TEXT = ADD_BUTTON_TEXT;
const NUMBER_INPUT_MIN_LIMIT = 1;
exports.NUMBER_INPUT_MIN_LIMIT = NUMBER_INPUT_MIN_LIMIT;
const VIZ_CONTAIN_XY_AXIS = [_shared.VIS_CHART_TYPES.Bar, _shared.VIS_CHART_TYPES.Histogram, _shared.VIS_CHART_TYPES.Line, _shared.VIS_CHART_TYPES.Pie, _shared.VIS_CHART_TYPES.Scatter, _shared.VIS_CHART_TYPES.HorizontalBar]; // default ppl aggregation method options

exports.VIZ_CONTAIN_XY_AXIS = VIZ_CONTAIN_XY_AXIS;
const AGGREGATION_OPTIONS = [{
  label: 'count'
}, {
  label: 'sum'
}, {
  label: 'avg'
}, {
  label: 'max'
}, {
  label: 'min'
}, {
  label: 'var_samp'
}, {
  label: 'var_pop'
}, {
  label: 'stddev_samp'
}, {
  label: 'stddev_pop'
}]; // numeric fields type for metrics

exports.AGGREGATION_OPTIONS = AGGREGATION_OPTIONS;
const NUMERICAL_TYPES = ['float', 'double', 'bigint', 'long', 'octet', 'short', 'byte', 'integer']; // Data table constants

exports.NUMERICAL_TYPES = NUMERICAL_TYPES;
const GRID_HEADER_COLUMN_MAX_WIDTH = '150px';
exports.GRID_HEADER_COLUMN_MAX_WIDTH = GRID_HEADER_COLUMN_MAX_WIDTH;
const GRID_PAGE_RANGE_DISPLAY = 5;
exports.GRID_PAGE_RANGE_DISPLAY = GRID_PAGE_RANGE_DISPLAY;
const COLUMN_DEFAULT_MIN_WIDTH = 100;
exports.COLUMN_DEFAULT_MIN_WIDTH = COLUMN_DEFAULT_MIN_WIDTH;
const GRID_PAGE_SIZES = [10, 50, 100];
exports.GRID_PAGE_SIZES = GRID_PAGE_SIZES;
const ROW_DENSITIES = [{
  icon: 'tableDensityExpanded',
  height: 55,
  selected: false
}, {
  icon: 'tableDensityNormal',
  height: 45,
  selected: false
}, {
  icon: 'tableDensityCompact',
  height: 35,
  selected: true
}];
exports.ROW_DENSITIES = ROW_DENSITIES;
const HEADER_HEIGHT = 35; // gauge chart default parameters

exports.HEADER_HEIGHT = HEADER_HEIGHT;
const DEFAULT_GAUGE_CHART_PARAMETERS = {
  GaugeTitleSize: 14,
  DisplayDefaultGauges: 1,
  OrientationDefault: 'h',
  TickLength: 5,
  LegendPlacement: 'center',
  ThresholdsMaxLimit: 1
}; // pie chart default parameters

exports.DEFAULT_GAUGE_CHART_PARAMETERS = DEFAULT_GAUGE_CHART_PARAMETERS;
const PLOTLY_PIE_COLUMN_NUMBER = 2;
exports.PLOTLY_PIE_COLUMN_NUMBER = PLOTLY_PIE_COLUMN_NUMBER;
const PIE_XAXIS_GAP = 0.2;
exports.PIE_XAXIS_GAP = PIE_XAXIS_GAP;
const PIE_YAXIS_GAP = 0.1;
exports.PIE_YAXIS_GAP = PIE_YAXIS_GAP;
const DEFAULT_PIE_CHART_PARAMETERS = {
  DefaultMode: 'pie'
};
exports.DEFAULT_PIE_CHART_PARAMETERS = DEFAULT_PIE_CHART_PARAMETERS;
const GROUPBY = 'dimensions';
exports.GROUPBY = GROUPBY;
const AGGREGATIONS = 'series';
exports.AGGREGATIONS = AGGREGATIONS;
const PARENTFIELDS = 'parentFields';
exports.PARENTFIELDS = PARENTFIELDS;
const VALUEFIELD = 'valueField';
exports.VALUEFIELD = VALUEFIELD;
const CHILDFIELD = 'childField';
exports.CHILDFIELD = CHILDFIELD;
const TIMESTAMP = 'timestamp'; // metrics constants

exports.TIMESTAMP = TIMESTAMP;
const METRICS_GRID_SPACE_BETWEEN_X_AXIS = 0.01;
exports.METRICS_GRID_SPACE_BETWEEN_X_AXIS = METRICS_GRID_SPACE_BETWEEN_X_AXIS;
const METRICS_GRID_SPACE_BETWEEN_Y_AXIS = 100;
exports.METRICS_GRID_SPACE_BETWEEN_Y_AXIS = METRICS_GRID_SPACE_BETWEEN_Y_AXIS;
const METRICS_REDUCE_VALUE_SIZE_PERCENTAGE = 0.08;
exports.METRICS_REDUCE_VALUE_SIZE_PERCENTAGE = METRICS_REDUCE_VALUE_SIZE_PERCENTAGE;
const METRICS_REDUCE_TITLE_SIZE_PERCENTAGE = 0.05;
exports.METRICS_REDUCE_TITLE_SIZE_PERCENTAGE = METRICS_REDUCE_TITLE_SIZE_PERCENTAGE;
const METRICS_REDUCE_SERIES_UNIT_SIZE_PERCENTAGE = 0.2;
exports.METRICS_REDUCE_SERIES_UNIT_SIZE_PERCENTAGE = METRICS_REDUCE_SERIES_UNIT_SIZE_PERCENTAGE;
const METRICS_SERIES_UNIT_SUBSTRING_LENGTH = 3;
exports.METRICS_SERIES_UNIT_SUBSTRING_LENGTH = METRICS_SERIES_UNIT_SUBSTRING_LENGTH;
const METRICS_AXIS_MARGIN = {
  l: 0,
  r: 0,
  b: 0,
  t: 80
};
exports.METRICS_AXIS_MARGIN = METRICS_AXIS_MARGIN;
const METRICS_ANNOTATION = {
  xref: 'paper',
  yref: 'paper',
  showarrow: false
};
exports.METRICS_ANNOTATION = METRICS_ANNOTATION;
const DEFAULT_METRICS_CHART_PARAMETERS = {
  DefaultTextMode: 'auto',
  DefaultOrientation: 'auto',
  DefaultTitleSize: 30,
  DefaultValueSize: 80,
  DefaultChartType: 'auto',
  TextAlignment: 'auto',
  DefaultPrecision: 1,
  BaseThreshold: {
    thid: (0, _eui.htmlIdGenerator)('thr')(),
    name: 'Base',
    color: '#3CA1C7',
    value: 0,
    isReadOnly: true
  },
  DefaultTextColor: '#FFFFFF'
};
exports.DEFAULT_METRICS_CHART_PARAMETERS = DEFAULT_METRICS_CHART_PARAMETERS;
const DEFAULT_BAR_CHART_STYLES = {
  BarMode: 'group',
  GroupWidth: 0.7,
  BarWidth: 0.97,
  LabelSize: 12
};
exports.DEFAULT_BAR_CHART_STYLES = DEFAULT_BAR_CHART_STYLES;
const SIMILAR_VIZ_TYPES = [_shared.VIS_CHART_TYPES.Line, _shared.VIS_CHART_TYPES.Scatter, _shared.VIS_CHART_TYPES.HorizontalBar, _shared.VIS_CHART_TYPES.Bar];
exports.SIMILAR_VIZ_TYPES = SIMILAR_VIZ_TYPES;
let ConfigChartOptionsEnum;
exports.ConfigChartOptionsEnum = ConfigChartOptionsEnum;

(function (ConfigChartOptionsEnum) {
  ConfigChartOptionsEnum["palettePicker"] = "palettePicker";
  ConfigChartOptionsEnum["singleColorPicker"] = "singleColorPicker";
  ConfigChartOptionsEnum["colorpicker"] = "colorpicker";
  ConfigChartOptionsEnum["treemapColorPicker"] = "treemapColorPicker";
  ConfigChartOptionsEnum["input"] = "input";
  ConfigChartOptionsEnum["textInput"] = "textInput";
  ConfigChartOptionsEnum["slider"] = "slider";
  ConfigChartOptionsEnum["switchButton"] = "switchButton";
  ConfigChartOptionsEnum["buttons"] = "buttons";
})(ConfigChartOptionsEnum || (exports.ConfigChartOptionsEnum = ConfigChartOptionsEnum = {}));

const CUSTOM_LABEL = 'customLabel';
exports.CUSTOM_LABEL = CUSTOM_LABEL;
const BREAKDOWNS = 'breakdowns';
exports.BREAKDOWNS = BREAKDOWNS;
const SPAN = 'span';
exports.SPAN = SPAN;
const TIME_FIELD = 'time_field';
exports.TIME_FIELD = TIME_FIELD;
const DISABLED_COLOUR = '#fafbfd';
exports.DISABLED_COLOUR = DISABLED_COLOUR;
const DATA_CONFIG_HINTS_INFO = {
  [AGGREGATIONS]: 'Series is an aggregation function (mandatory). The argument of an aggregation must be a field.',
  [GROUPBY]: "Dimensions are 'by' clauses. They are fields or expressions like scalar and aggregation functions. Besides, the span clause for a dimension can be used to split a specific field into buckets in the same interval, the stats then does the aggregation by these span buckets.",
  [BREAKDOWNS]: "Defines how each series is broken down. Breakdowns are 'by' clauses that subdivide the existing series."
}; // Metrics constants

exports.DATA_CONFIG_HINTS_INFO = DATA_CONFIG_HINTS_INFO;
const UNITS_OF_MEASURE = ['seconds (s)', 'hours (h)', 'celsius (C)', 'farenheit (F)', 'meters (m)', 'kilometers (k)'];
exports.UNITS_OF_MEASURE = UNITS_OF_MEASURE;
const sampleLogPatternData = {
  count: 5,
  pattern: '[a-zA-Zd]',
  sampleLog: '218.148.135.12 - - [2018-07-22T04:18:12.345Z] "GET /beats/filebeat/filebeat-6.3.2-linux-x86_64.tar.gz_1 HTTP/1.1" 200 4531 "-" \
           "Mozilla/5.0 (X11; Linux x86_64; rv:6.0a1) Gecko/20110421 Firefox/6.0a1"',
  anomalyCount: 0
};
exports.sampleLogPatternData = sampleLogPatternData;
const TYPE_TAB_MAPPING = {
  [SAVED_QUERY]: TAB_EVENT_ID,
  [SAVED_VISUALIZATION]: TAB_CHART_ID
};
exports.TYPE_TAB_MAPPING = TYPE_TAB_MAPPING;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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