/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.tinyexr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class EXRBox2i
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MIN_X;
    public static final int MIN_Y;
    public static final int MAX_X;
    public static final int MAX_Y;

    public EXRBox2i(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), EXRBox2i.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int min_x() {
        return EXRBox2i.nmin_x(this.address());
    }

    public int min_y() {
        return EXRBox2i.nmin_y(this.address());
    }

    public int max_x() {
        return EXRBox2i.nmax_x(this.address());
    }

    public int max_y() {
        return EXRBox2i.nmax_y(this.address());
    }

    public EXRBox2i min_x(int value) {
        EXRBox2i.nmin_x(this.address(), value);
        return this;
    }

    public EXRBox2i min_y(int value) {
        EXRBox2i.nmin_y(this.address(), value);
        return this;
    }

    public EXRBox2i max_x(int value) {
        EXRBox2i.nmax_x(this.address(), value);
        return this;
    }

    public EXRBox2i max_y(int value) {
        EXRBox2i.nmax_y(this.address(), value);
        return this;
    }

    public EXRBox2i set(int min_x, int min_y, int max_x, int max_y) {
        this.min_x(min_x);
        this.min_y(min_y);
        this.max_x(max_x);
        this.max_y(max_y);
        return this;
    }

    public EXRBox2i set(EXRBox2i src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static EXRBox2i malloc() {
        return (EXRBox2i)EXRBox2i.wrap(EXRBox2i.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static EXRBox2i calloc() {
        return (EXRBox2i)EXRBox2i.wrap(EXRBox2i.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static EXRBox2i create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (EXRBox2i)EXRBox2i.wrap(EXRBox2i.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static EXRBox2i create(long address) {
        return (EXRBox2i)EXRBox2i.wrap(EXRBox2i.class, (long)address);
    }

    @Nullable
    public static EXRBox2i createSafe(long address) {
        return address == 0L ? null : (EXRBox2i)EXRBox2i.wrap(EXRBox2i.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)EXRBox2i.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)EXRBox2i.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)EXRBox2i.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = EXRBox2i.__create((int)capacity, (int)SIZEOF);
        return (Buffer)EXRBox2i.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)EXRBox2i.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)EXRBox2i.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static EXRBox2i malloc(MemoryStack stack) {
        return (EXRBox2i)EXRBox2i.wrap(EXRBox2i.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static EXRBox2i calloc(MemoryStack stack) {
        return (EXRBox2i)EXRBox2i.wrap(EXRBox2i.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)EXRBox2i.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)EXRBox2i.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nmin_x(long struct) {
        return UNSAFE.getInt(null, struct + (long)MIN_X);
    }

    public static int nmin_y(long struct) {
        return UNSAFE.getInt(null, struct + (long)MIN_Y);
    }

    public static int nmax_x(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAX_X);
    }

    public static int nmax_y(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAX_Y);
    }

    public static void nmin_x(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MIN_X, value);
    }

    public static void nmin_y(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MIN_Y, value);
    }

    public static void nmax_x(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAX_X, value);
    }

    public static void nmax_y(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAX_Y, value);
    }

    static {
        Struct.Layout layout = EXRBox2i.__struct((Struct.Member[])new Struct.Member[]{EXRBox2i.__member((int)4), EXRBox2i.__member((int)4), EXRBox2i.__member((int)4), EXRBox2i.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MIN_X = layout.offsetof(0);
        MIN_Y = layout.offsetof(1);
        MAX_X = layout.offsetof(2);
        MAX_Y = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<EXRBox2i, Buffer>
    implements NativeResource {
        private static final EXRBox2i ELEMENT_FACTORY = EXRBox2i.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected EXRBox2i getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int min_x() {
            return EXRBox2i.nmin_x(this.address());
        }

        public int min_y() {
            return EXRBox2i.nmin_y(this.address());
        }

        public int max_x() {
            return EXRBox2i.nmax_x(this.address());
        }

        public int max_y() {
            return EXRBox2i.nmax_y(this.address());
        }

        public Buffer min_x(int value) {
            EXRBox2i.nmin_x(this.address(), value);
            return this;
        }

        public Buffer min_y(int value) {
            EXRBox2i.nmin_y(this.address(), value);
            return this;
        }

        public Buffer max_x(int value) {
            EXRBox2i.nmax_x(this.address(), value);
            return this;
        }

        public Buffer max_y(int value) {
            EXRBox2i.nmax_y(this.address(), value);
            return this;
        }
    }
}

